/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.plugin;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class CadreParamPlugin
extends AbstractFormPlugin {
    private static final String TENURE_FLEX = "tenureflex";
    private static final String TENUREOP_FLEX = "tenureopflex";
    private static final String CREATETENURE_FLEX = "createtenureflex";
    private static final String EXPIRETENURE_FLEX = "expiretenureflex";
    private static final String PANELAP_FLEX = "flexpanelap";
    private static final String IS_OPENCADM = "isopencadm";
    private static final String IS_TENURE = "istenure";
    private static final String IS_CREATETENURE = "iscreatetenure";
    private static final String IS_EXPIRETENURE = "isexpiretenure";
    private static final String FUNCTIONAL_ORG = "15";
    private static final Long DEFAULT_ORG_ID = OrgUnitServiceHelper.getRootOrgId();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean isOpenCadm = this.getOpenCadm();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PANELAP_FLEX});
        if (!isOpenCadm) {
            this.dealWithOpencadm();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PANELAP_FLEX});
        }
        boolean isTenure = this.getModel().getDataEntity().getBoolean(IS_TENURE);
        this.dealWithTenure(isTenure);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (IS_TENURE.equals(propertyName)) {
            boolean isTenure = this.getModel().getDataEntity().getBoolean(IS_TENURE);
            this.dealWithTenure(isTenure);
            this.clearTenureUnderParam();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isOpenCadm;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("donothing".equals(operateKey) && !(isOpenCadm = this.getOpenCadm())) {
            args.setCancelMessage(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53c2\u6570\u914d\u7f6e\u5df2\u7981\u7528\uff0c\u5982\u9700\u542f\u7528\uff0c\u8bf7\u5148\u524d\u5f80\u201cHR\u57fa\u7840\u670d\u52a1\u4e91_HR\u57fa\u7840\u670d\u52a1_\u5e72\u90e8\u7ba1\u7406\u53c2\u6570\u914d\u7f6e\u201d\uff0c\u5e76\u5c06\u9009\u9879\u8c03\u6574\u4e3a\u201c\u542f\u7528\u6807\u51c6\u5e72\u90e8\u7ba1\u7406\u529f\u80fd\u201d\u3002", (String)"CadreParamPlugin_0", (String)"bos-ext-hrother", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void clearTenureUnderParam() {
        this.getModel().setValue(IS_CREATETENURE, (Object)false);
        this.getModel().setValue(IS_EXPIRETENURE, (Object)false);
    }

    private void dealWithTenure(boolean isTenure) {
        this.getView().setVisible(Boolean.valueOf(isTenure), new String[]{CREATETENURE_FLEX, EXPIRETENURE_FLEX});
    }

    private void dealWithOpencadm() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{IS_TENURE, IS_CREATETENURE, IS_EXPIRETENURE});
    }

    private boolean getOpenCadm() {
        Object isOpenCadm = this.getCadreParam("hbss", FUNCTIONAL_ORG, IS_OPENCADM);
        return Objects.nonNull(isOpenCadm) && isOpenCadm.equals("1");
    }

    private Object getCadreParam(String appKey, String viewType, String paramKey) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appKey);
        String appId = appInfo.getId();
        AppParam appParam = new AppParam(appId, viewType, DEFAULT_ORG_ID, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)paramKey);
    }
}

