/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.dhc.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.Copy;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.New;
import kd.bos.form.operate.botp.TrackUp;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DhcGeneralPlugin
extends AbstractFormPlugin
implements IListPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisible();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        this.setVisible();
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().addCustPlugin(((Object)((Object)this)).getClass().getName());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object operate = e.getSource();
        if (operate instanceof TrackUp) {
            FormOperate formOperate = (FormOperate)operate;
            formOperate.getOption().setVariableValue("botp_track_cust_plugin", ((Object)((Object)this)).getClass().getName());
        }
        if (this.isListView()) {
            return;
        }
        if (operate instanceof New) {
            e.setCancel(true);
            String formId = this.getView().getFormShowParameter().getFormId();
            BillShowParameter param = this.getBillShowParamter(false, formId, null);
            this.getView().showForm((FormShowParameter)param);
        } else if (operate instanceof Copy) {
            e.setCancel(true);
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            String formId = billShowParameter.getFormId();
            Long pkId = (Long)billShowParameter.getPkId();
            BillShowParameter param = this.getBillShowParamter(true, formId, pkId);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private boolean isListView() {
        return this.getView() instanceof ListView;
    }

    private BillShowParameter getBillShowParamter(boolean isCopy, String formId, Long pkid) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(formId);
        parameter.addCustPlugin(((Object)((Object)this)).getClass().getName());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getCustomParams().put("iscopy", isCopy);
        parameter.setStatus(OperationStatus.ADDNEW);
        if (pkid != null) {
            parameter.setPkId((Object)pkid);
        }
        return parameter;
    }

    private void setVisible() {
        IFormView view = this.getView();
        String billFormId = "";
        if (view instanceof ListView) {
            billFormId = ((ListView)view).getBillFormId();
        } else if (view instanceof BillView) {
            billFormId = ((BillView)view).getFormId();
        }
        String[] hiddenFields = this.getBillHiddenFields(billFormId, this.isListView());
        view.setVisible(Boolean.FALSE, hiddenFields);
    }

    private String[] getBillHiddenFields(String billFormId, boolean isList) {
        ArrayList<String> hideFildes = new ArrayList<String>(8);
        String selectFields = "entryentity.buttonid";
        QFilter[] qFilters = new QFilter[]{new QFilter("formid", "=", (Object)billFormId), new QFilter("islist", "=", (Object)isList)};
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"dhc_buttonvisible_conf", (String)selectFields, (QFilter[])qFilters);
        if (entrys == null) {
            return new String[0];
        }
        for (DynamicObject dyo : entrys) {
            String buttonId = dyo.getString("entryentity.buttonid");
            if (!StringUtils.isNotBlank((CharSequence)billFormId)) continue;
            hideFildes.add(buttonId);
        }
        return hideFildes.toArray(new String[0]);
    }
}

