/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.util;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.ssc.util.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class ExceptionPlatformUtil {
    private static final Log log = LogFactory.getLog(ExceptionPlatformUtil.class);
    private static final int DEAULT_MAX_LENGTH = 500;
    private static final int STACK_TRACE_MAX_LENGTH = 200;

    public static void saveErrorInfo(String className, String methodName, Throwable e) {
        ExceptionPlatformUtil.saveErrorInfo(className, methodName, "", "0", e);
    }

    public static void saveErrorInfo(String className, String methodName, String keyInfo, Throwable e) {
        ExceptionPlatformUtil.saveErrorInfo(className, methodName, keyInfo, "0", e);
    }

    public static void saveErrorInfo(String className, String methodName, String keyInfo, String type, Throwable e) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"task_exceptionplatform");
        dynamicObject.set("classname", (Object)className);
        dynamicObject.set("methodname", (Object)methodName);
        dynamicObject.set("exceptioninfo", (Object)ExceptionPlatformUtil.subStrByStr(e.getMessage(), 500));
        dynamicObject.set("stacktrace", (Object)ExceptionPlatformUtil.subStrByStr(e.getMessage(), 200));
        dynamicObject.set("stacktrace_tag", (Object)ExceptionUtil.getStackTrace(e));
        dynamicObject.set("traceid", (Object)RequestContext.get().getTraceId());
        dynamicObject.set("userid", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("keyinfo", (Object)keyInfo);
        dynamicObject.set("type", (Object)type);
        dynamicObject.set("time", (Object)new Date());
        ExceptionPlatformUtil.saveExceptionInfo(dynamicObject);
    }

    private static String subStrByStr(String str, int length) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length);
    }

    private static void saveExceptionInfo(DynamicObject dynamicObject) {
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception e) {
            log.error(String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff1a%s", (String)"ExceptionPlatformUtil_0", (String)"bos-ext-ssc", (Object[])new Object[0]), e));
        }
    }
}

