/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class TaskApprevalPluginUtil {
    private static final String ENTITY_TASK = "task_task";
    private static final String ENTITY_DECISIONITEMRELATIONREALATION = "task_decisionitem_re";
    private static final String FIELD_TASK = "id, billtype, tasktypeid,sscid";
    private static final String ALGOKEY_BEFOREAPPROVALVALIDATE = "kd.ssc.task.common.TaskApprevalPluginUtil.beforeApprovalValidate";
    private static final String ALGOKEY_GETDECISIONITEMID = "kd.ssc.task.common.TaskApprevalPluginUtil.getDecisionItemId";

    public static Map<String, List<Long>> getTaskBillInfo(List<Long> taskIds) {
        HashMap<String, List<Long>> retMap = new HashMap<String, List<Long>>();
        if (taskIds.size() == 0) {
            return retMap;
        }
        ORM orm = ORM.create();
        QFilter idFilter = new QFilter("id", "in", taskIds);
        ArrayList<Long> billTypeList = new ArrayList<Long>();
        ArrayList<Long> taskTypeList = new ArrayList<Long>();
        ArrayList<Long> sscList = new ArrayList<Long>();
        try (DataSet dsTask = orm.queryDataSet(ALGOKEY_BEFOREAPPROVALVALIDATE, ENTITY_TASK, FIELD_TASK, new QFilter[]{idFilter});){
            Long billType = 0L;
            Long taskType = 0L;
            for (Row item : dsTask) {
                billType = item.getLong("billtype");
                taskType = item.getLong("tasktypeid");
                Long sscid = item.getLong("sscid");
                if (!billTypeList.contains(billType)) {
                    billTypeList.add(billType);
                }
                if (!taskTypeList.contains(taskType)) {
                    taskTypeList.add(taskType);
                }
                if (sscList.contains(sscid)) continue;
                sscList.add(sscid);
            }
        }
        retMap.put("billtype", billTypeList);
        retMap.put("tasktypeid", taskTypeList);
        retMap.put("sscid", sscList);
        return retMap;
    }

    public static boolean beforeApprovalValidateBillType(List<Long> taskIds) {
        if (taskIds == null || taskIds.size() == 0) {
            return false;
        }
        if (taskIds.size() == 1) {
            return true;
        }
        Map<String, List<Long>> taskInfoMap = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        List<Long> billTypeList = taskInfoMap.get("billtype");
        return billTypeList.size() <= 1;
    }

    public static boolean beforeApprovalValidateTaskType(List<Long> taskIds) {
        if (taskIds == null || taskIds.size() == 0) {
            return false;
        }
        if (taskIds.size() == 1) {
            return true;
        }
        Map<String, List<Long>> taskInfoMap = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        List<Long> takTypeList = taskInfoMap.get("tasktypeid");
        return takTypeList.size() <= 1;
    }

    public static List<Long> getDecisionItemId(String operationKey, List<Long> taskIds) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (taskIds == null || taskIds.size() == 0) {
            return ret;
        }
        Map<String, List<Long>> taskInfoMap = TaskApprevalPluginUtil.getTaskBillInfo(taskIds);
        List<Long> billTypeList = taskInfoMap.get("billtype");
        List<Long> takTypeList = taskInfoMap.get("tasktypeid");
        List<Long> sscidList = taskInfoMap.get("sscid");
        QFilter billTypeFilter = new QFilter("billtypeid", "in", billTypeList);
        QFilter taskTypeFilter = new QFilter("tasktypeid", "in", takTypeList);
        QFilter sscidFilter = new QFilter("ssccenter", "in", sscidList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter = billTypeFilter.and(taskTypeFilter).and(sscidFilter).and(enableFilter);
        ORM orm = ORM.create();
        try (DataSet dsDecision = orm.queryDataSet(ALGOKEY_GETDECISIONITEMID, ENTITY_DECISIONITEMRELATIONREALATION, "decisionitem", filter.toArray());){
            for (Row item : dsDecision) {
                Long decisionitem = item.getLong("decisionitem");
                if (ret.contains(decisionitem)) continue;
                ret.add(decisionitem);
            }
        }
        return ret;
    }
}

