package kd.bos.ext.imc.formplugin.operation;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;

/**
 * @ClassName DownImageConfigParamPlugin
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/28 14:39
 * @Version 1.0
 */
public class DownImageConfigParamPlugin extends CustOpParameterPlugin {
    @Override
    protected void showParameter(CustOperationParameter v) {
        JSONObject param = JSONObject.parseObject(v.getParameter());
        if(param == null) {
            return;
        }
        if(StringUtils.isNotBlank(param.getString("bill_type"))){
            getModel().setValue("bill_type", param.get("bill_type"));
        }
        if(StringUtils.isNotBlank(param.getString("bill_id"))){
            getModel().setValue("bill_id", param.getString("bill_id"));
        }
    }

    @Override
    protected void returnParameter(CustOperationParameter v) {
        DynamicObject entity = this.getModel().getDataEntity(true);
        JSONObject param = new JSONObject();
        if(entity.getDynamicObject("bill_type") != null) {
            param.put("bill_type", entity.getDynamicObject("bill_type").getLong("id"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_id"))) {
            param.put("bill_id", entity.getString("bill_id"));
        }
        v.setParameter(param.toJSONString());
    }
}
