package kd.bos.ext.taxc.writeback;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;

import java.util.Map;

/**
 * @ClassName: DapVoucherWriteBackPayRecord
 * @Description: bdtaxr缴款记录表回调反写
 * @Author: chen guoqiang
 * @Date: 2022/4/22
 */
public class DapVoucherWriteBackPayRecord extends AbstractDapWriteBackImpl {

    public static final String CREATE_SQL = "update %s set fisvoucher = '1', fvoucherno = '%s'  where fid = %s";
    public static final String DELETE_SQL = "update %s set fisvoucher = '0', fvoucherno = ' '  where fid in (%s)";

    public DapVoucherWriteBackPayRecord() {
    }

    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType(billEntityNumber);
        if (mt.findProperty("billno") != null) {
            if (VoucherOperation.Create==operation) {
                for (Map.Entry<Long, Voucher> entry : billToVch.entrySet()) {
                    String sql = String.format(CREATE_SQL, mt.getAlias(), entry.getValue().getVoucherNo(), entry.getKey());
                    DB.execute(this.getDBRoute(), sql, new Object[0]);
                }
            }

            if (VoucherOperation.Delete==operation) {
                String sql = String.format(DELETE_SQL, mt.getAlias(), StringUtils.join(billToVch.keySet().toArray(), ','));
                DB.execute(this.getDBRoute(), sql, new Object[0]);
            }
        }
    }

    protected String getVchStatusField() {
        return "fisvoucher";
    }

    protected Object getVchEnableStatus() {
        return true;
    }

    protected Object getVchDisableStatus() {
        return false;
    }

    protected DBRoute getDBRoute() {
        return DBRoute.of("taxc");
    }
}
