/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.archive.PerRecordSplit;
import kd.bos.bal.business.sparse.SparseSeq;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ThreadLocals;

public class BalPerRecordSplitManager {
    public static final String taskEntity = "bal_per_record_split";
    private static final ThreadLocal<Map<String, Integer>> PERIOD_CACHE = ThreadLocals.create(new HashMap(8));

    /*
     * Exception decompiling
     */
    public static void consumerTask(TaskMsg msg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void saveTaskInfo(DynamicObject taskInfo) {
        if (taskInfo != null) {
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskInfo});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleTaskMsg(DynamicObject taskInfo) {
        block6: {
            String balName = taskInfo.getString("bal.id");
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)balName);
            Object[] tbs = BalTaskUtil.getXdbs(type.getAlias(), DBRoute.of((String)type.getDBRouteKey()));
            Arrays.sort(tbs);
            String lastTB = taskInfo.getString("lastsuccesstb");
            int i = BalPerRecordSplitManager.getLastTBIdx((String[])tbs, lastTB);
            long lastId = taskInfo.getLong("lastsuccessid");
            ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
            for (int j = i; j < tbs.length; ++j) {
                SparseSeqParam param = new SparseSeqParam(balName, (String)tbs[j]);
                if (j == i) {
                    param.setMinLimit(lastId);
                }
                params.add(param);
            }
            int targetPeriod = taskInfo.getInt("period");
            PerRecordSplit handle = new PerRecordSplit(BalanceTB.getBalanceTB(balName), targetPeriod);
            long tempLastId = 0L;
            SparseSeqParam tempParam = null;
            try {
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    SparseSeqParam param;
                    tempParam = param = (SparseSeqParam)iterator.next();
                    tempLastId = BalPerRecordSplitManager.handleTaskMsg(param, handle);
                }
                if (tempParam == null) break block6;
                lastId = tempParam.getActualTb().equals(lastTB) ? Math.max(tempLastId, lastId) : tempLastId;
            }
            catch (Throwable throwable) {
                if (tempParam != null) {
                    lastId = tempParam.getActualTb().equals(lastTB) ? Math.max(tempLastId, lastId) : tempLastId;
                    taskInfo.set("lastsuccesstb", (Object)tempParam.getActualTb());
                    taskInfo.set("lastsuccessid", (Object)lastId);
                }
                throw throwable;
            }
            taskInfo.set("lastsuccesstb", (Object)tempParam.getActualTb());
            taskInfo.set("lastsuccessid", (Object)lastId);
        }
    }

    private static long handleTaskMsg(SparseSeqParam param, PerRecordSplit handle) {
        long lastId = 0L;
        try (SparseSeq seq = SparseSeq.getSparseSeq(param);){
            while (seq.hasNext()) {
                long[] ids = seq.next();
                lastId = handle.doSplitTask(ids[0], ids[1]);
            }
        }
        return lastId;
    }

    private static int getLastTBIdx(String[] tbs, String lasttb) {
        for (int i = 0; i < tbs.length; ++i) {
            if (!tbs[i].equals(lasttb)) continue;
            return i;
        }
        return 0;
    }

    public static int getSplitPeriod(BalanceTB bal) {
        int result = 0;
        if (bal.isPerBal()) {
            String balName = bal.getName();
            Integer period = PERIOD_CACHE.get().get(balName);
            if (period == null) {
                period = BalPerRecordSplitManager.getSplitPeriodFromDB(balName);
                PERIOD_CACHE.get().put(balName, period);
            }
            result = period;
        }
        return result;
    }

    private static int getSplitPeriodFromDB(String balName) {
        QFilter fs = new QFilter("bal", "=", (Object)balName);
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)"getSplitPeriod", (String)taskEntity, (String)"period", (QFilter[])fs.toArray(), (String)"period desc", (int)1);){
            Iterator iterator = datas.iterator();
            if (iterator.hasNext()) {
                Row data = (Row)iterator.next();
                int n = data.getInteger("period");
                return n;
            }
        }
        return 0;
    }
}

