/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.archive.BalRecordSplitManager;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;

class RecordRevert {
    private long fromId;
    private final long toId;
    private final BalanceTB bal;
    private final BalConfig cfg;
    private final DynamicObject taskInfo;
    private String taskMode;
    private final Long lastSuccessId;

    public RecordRevert(DynamicObject taskInfo) {
        String balName = taskInfo.getString("parenttask.bal.id");
        this.bal = BalanceTB.getBalanceTB(balName);
        this.cfg = BalConfig.loadBalConfig(balName);
        this.lastSuccessId = taskInfo.getLong("lastsuccessid");
        this.fromId = taskInfo.getLong("fromid");
        this.toId = taskInfo.getLong("toid");
        this.taskInfo = taskInfo;
    }

    public void setTaskMode(String taskMode) {
        this.taskMode = taskMode;
    }

    public void revert() {
        if (!this.bal.isRealBal()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5373\u65f6\u4f59\u989d\u7c7b\u578b\u7684\u4f59\u989d\u8868\u624d\u80fd\u8fd0\u884c\u4efb\u52a1\u3002", (String)"RecordRevert_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        TreeSet<Long> allIds = this.getAllIds();
        TreeSet<Long> batchIds = new TreeSet<Long>();
        int batch = this.cfg.getRecordSplitBatch();
        for (Long id : allIds) {
            batchIds.add(id);
            if (batchIds.size() < batch) continue;
            this.revert(batchIds);
            this.setLastSuccessId(batchIds.last());
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.revert(batchIds);
            this.setLastSuccessId(batchIds.last());
        }
    }

    protected void setLastSuccessId(Object lastId) {
        this.taskInfo.set("lastsuccessid", lastId);
    }

    public void revert(TreeSet<Long> balIds) {
        BalRecordSplitManager.revertRecordById(this.bal, balIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<Long> getAllIds() {
        this.handleFs();
        this.setParam2Task();
        TreeSet<Long> ids = new TreeSet<Long>();
        if (this.fromId >= this.toId) {
            return ids;
        }
        try (DataSet data = null;){
            String dbKey = this.taskInfo.getString("sparseseq.dbkey");
            String tidCol = this.taskInfo.getString("sparseseq.sparsecol");
            String actualtb = this.taskInfo.getString("sparseseq.actualtb");
            SqlBuilder sql = new SqlBuilder();
            sql.append("SELECT", new Object[0]).append(tidCol, new Object[0]).append("id", new Object[0]).append("FROM", new Object[0]);
            sql.append(actualtb, new Object[0]).append("WHERE", new Object[0]).append(tidCol + ">=?", new Object[]{this.fromId});
            sql.append("AND", new Object[0]).append(tidCol + "<?", new Object[]{this.toId});
            data = DB.queryDataSet((String)"getAllIdsById", (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sql);
            for (Row row : data) {
                ids.add(row.getLong("id"));
            }
            TreeSet<Long> treeSet = ids;
            return treeSet;
        }
    }

    private void handleFs() {
        if ("B".equals(this.taskMode)) {
            this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
    }

    private void setParam2Task() {
        String msg = String.format("fromId=%s, toId=%s", this.fromId, this.toId);
        this.taskInfo.set("param_tag", (Object)msg);
    }
}

