/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.archive;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class SpDataSplitUtil {
    private static final String BAL_SPDATA_SPLIT_POINT = "bal_spdata_split_point";

    SpDataSplitUtil() {
    }

    static boolean limitIdExists(String balName, String billName, long idPoint) {
        return SpDataSplitUtil.getArchiveLimitId(balName, billName) == idPoint;
    }

    static long getArchiveLimitId(String balName, String billName) {
        QFilter fs = new QFilter("bal", "=", (Object)balName);
        fs.and("bill", "=", (Object)billName);
        DynamicObject data = QueryServiceHelper.queryOne((String)BAL_SPDATA_SPLIT_POINT, (String)"idpoint", (QFilter[])fs.toArray());
        if (data != null) {
            return data.getLong("idpoint");
        }
        return 0L;
    }

    static long addOrUpdateLimitId(DynamicObject parentTask, String billName) {
        String balName = parentTask.getString("bal.id");
        Date timePoint = parentTask.getDate("timepoint");
        long idPoint = parentTask.getLong("idpoint");
        DynamicObject info = SpDataSplitUtil.loadArchiveLimitInfo(balName, billName);
        if (info == null || info.getLong("idpoint") < idPoint) {
            if (info == null) {
                info = BusinessDataServiceHelper.newDynamicObject((String)BAL_SPDATA_SPLIT_POINT);
                info.set("bal", (Object)balName);
                info.set("bill", (Object)billName);
            }
            info.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
            info.set("idpoint", (Object)idPoint);
            info.set("timepoint", (Object)timePoint);
            try (TXHandle tx = TX.requiresNew((String)"getOrCreateLimitId");){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            }
        }
        return idPoint;
    }

    private static DynamicObject loadArchiveLimitInfo(String balName, String billName) {
        QFilter fs = new QFilter("bal", "=", (Object)balName);
        fs.and("bill", "=", (Object)billName);
        return BusinessDataServiceHelper.loadSingle((String)BAL_SPDATA_SPLIT_POINT, (QFilter[])fs.toArray());
    }
}

