/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.archive.BalRecordSplitManager;
import kd.bos.bal.business.consumer.TxMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.BalInnerUtil;
import kd.bos.bal.business.core.IgnoreCoverFilterFunc;
import kd.bos.bal.business.core.Key;
import kd.bos.bal.business.core.KeyColCache;
import kd.bos.bal.business.core.PeriodReduceGroup;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TxInfo;
import kd.bos.biz.balance.engine.IBalanceUpdate;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.BalanceUpdateArgs;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.biz.balance.model.IBalanceUpdatePlugin;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

class BalEngine
implements IBalanceUpdate {
    private final boolean sync;
    private final boolean forwardOp;
    private final UpdateRule rule;
    private final BalanceTB balanceTB;
    private final UpdateCtx ctx;
    private final boolean notifyUpdating;
    private final boolean ignoreCover4Zero;
    private DataSet data;
    private final int engineAddSpBatch;
    private final int engineAddBalBatch;
    private final boolean engineDistinctEntryId;
    private static final int END_PER = 999999;
    private Map<String, Object> defaultParam;
    private final boolean checkSpCount;
    private int spDataCount;
    private final boolean checkKeyColArchive;
    private boolean generatedDecreaseQty;
    private String cacheKey4KeyCol;
    private BalanceUpdateArgs args;
    private final long txId;
    private List<IBalanceUpdatePlugin> plugins;
    private final String modifyTimeCol;
    private final Date now;
    private long pluginUseTime = 0L;
    private Set<String> balQtyCol;
    private Set<String> outQtyCol;
    private int enableXDBFlag = -1;

    public long getTxId() {
        return this.txId;
    }

    public boolean isSync() {
        return this.sync;
    }

    public int getSpDataCount() {
        return this.spDataCount;
    }

    long getPluginUseTime() {
        return this.pluginUseTime;
    }

    public BalEngine(UpdateCtx ctx, UpdateRule rule) {
        int force;
        this.ctx = ctx;
        this.rule = rule;
        this.balanceTB = this.rule.getBalanceTB();
        this.forwardOp = rule.isForwardOp(ctx.getOp());
        if (this.forwardOp) {
            this.data = BalEngineUtil.getData(rule, ctx.getBillIds(), ctx.getEntryIds(), ctx.isEnableUpdatedFs());
        }
        this.sync = (force = ctx.getForceType()) == 1 || force != 2 && this.balanceTB.isSyncUpdate();
        this.txId = DB.genGlobalLongId();
        BalConfig cfg = BalConfig.loadBalConfig(this.balanceTB.getName());
        this.engineAddSpBatch = cfg.getEngineAddSpBatch();
        this.engineAddBalBatch = cfg.getEngineAddBalBatch();
        this.engineDistinctEntryId = cfg.isEngineDistinctEntryId();
        this.ignoreCover4Zero = cfg.isIgnoreCover4Zero();
        this.notifyUpdating = cfg.isNotityUpdating4Op();
        this.checkSpCount = cfg.isCheckSpCount();
        if (cfg.isForceXDB()) {
            this.enableXDBFlag = 1;
        }
        BalLogUtil.info("BalEngine created isReCal = " + ctx.isReCalMode(), new Object[0]);
        this.modifyTimeCol = this.balanceTB.getModifyTimeCol();
        this.now = new Date();
        if (cfg.isUseCache4Keycol()) {
            this.cacheKey4KeyCol = KeyColCache.buildCacheKey(this.balanceTB.getName());
        }
        this.checkKeyColArchive = this.balanceTB.isRealBal();
    }

    @Override
    public void doReCal() {
        BalLogUtil.info("BalEngine.doReCal start", new Object[0]);
        this.applyUpdate();
        this.handleData();
        try (TXHandle tx = TX.requiresNew((String)"DO_RE_CAL");){
            try {
                this.createTempSpData();
                this.ctx.getTxInfo().get(this.txId).setStatus(2);
            }
            catch (Throwable e) {
                tx.markRollback();
                this.ctx.getTxInfo().get(this.txId).setStatus(3);
                throw e;
            }
        }
    }

    @Override
    public void doUpdate() {
        BalLogUtil.info("BalEngine.doUpdate start", new Object[0]);
        this.applyUpdate();
        if (this.sync) {
            this.syncUpdate();
        } else {
            this.asyncUpdate();
        }
    }

    private void applyUpdate() {
        BalLogUtil.info("BalEngine.applyUpdate start", new Object[0]);
        this.ctx.getTxInfo().put(this.txId, new TxInfo(this.txId, this.rule, this.sync));
        int opFlag = this.ctx.getXdbFlag();
        Date now = new Date();
        long userId = RequestContext.getOrCreate().getCurrUserId();
        Set<Object> billIds = this.ctx.getBillIds();
        ArrayList<Object[]> billParams = new ArrayList<Object[]>(billIds.size());
        String ruleId = this.rule.getId();
        String billName = this.rule.getEntityNumber();
        String instanceId = Instance.getInstanceId();
        long[] ids = DB.genGlobalLongIds((int)billIds.size());
        String db = this.ctx.getBillType().getDBRouteKey();
        String app = this.ctx.getBillType().getAppId();
        int i = 0;
        for (Object billId : billIds) {
            billParams.add(new Object[]{ids[i++], billId, db, app, this.rule.getBalanceNo(), ruleId, billName, now, this.txId, userId, instanceId, opFlag});
        }
        this.doAddUpdating(billParams);
    }

    private void doAddUpdating(List<Object[]> billParams) {
        if (!this.tryAddUpdating(billParams, !this.notifyUpdating)) {
            this.tryHandleValidTx();
            this.tryAddUpdating(billParams, true);
        }
    }

    private void tryHandleValidTx() {
        BalLogUtil.info("BalEngine.tryHandleValidTx start", new Object[0]);
        try {
            String sql = "SELECT FTXID FROM T_BAL_UPDATING WHERE FRULEID = '" + this.rule.getId() + "' AND FBILLID " + QFUtil.getIdsFilter(this.ctx.getBillIds());
            HashSet<Long> txIds = new HashSet<Long>(100);
            try (DataSet data = DB.queryDataSet((String)"tryHandleValidTx", (DBRoute)IBalance.BAL_DB, (String)sql);){
                int idx = data.getRowMeta().getFieldIndex("FTXID");
                for (Row row : data) {
                    txIds.add(row.getLong(idx));
                }
            }
            TxMsg txMsg = new TxMsg(this.balanceTB, DBRoute.of((String)this.ctx.getBillType().getDBRouteKey()), txIds);
            txMsg.setSkipInvalidTxs(true);
            BalEngineUtil.handleTxMsg(txMsg);
        }
        catch (Throwable e) {
            BalLogUtil.saveError("BalEngine", null, "tryHandleValidTx", e);
        }
    }

    private boolean tryAddUpdating(List<Object[]> billParams, boolean isRetry) {
        block22: {
            BalLogUtil.info("BalEngine.tryAddUpdating start : isRetry = " + isRetry, new Object[0]);
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"APPLY_UPDATE");){
                try {
                    DB.executeBatch((DBRoute)IBalance.BAL_DB, (String)"INSERT INTO T_BAL_UPDATING (FID,FBILLID,FDB,FAPP,FBAL,FRULEID,FBILLENTITY,FCREATETIME,FTXID,FCREATERID,FINSTANCEID,FOPFLAG) VALUES (?,?,?,?,?,?,?,?,?,?,?,?) ", billParams);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    if (BalLogUtil.isUniqueError(e)) {
                        if (isRetry) {
                            BalEngineUtil.throwUpdatingMsg(this.ctx, false);
                            break block22;
                        }
                        boolean bl = false;
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            } else {
                                tx.close();
                            }
                        }
                        return bl;
                    }
                    try {
                        throw e;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        return true;
    }

    private void syncUpdate() {
        BalLogUtil.info("BalEngine.syncUpdate start", new Object[0]);
        try (TXHandle tx = TX.requiresNew((String)"SYNC_UPDATE");){
            try {
                this.beforeUpdate();
                this.handleData();
                this.createTempSpData();
                this.beforeJoinUpdate();
                BalEngineUtil.syncUpdateBal(this.rule.getBalanceTB(), this.txId);
                this.afterUpdate();
                this.ctx.getTxInfo().get(this.txId).setStatus(2);
            }
            catch (Throwable e) {
                tx.markRollback();
                this.ctx.getTxInfo().get(this.txId).setStatus(3);
                throw e;
            }
        }
    }

    private void asyncUpdate() {
        BalLogUtil.info("BalEngine.asyncUpdate start", new Object[0]);
        this.beforeUpdate();
        this.handleData();
        try (TXHandle tx = TX.requiresNew((String)"ASYNC_UPDATE");){
            try {
                this.createTempSpData();
                this.ctx.getTxInfo().get(this.txId).setStatus(2);
            }
            catch (Throwable e) {
                tx.markRollback();
                this.ctx.getTxInfo().get(this.txId).setStatus(3);
                throw e;
            }
        }
        this.beforeJoinUpdate();
        this.afterUpdate();
    }

    private void createTempSpData() {
        HashMap<String, Key> keyMap = new HashMap<String, Key>(128);
        HashSet<String> oldKeys = new HashSet<String>(this.checkKeyColArchive ? 128 : 1);
        int initSize = Math.min(this.ctx.getBillIds().size() * 50, this.engineAddSpBatch);
        ArrayList<Object[]> spRecords = new ArrayList<Object[]>(initSize);
        String insertSql = this.balanceTB.getInsertSql();
        for (Row row : this.data) {
            boolean hasOldData;
            boolean hasNewData = row.getLong("entryid") != null;
            boolean bl = hasOldData = row.getLong(this.balanceTB.toOldSpCol("entryid")) != null;
            if (hasNewData && !hasOldData) {
                this.handleNewSpData(row, keyMap, spRecords);
            } else if (!hasNewData && hasOldData) {
                this.handleOldSpData(row, spRecords, oldKeys);
            } else {
                this.contrastSpData(row, keyMap, spRecords, oldKeys);
            }
            if (keyMap.size() + oldKeys.size() >= this.engineAddBalBatch) {
                this.tryCreateBalRecord(keyMap, oldKeys);
                keyMap.clear();
                oldKeys.clear();
            }
            if (spRecords.size() < this.engineAddSpBatch) continue;
            this.executeBatch(insertSql, spRecords);
            spRecords.clear();
        }
        this.close();
        if (keyMap.size() + oldKeys.size() > 0) {
            this.tryCreateBalRecord(keyMap, oldKeys);
        }
        keyMap = null;
        if (!spRecords.isEmpty()) {
            this.executeBatch(insertSql, spRecords);
        }
    }

    private void executeBatch(String insertSql, List<Object[]> updateDetail) {
        this.spDataCount += updateDetail.size();
        DB.executeBatch((DBRoute)this.balanceTB.getDbRoute(), (String)insertSql, updateDetail);
    }

    private String calCoverType(Row row) {
        for (String coverCol : this.balanceTB.getCoverCols()) {
            if (Objects.equals(row.get(coverCol), row.get(this.balanceTB.toOldSpCol(coverCol)))) continue;
            return "1";
        }
        return "0";
    }

    private void contrastSpData(Row row, Map<String, Key> keyMap, List<Object[]> spRecords, Set<String> oldKeys) {
        Key key = BalEngineUtil.calKey(row, this.rule.getUpdateKeyCol());
        String oldKey = row.getString(this.balanceTB.toOldSpCol("keycol"));
        if (BalInnerUtil.isTheSameKey(this.balanceTB, key.getkeyStr(), oldKey, row)) {
            String readType = this.calReadType(row);
            String coverType = this.calCoverType(row);
            if (readType == null && "0".equals(coverType)) {
                return;
            }
            if (readType == null) {
                readType = "0";
            } else if (this.sync) {
                readType = "0";
            }
            Map<String, Object> params = this.getNewSpData(row, oldKey);
            params.put("movetype", "1");
            params.put("coverflag", coverType);
            params.put("readtype", readType);
            spRecords.add(BalEngineUtil.parseParams(params, this.balanceTB.getInsertCols()));
            params = this.getOldSpData(row);
            params.put("movetype", "0");
            params.put("coverflag", "0");
            params.put("readtype", readType);
            spRecords.add(BalEngineUtil.parseParams(params, this.balanceTB.getInsertCols()));
            if (this.checkKeyColArchive && !keyMap.containsKey(oldKey)) {
                oldKeys.add(oldKey);
            }
        } else {
            this.handleNewSpData(row, keyMap, key, spRecords);
            this.handleOldSpData(row, spRecords, oldKeys);
        }
    }

    private String calReadType(Row row) {
        String type = null;
        Set<String> outQtyCols = this.getOutQtyCols();
        for (String qtyCol : this.getBalQtyCols()) {
            int compare = row.getBigDecimal(qtyCol).add(row.getBigDecimal(this.balanceTB.toOldSpCol(qtyCol))).compareTo(BigDecimal.ZERO);
            if (compare == 0) continue;
            boolean contains = outQtyCols.contains(qtyCol);
            if (contains && compare > 0 || !contains && compare < 0) {
                this.generatedDecreaseQty = true;
                return "1";
            }
            type = "0";
        }
        return type;
    }

    private String calReadType(Map<String, Object> params, Set<String> qtyCols) {
        if (this.sync) {
            if (!this.generatedDecreaseQty && this.isDecreaseQty(params, qtyCols)) {
                this.generatedDecreaseQty = true;
            }
            return "0";
        }
        boolean result = this.isDecreaseQty(params, qtyCols);
        if (result) {
            this.generatedDecreaseQty = true;
        }
        return result ? "1" : "0";
    }

    private boolean isDecreaseQty(Map<String, Object> params, Set<String> qtyCols) {
        Set<String> outQtyCols = this.getOutQtyCols();
        for (String qtyCol : qtyCols) {
            int flag = ((BigDecimal)params.get(qtyCol)).compareTo(BigDecimal.ZERO);
            boolean contains = outQtyCols.contains(qtyCol);
            if ((!contains || flag <= 0) && (contains || flag >= 0)) continue;
            return true;
        }
        return false;
    }

    private void handleOldSpData(Row row, List<Object[]> spRecords, Set<String> oldKeys) {
        Map<String, Object> params = this.getOldSpData(row);
        params.put("movetype", "0");
        params.put("coverflag", "0");
        params.put("readtype", this.calReadType(params, this.getBalQtyCols()));
        spRecords.add(BalEngineUtil.parseParams(params, this.balanceTB.getInsertCols()));
        if (this.checkKeyColArchive) {
            oldKeys.add(row.getString(this.balanceTB.toOldSpCol("keycol")));
        }
    }

    private Map<String, Object> getOldSpData(Row row) {
        Map<String, Object> params = this.getDefaultParams();
        params.put("id", row.get(this.balanceTB.toOldSpCol("id")));
        if (this.balanceTB.isPerBal()) {
            String periodCol = this.balanceTB.getPeriodCol();
            params.put(periodCol, row.getInteger(this.balanceTB.toOldSpCol(periodCol)));
        }
        params.put("keycol", row.getString(this.balanceTB.toOldSpCol("keycol")));
        params.put("billno", row.get(this.balanceTB.toOldSpCol("billno")));
        params.put("entryseq", row.get(this.balanceTB.toOldSpCol("entryseq")));
        params.put("billid", row.get(this.balanceTB.toOldSpCol("billid")));
        params.put("entryid", row.get(this.balanceTB.toOldSpCol("entryid")));
        BigDecimal value = null;
        for (String col : this.getBalQtyCols()) {
            value = row.getBigDecimal(this.balanceTB.toOldSpCol(col));
            params.put(col, value);
        }
        for (String col : this.balanceTB.getCoverCols()) {
            params.put(col, row.get(this.balanceTB.toOldSpCol(col)));
        }
        return params;
    }

    private void handleNewSpData(Row row, Map<String, Key> keyMap, List<Object[]> spRecords) {
        Key key = BalEngineUtil.calKey(row, this.rule.getUpdateKeyCol());
        this.handleNewSpData(row, keyMap, key, spRecords);
    }

    private void handleNewSpData(Row row, Map<String, Key> keyMap, Key key, List<Object[]> spRecords) {
        key.setRddColValues(this.getRddColValues(row));
        String keyStr = this.balanceTB.isPerBal() ? this.calPeriodKey(key.getkeyStr(), row.getInteger(this.balanceTB.getPeriodCol())) : key.getkeyStr();
        keyMap.put(keyStr, key);
        Map<String, Object> params = this.getNewSpData(row, key.getkeyStr());
        params.put("movetype", "1");
        params.put("coverflag", "1");
        params.put("readtype", this.calReadType(params, this.rule.getOccCol4Update()));
        spRecords.add(BalEngineUtil.parseParams(params, this.balanceTB.getInsertCols()));
    }

    private Map<String, Object> getNewSpData(Row row, String keyColVal) {
        Map<String, Object> params = this.getDefaultParams();
        params.put("id", DB.genGlobalLongId());
        if (this.balanceTB.isPerBal()) {
            int period = this.rule.getPerCalPolicy().calPeriodVal(row);
            params.put(this.balanceTB.getPeriodCol(), period);
        }
        params.put("keycol", keyColVal);
        params.put("billno", row.get("billno"));
        params.put("entryseq", row.get("entryseq"));
        params.put("billid", row.get("billid"));
        params.put("entryid", row.get("entryid"));
        for (String col : this.getBalQtyCols()) {
            BigDecimal value = row.getBigDecimal(col);
            params.put(col, value);
        }
        for (String col : this.balanceTB.getCoverCols()) {
            params.put(col, row.get(col));
        }
        return params;
    }

    private Map<String, Object> getDefaultParams() {
        if (this.defaultParam == null) {
            this.defaultParam = new HashMap<String, Object>(16);
            this.defaultParam.put("billname", this.ctx.getEntityNumber());
            this.defaultParam.put("updatetime", this.txId);
            this.defaultParam.put("updatetype", this.rule.getUpdateType());
            this.defaultParam.put("updaterule", this.rule.getId());
            this.defaultParam.put("status", "A");
            this.defaultParam.put("isnew", "1");
            this.defaultParam.put("sync", this.sync ? "1" : "0");
        }
        return this.defaultParam;
    }

    private Map<String, Object> getRddColValues(Row row) {
        Set<String> cols = this.rule.getRddCol4Update();
        if (cols.isEmpty()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(cols.size());
        for (String col : cols) {
            result.put(col, row.get(col));
        }
        return result;
    }

    private String calPeriodKey(String dimKey, int period) {
        return period + "_" + dimKey;
    }

    private void handleData() {
        DataSet oldSpData = BalEngineUtil.queryOldSpData(this.rule, this.ctx.getBillIds(), this.ctx.getEntryIds());
        if (this.ignoreCover4Zero) {
            String[] qtyCols = this.getBalQtyCols().toArray(new String[0]);
            int[] qtyColIdxs = new int[qtyCols.length];
            int[] oldQtyColIdxs = new int[qtyCols.length];
            RowMeta oldRowMeta = oldSpData.getRowMeta();
            RowMeta rowMeta = this.data.getRowMeta();
            int len = qtyCols.length;
            for (int i = 0; i < len; ++i) {
                qtyColIdxs[i] = rowMeta.getFieldIndex(qtyCols[i]);
                oldQtyColIdxs[i] = oldRowMeta.getFieldIndex(this.balanceTB.toOldSpCol(qtyCols[i]));
            }
            oldSpData = oldSpData.filter((FilterFunction)new IgnoreCoverFilterFunc(oldQtyColIdxs));
            this.data = this.data.filter((FilterFunction)new IgnoreCoverFilterFunc(qtyColIdxs));
        }
        if (this.forwardOp) {
            JoinDataSet joinData = this.data.fullJoin(oldSpData).on("billid", this.balanceTB.toOldSpCol("billid")).on("entryid", this.balanceTB.toOldSpCol("entryid"));
            this.data = joinData.select(this.data.getRowMeta().getFieldNames(), oldSpData.getRowMeta().getFieldNames()).finish();
            if (this.engineDistinctEntryId) {
                this.data = BalEngineUtil.distinctEntryId(this.data, "entryid", this.balanceTB.toOldSpCol("entryid"));
            }
        } else {
            this.data = oldSpData.addNullField("entryid");
        }
    }

    private Set<String> getBalQtyCols() {
        return this.balQtyCol == null ? (this.balQtyCol = BalEngineUtil.getBalQtyCols(this.balanceTB)) : this.balQtyCol;
    }

    private Set<String> getOutQtyCols() {
        return this.outQtyCol == null ? (this.outQtyCol = this.balanceTB.getColsByDataType(BizDataType.OUT)) : this.outQtyCol;
    }

    private List<IBalanceUpdatePlugin> getPlugins() {
        return this.plugins == null ? (this.plugins = BalEngineUtil.getTbPlugin(this.balanceTB)) : this.plugins;
    }

    private void tryCreateBalRecord(Map<String, Key> keyMap, Set<String> oldKeys) {
        boolean needRetry = this.tryCreateInNewTX(keyMap, oldKeys, true);
        if (needRetry) {
            this.tryCreateInNewTX(keyMap, oldKeys, false);
        }
    }

    private boolean tryCreateInNewTX(Map<String, Key> keyMap, Set<String> oldKeys, boolean needRetry) {
        KeyColCache.filterByCache(this.cacheKey4KeyCol, keyMap, oldKeys);
        if (keyMap.size() + oldKeys.size() == 0) {
            return false;
        }
        try {
            if (this.balanceTB.isPerBal()) {
                this.tryCreatePerBal(keyMap);
            } else {
                this.tryCreateRealBal(keyMap, oldKeys);
            }
            KeyColCache.addCache(this.cacheKey4KeyCol, keyMap, oldKeys);
        }
        catch (Throwable e) {
            if (BalLogUtil.isUniqueError(e)) {
                if (needRetry) {
                    return true;
                }
                throw new KDBizException(ResManager.loadKDString((String)"isUniqueError\u51fa\u73b0\u4e86\u63d2\u5165\u76f8\u540c\u7684\u4f59\u989d\u8bb0\u5f55\u7684\u60c5\u51b5\uff0c\u8bf7\u4e1a\u52a1\u91cd\u65b0\u6267\u884c\u64cd\u4f5c\u3002", (String)"BalEngine_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            throw e;
        }
        return false;
    }

    private void tryCreateRealBal(Map<String, Key> keyMap, Set<String> oldKeys) {
        BalLogUtil.info("BalEngine.tryCreateRealBal start\uff1a newkey size = {}, oldkey size = {}", keyMap.size(), oldKeys.size());
        HashSet<String> allKeys = new HashSet<String>(oldKeys);
        allKeys.addAll(keyMap.keySet());
        QFilter fs = new QFilter("keycol", "in", allKeys);
        DataSet dbKeys = QueryServiceHelper.queryDataSet((String)"tryCreateRealBal", (String)this.balanceTB.getName(), (String)"keycol", (QFilter[])fs.toArray(), null);
        Object object = null;
        try {
            int idx = dbKeys.getRowMeta().getFieldIndex("keycol");
            for (Row row : dbKeys) {
                String keycol = row.getString(idx);
                keyMap.remove(keycol);
                oldKeys.remove(keycol);
                allKeys.remove(keycol);
            }
        }
        catch (Throwable keycol) {
            object = keycol;
            throw keycol;
        }
        finally {
            if (dbKeys != null) {
                if (object != null) {
                    try {
                        dbKeys.close();
                    }
                    catch (Throwable keycol) {
                        ((Throwable)object).addSuppressed(keycol);
                    }
                } else {
                    dbKeys.close();
                }
            }
        }
        if (allKeys.isEmpty()) {
            BalLogUtil.info("BalEngine.tryCreateRealBal no key need create", new Object[0]);
            return;
        }
        Set<String> reBuildKeys = this.reBuildFromArchive(allKeys);
        for (String key : reBuildKeys) {
            keyMap.remove(key);
            oldKeys.remove(key);
        }
        if (!oldKeys.isEmpty()) {
            oldKeys.removeAll(keyMap.keySet());
            if (!oldKeys.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u4f59\u989d\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u4e14\u4e0d\u80fd\u81ea\u52a8\u6062\u590d\uff0c\u4e0d\u80fd\u6267\u884c\u4f59\u989d\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"BalEngine_1", (String)"bos-biz-balance", (Object[])new Object[0]);
                if (this.ctx.isReCalMode()) {
                    BalLogUtil.saveWarn("BalEngine", this.rule.getRuleNo(), "tryCreateRealBal", msg + "oldKeys=" + oldKeys);
                } else {
                    BalLogUtil.warn(msg + "oldKeys=" + oldKeys, new Object[0]);
                    throw new KDBizException(msg);
                }
            }
        }
        this.doCreateRealBal(keyMap);
    }

    private void doCreateRealBal(Map<String, Key> keyMap) {
        if (keyMap.isEmpty()) {
            return;
        }
        DynamicObject[] records = new DynamicObject[keyMap.size()];
        int index = 0;
        long[] globalLongIds = DB.genGlobalLongIds((int)keyMap.size());
        for (Key tempKey : keyMap.values()) {
            records[index] = BusinessDataServiceHelper.newDynamicObject((String)this.balanceTB.getName());
            for (Map.Entry<String, Object> values : tempKey.getColValues().entrySet()) {
                records[index].set(values.getKey(), values.getValue());
            }
            this.putRddColValue(records[index], tempKey);
            records[index].set("id", (Object)globalLongIds[index]);
            records[index].set("keycol", (Object)tempKey.getkeyStr());
            if (this.modifyTimeCol != null) {
                records[index].set(this.modifyTimeCol, (Object)this.now);
            }
            ++index;
        }
        Arrays.sort(records, (a, b) -> a.getString("keycol").compareTo(b.getString("keycol")));
        try (TXHandle tx = TX.requiresNew((String)"tryCreateRealBal");){
            try {
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private Set<String> reBuildFromArchive(Set<String> allKeys) {
        block16: {
            BalLogUtil.info("BalEngine.reBuildFromArchive start allKeys size = " + allKeys.size(), new Object[0]);
            try {
                Map<String, DynamicObject> records = BalRecordSplitManager.loadBalBackRecordByKeycol(this.balanceTB, allKeys);
                Set<String> keySet = records.keySet();
                if (records.isEmpty()) break block16;
                String delSql = "DELETE FROM " + this.balanceTB.getColBackTb() + " WHERE FKEYCOL " + QFUtil.getIdsFilter(keySet, true);
                try (TXHandle tx = TX.requiresNew((String)"reBuildFromArchive");){
                    try {
                        OperateOption option = OperateOption.create();
                        option.setVariableValue("updateModifyDate", "false");
                        SaveServiceHelper.save((DynamicObject[])records.values().toArray(new DynamicObject[0]), (OperateOption)option);
                        DB.execute((DBRoute)this.balanceTB.getDbRoute(), (String)delSql);
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                return keySet;
            }
            catch (Throwable t) {
                BalLogUtil.saveError("BalEngine", "allKeys size = " + allKeys.size(), "reBuildFromArchive", t);
            }
        }
        return Collections.emptySet();
    }

    private boolean isEnableXDB() {
        if (this.enableXDBFlag == -1) {
            this.enableXDBFlag = DB.isSharded((String)this.balanceTB.getTb()) ? 1 : 0;
        }
        return this.enableXDBFlag == 1;
    }

    private void tryCreatePerBal(Map<String, Key> keyMap) {
        BalLogUtil.info("BalEngine.tryCreatePerBal start", new Object[0]);
        TreeMap<Integer, Set> periodGroup = new TreeMap<Integer, Set>();
        for (String string : keyMap.keySet()) {
            String[] periodKey = this.unCalPeriodKey(string);
            String key = periodKey[1];
            int period = Integer.parseInt(periodKey[0]);
            periodGroup.computeIfAbsent(period, k -> new HashSet()).add(key);
        }
        for (Map.Entry entry : periodGroup.entrySet()) {
            this.tryCreateSinglePeriod((Integer)entry.getKey(), (Set)entry.getValue(), keyMap);
        }
    }

    private String[] unCalPeriodKey(String key) {
        int index = key.indexOf("_");
        return new String[]{key.substring(0, index), key.substring(index + 1)};
    }

    private void tryCreateSinglePeriod(int period, Set<String> keySet, Map<String, Key> keyMap) {
        List<String> keys = this.filterExist(period, keySet);
        if (keys == null) {
            return;
        }
        BalLogUtil.info("BalEngine.tryCreateSinglePeriod start: period = " + period + " keySize = " + keySet.size(), new Object[0]);
        List<Object[]> lockParams = this.buildLockParams(keys);
        try (TXHandle lockTx = TX.requiresNew((String)"applyCreateBal").setRollback(true);){
            BalEngineUtil.lockUpdate(this.balanceTB, lockParams);
            try (TXHandle tx = TX.requiresNew((String)"tryCreateSinglePeriod");){
                try {
                    this.createSinglePeriod(period, keys, keyMap);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        BalEngineUtil.forceUnLockUpdate(this.balanceTB);
    }

    private List<Object[]> buildLockParams(List<String> keys) {
        ArrayList<Object[]> lockParams = new ArrayList<Object[]>(keys.size());
        for (String keycol : keys) {
            lockParams.add(new Object[]{keycol});
        }
        return lockParams;
    }

    private List<String> filterExist(int period, Set<String> keys) {
        QFilter fs = new QFilter(this.balanceTB.getPeriodCol(), "=", (Object)period);
        fs.and("keycol", "in", keys);
        try (DataSet keyData = QueryServiceHelper.queryDataSet((String)"filterExist", (String)this.balanceTB.getName(), (String)"keycol", (QFilter[])fs.toArray(), null);){
            int keyIdx = keyData.getRowMeta().getFieldIndex("keycol");
            for (Row row : keyData) {
                keys.remove(row.getString(keyIdx));
            }
        }
        if (keys.isEmpty()) {
            return null;
        }
        ArrayList<String> notExistKeys = new ArrayList<String>(keys);
        Collections.sort(notExistKeys);
        return notExistKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSinglePeriod(int period, List<String> keys, Map<String, Key> keyMap) {
        Set<String> cols = this.balanceTB.getColsByDataType(BizDataType.BAL);
        String periodCol = this.balanceTB.getPeriodCol();
        String endPeriodCol = this.balanceTB.getEndPeriodCol();
        cols.add("id");
        cols.add("keycol");
        cols.add(periodCol);
        cols.add(endPeriodCol);
        Set<String> yearCols = this.balanceTB.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
        cols.addAll(yearCols);
        Set<String> otherCols = this.balanceTB.getColsByDataType(BizDataType.COVER, BizDataType.AUX);
        otherCols.remove("keycol");
        cols.addAll(otherCols);
        String selectCols = String.join((CharSequence)",", cols);
        QFilter fs = new QFilter("keycol", "in", keys);
        fs.and(endPeriodCol, ">", (Object)period);
        try (DataSet datas = null;){
            DynamicObject record;
            datas = QueryServiceHelper.queryDataSet((String)"BalEngine.createSinglePeriod", (String)this.balanceTB.getName(), (String)selectCols, (QFilter[])fs.toArray(), null);
            datas = datas.groupBy(new String[]{"keycol"}).reduceGroup((ReduceGroupFunctionWithCollector)new PeriodReduceGroup(datas.getRowMeta(), periodCol));
            HashMap<String, DynamicObject> newRecords = new HashMap<String, DynamicObject>(16);
            HashMap<String, DynamicObject> splitNewRecords = new HashMap<String, DynamicObject>(16);
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            HashSet<String> notExistKeys = new HashSet<String>(keys);
            for (Row row : datas) {
                String key = row.getString("keycol");
                String keyStr = this.calPeriodKey(key, period);
                notExistKeys.remove(key);
                int startPer = row.getInteger(periodCol);
                int endPer = row.getInteger(endPeriodCol);
                if (startPer == period) continue;
                if (startPer < period && period < endPer) {
                    DynamicObject splitRecord = this.getNewRecord(keyMap.get(keyStr));
                    splitNewRecords.put(key, splitRecord);
                    splitRecord.set(periodCol, (Object)period);
                    splitRecord.set(endPeriodCol, row.get(endPeriodCol));
                    this.copyOtherCols(splitRecord, otherCols, row);
                    Object[] param = new Object[]{this.now, period, row.get("id")};
                    updateParams.add(param);
                    continue;
                }
                record = this.getNewRecord(keyMap.get(keyStr));
                newRecords.put(key, record);
                record.set(periodCol, (Object)period);
                record.set(endPeriodCol, row.get(periodCol));
                this.copyOtherCols(record, otherCols, row);
                this.handleYearCols(period, yearCols, startPer, row, record);
            }
            for (String notExistKey : notExistKeys) {
                record = this.getNewRecord(keyMap.get(this.calPeriodKey(notExistKey, period)));
                record.set(periodCol, (Object)period);
                record.set(endPeriodCol, (Object)999999);
                newRecords.put(notExistKey, record);
            }
            this.saveNewRecords(newRecords);
            this.saveSplitNewRecords(splitNewRecords, updateParams, period, periodCol, yearCols);
        }
    }

    private void saveSplitNewRecords(Map<String, DynamicObject> splitNewRecords, List<Object[]> updateParams, int period, String periodCol, Set<String> yearCols) {
        boolean enableXDB = this.isEnableXDB();
        if (!splitNewRecords.isEmpty()) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    if (enableXDB) {
                        this.handleSplitNewRecords4XDB(splitNewRecords, updateParams, period, periodCol, yearCols);
                    } else {
                        this.handleSplitNewRecords(splitNewRecords, updateParams, period, periodCol, yearCols);
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private void handleSplitNewRecords4XDB(Map<String, DynamicObject> splitNewRecords, List<Object[]> updateParams, int period, String periodCol, Set<String> yearCols) {
        HashMap<Object, Object[]> paramMap = new HashMap<Object, Object[]>(16);
        for (Object[] updateParam : updateParams) {
            paramMap.put(updateParam[2], updateParam);
        }
        Object[] ids = paramMap.keySet().toArray();
        Set<String> cols = this.balanceTB.getAllTypeCols();
        cols.add("id");
        cols.add("keycol");
        QFilter fs = new QFilter("id", "in", (Object)ids);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.balanceTB.getName());
        ArrayList<DynamicObject> newRecords = new ArrayList<DynamicObject>();
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)"handleSplitNewRecords4XDB", (String)this.balanceTB.getName(), (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray(), null);){
            Set<String> initQtyCols = this.balanceTB.getColsByDataType(BizDataType.INIT);
            String endPeriodCol = this.balanceTB.getEndPeriodCol();
            for (Row data : datas) {
                DynamicObject newRecord = BusinessDataServiceHelper.newDynamicObject((String)this.balanceTB.getName());
                for (String col : cols) {
                    newRecord.set(col, data.get(col));
                }
                newRecords.add(newRecord);
                Long id = data.getLong("id");
                newRecord.set(this.modifyTimeCol, ((Object[])paramMap.get(id))[0]);
                newRecord.set(endPeriodCol, ((Object[])paramMap.get(id))[1]);
                String key = data.getString("keycol");
                DynamicObject splitRecord = splitNewRecords.get(key);
                for (String qtyCol : initQtyCols) {
                    Object qty = data.get(qtyCol + "_bal");
                    splitRecord.set(qtyCol, qty);
                    splitRecord.set(qtyCol + "_bal", qty);
                }
                this.handleYearCols(period, yearCols, data.getInteger(periodCol), data, splitRecord);
            }
        }
        long[] newIds = DB.genGlobalLongIds((int)newRecords.size());
        for (int i = 0; i < newIds.length; ++i) {
            ((DynamicObject)newRecords.get(i)).set("id", (Object)newIds[i]);
        }
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])ids);
        SaveServiceHelper.save((DynamicObject[])newRecords.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])splitNewRecords.values().toArray(new DynamicObject[0]));
    }

    private void handleSplitNewRecords(Map<String, DynamicObject> splitNewRecords, List<Object[]> updateParams, int period, String periodCol, Set<String> yearCols) {
        DB.executeBatch((DBRoute)this.balanceTB.getDbRoute(), (String)this.getUpdatePeriodSQL(), updateParams);
        QFilter idFs = new QFilter("id", "in", updateParams.stream().map(param -> param[2]).collect(Collectors.toList()));
        Set<String> select = this.balanceTB.getColsByDataType(BizDataType.YEAR_IN, BizDataType.YEAR_OUT, BizDataType.BAL);
        select.add("keycol");
        select.add(periodCol);
        try (DataSet qtyDatas = QueryServiceHelper.queryDataSet((String)"handleSplitNewRecords", (String)this.balanceTB.getName(), (String)String.join((CharSequence)",", select), (QFilter[])idFs.toArray(), null);){
            Set<String> initQtyCols = this.balanceTB.getColsByDataType(BizDataType.INIT);
            for (Row qtyData : qtyDatas) {
                String key = qtyData.getString("keycol");
                DynamicObject splitRecord = splitNewRecords.get(key);
                for (String qtyCol : initQtyCols) {
                    Object qty = qtyData.get(qtyCol + "_bal");
                    splitRecord.set(qtyCol, qty);
                    splitRecord.set(qtyCol + "_bal", qty);
                }
                this.handleYearCols(period, yearCols, qtyData.getInteger(periodCol), qtyData, splitRecord);
            }
        }
        SaveServiceHelper.save((DynamicObject[])splitNewRecords.values().toArray(new DynamicObject[0]));
    }

    private void saveNewRecords(Map<String, DynamicObject> newRecords) {
        if (!newRecords.isEmpty()) {
            long[] ids = DB.genGlobalLongIds((int)newRecords.size());
            int i = 0;
            for (DynamicObject record : newRecords.values()) {
                record.set("id", (Object)ids[i++]);
            }
            try (TXHandle tx = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])newRecords.values().toArray(new DynamicObject[0]));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private void copyOtherCols(DynamicObject splitRecord, Set<String> otherCols, Row row) {
        for (String otherCol : otherCols) {
            splitRecord.set(otherCol, row.get(otherCol));
        }
    }

    private String getUpdatePeriodSQL() {
        String tb = this.balanceTB.getTb();
        StringBuilder sql = new StringBuilder(" UPDATE ");
        sql.append(tb).append(this.balanceTB.getColTbMap().get(this.balanceTB.getEndPeriodCol()));
        sql.append(" SET ").append(this.balanceTB.getColFieldMap().get(this.balanceTB.getModifyTimeCol())).append(" = ? ,").append(this.balanceTB.getColFieldMap().get(this.balanceTB.getEndPeriodCol())).append(" = ? WHERE ");
        sql.append("fid").append(" = ?");
        return sql.toString();
    }

    private void handleYearCols(int period, Set<String> yearCols, int startPer, Row row, DynamicObject record) {
        if (yearCols.isEmpty()) {
            return;
        }
        if (startPer / 100 == period / 100) {
            for (String yearCol : yearCols) {
                record.set(yearCol, row.get(yearCol));
            }
        } else {
            for (String yearCol : yearCols) {
                record.set(yearCol, (Object)BigDecimal.ZERO);
            }
        }
    }

    private DynamicObject getNewRecord(Key key) {
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)this.balanceTB.getName());
        for (Map.Entry<String, Object> values : key.getColValues().entrySet()) {
            record.set(values.getKey(), values.getValue());
        }
        this.putRddColValue(record, key);
        record.set("keycol", (Object)key.getkeyStr());
        if (this.modifyTimeCol != null) {
            record.set(this.modifyTimeCol, (Object)this.now);
        }
        return record;
    }

    private void putRddColValue(DynamicObject record, Key key) {
        Map<String, Object> rddColValues = key.getRddColValues();
        if (rddColValues == null) {
            return;
        }
        for (Map.Entry<String, Object> values : rddColValues.entrySet()) {
            record.set(values.getKey(), values.getValue());
        }
    }

    private void beforeUpdate() {
        List<IBalanceUpdatePlugin> ps = this.getPlugins();
        BalanceUpdateArgs args = this.createPluginArgs();
        for (IBalanceUpdatePlugin plugin : ps) {
            String pluginName = plugin.getClass().getName();
            long t = System.currentTimeMillis();
            BalLogUtil.info(pluginName + ".beforeUpdate start", new Object[0]);
            if (this.forwardOp) {
                plugin.beforeUpdate(args);
            } else {
                plugin.beforeRollback(args);
            }
            t = System.currentTimeMillis() - t;
            BalLogUtil.info(pluginName + ".beforeUpdate end: " + t + "ms", new Object[0]);
            this.pluginUseTime += t;
        }
    }

    private void beforeJoinUpdate() {
        if (this.checkSpCount && this.spDataCount == 0) {
            BalLogUtil.info("BalEngine.beforeJoinUpdate no need to run : checkSpCount = {}, spDa  taCount = {}", this.checkSpCount, this.spDataCount);
            return;
        }
        List<IBalanceUpdatePlugin> ps = this.getPlugins();
        BalanceUpdateArgs args = this.createPluginArgs();
        args.setGeneratedSpData(this.spDataCount != 0);
        args.setGeneratedDecreaseQty(this.generatedDecreaseQty);
        for (IBalanceUpdatePlugin plugin : ps) {
            String pluginName = plugin.getClass().getName();
            long t = System.currentTimeMillis();
            BalLogUtil.info(pluginName + ".beforeJoinUpdate start", new Object[0]);
            plugin.beforeJoinUpdate(args);
            t = System.currentTimeMillis() - t;
            BalLogUtil.info(pluginName + ".beforeUpdate end: " + t + "ms", new Object[0]);
            this.pluginUseTime += t;
        }
    }

    private BalanceUpdateArgs createPluginArgs() {
        if (this.args == null) {
            BalanceUpdateArgs args = new BalanceUpdateArgs();
            args.setCtx(this.ctx);
            args.setRule(this.rule);
            args.setUpdateTime(this.txId);
            this.args = args;
        }
        return this.args;
    }

    private void afterUpdate() {
        if (this.checkSpCount && this.spDataCount == 0) {
            BalLogUtil.info("BalEngine.afterUpdate no need to run : checkSpCount = {}, spDataCount = {}", this.checkSpCount, this.spDataCount);
            return;
        }
        List<IBalanceUpdatePlugin> ps = this.getPlugins();
        BalanceUpdateArgs args = this.createPluginArgs();
        args.setGeneratedSpData(this.spDataCount != 0);
        args.setGeneratedDecreaseQty(this.generatedDecreaseQty);
        for (IBalanceUpdatePlugin plugin : ps) {
            String pluginName = plugin.getClass().getName();
            long t = System.currentTimeMillis();
            BalLogUtil.info(pluginName + ".afterUpdate start", new Object[0]);
            plugin.afterUpdate(args);
            t = System.currentTimeMillis() - t;
            BalLogUtil.info(pluginName + ".afterUpdate end: " + t + "ms", new Object[0]);
            this.pluginUseTime += t;
        }
    }

    @Override
    public UpdateRule getRule() {
        return this.rule;
    }

    void close() {
        if (this.data != null) {
            this.data.close();
        }
    }
}

