/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.consumer.NotifyMsg;
import kd.bos.bal.business.consumer.ReUpdateMsg;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.BalEngine;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.BalInnerUtil;
import kd.bos.bal.business.core.BalTxListener;
import kd.bos.bal.business.core.BalanceLog;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TxInfo;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalReUpdateParam;
import kd.bos.biz.balance.model.BalUpdateParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.biz.balance.model.IRuleFilter;
import kd.bos.biz.balance.model.UpdateCtx;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalManager {
    public static void doUpdate(BalUpdateParam param) {
        BalLogUtil.info("BalManager.doUpdate start: BalUpdateParam", new Object[0]);
        UpdateCtx ctx = new UpdateCtx(param.getOp(), param.getEntityNumber(), param.getBillIds());
        ctx.setOpAlias(param.getOpAlias());
        ctx.setEntryIds(param.getEntryIds());
        ctx.setWaitType(param.getWaitType());
        ctx.setXdbFlag(param.getOpFlag());
        BalTxListener listener = new BalTxListener(ctx);
        TX.addCommitListener((CommitListener)listener);
        BalManager.doUpdate(ctx);
    }

    public static void doUpdate(UpdateCtx ctx) {
        BalLogUtil.info("BalManager.doUpdate start ", new Object[0]);
        BalanceLog balanceLog = new BalanceLog();
        try {
            BalManager.checkBillIsArchived(ctx);
            ctx.setReCalMode(false);
            List<UpdateRule> rules = BalManager.loadUpdateRule(ctx.getEntityNumber(), ctx.getOp());
            BalManager.sortRules(rules, ctx.getOp());
            BalManager.tryWaitUpdate(ctx, rules);
            BalManager.updateRules(balanceLog, ctx, rules);
            ctx.setOverAndSuccess(true);
        }
        catch (Throwable ex) {
            balanceLog.setFail(ctx, ex);
            BalManager.doRollBackData(ctx);
            throw ex;
        }
        finally {
            balanceLog.save();
        }
    }

    private static void checkBillIsArchived(UpdateCtx ctx) {
    }

    private static void sortRules(List<UpdateRule> rules, String op) {
        rules.sort((r1, r2) -> {
            int hashCode = r1.getBalanceNo().hashCode() - r2.getBalanceNo().hashCode();
            return hashCode == 0 ? BalManager.getIncreaseType(r2, op) - BalManager.getIncreaseType(r1, op) : hashCode;
        });
    }

    private static int getIncreaseType(UpdateRule rule, String op) {
        return rule.getUpdateType() * (rule.isForwardOp(op) ? 1 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void tryWaitUpdate(UpdateCtx ctx, List<UpdateRule> rules) {
        type = ctx.getWaitType();
        if (type == null) return;
        if (type.timeOut <= 0) {
            return;
        }
        BalLogUtil.info("BalManager.tryWaitUpdate start: " + type, new Object[0]);
        limitTime = System.currentTimeMillis() + (long)type.timeOut;
        sleepCount = 0;
        try {
            sql = BalManager.buildSql4NeedWait(ctx, rules);
            while (limitTime > System.currentTimeMillis()) {
                if (BalManager.needWait(sql)) {
                    Thread.sleep(type.interval);
                    ++sleepCount;
                    continue;
                }
                ** GOTO lbl25
            }
            ** GOTO lbl28
        }
        catch (InterruptedException e) {
            try {
                BalLogUtil.error("wait error:", e);
            }
            catch (Throwable var9_10) {
                waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
                BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
                throw var9_10;
            }
lbl25:
            // 1 sources

            waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
            BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
            return;
lbl28:
            // 1 sources

            waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
            BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
            return;
            waitTime = System.currentTimeMillis() - limitTime + (long)type.timeOut;
            BalLogUtil.info("TotalWaitTime={}ms,SleepCount={}", new Object[]{waitTime, sleepCount});
            return;
        }
    }

    private static String buildSql4NeedWait(UpdateCtx ctx, List<UpdateRule> rules) {
        String sql = "SELECT TOP 1 FID FROM T_BAL_UPDATING WHERE ";
        sql = sql + " FBILLID " + QFUtil.getIdsFilter(ctx.getBillIds());
        sql = sql + " AND ";
        sql = sql + " FRULEID " + QFUtil.getIdsFilter(rules.stream().map(UpdateRule::getId).collect(Collectors.toList()), true);
        sql = sql + " AND FBILLENTITY = '" + ctx.getEntityNumber() + "'";
        return sql;
    }

    private static boolean needWait(String sql) {
        try (DataSet data = DB.queryDataSet((String)"look_bal_updating", (DBRoute)IBalance.BAL_DB, (String)sql);){
            boolean bl = !data.isEmpty();
            return bl;
        }
    }

    private static void doRollBackData(UpdateCtx ctx, boolean saveLog) {
        BalLogUtil.info("BalManager.doRollBackData start : saveLog = {}", saveLog);
        if (ctx != null && !ctx.isRollBackOver()) {
            BalanceLog balanceLog = saveLog ? new BalanceLog() : null;
            ctx.setBizRollback(true);
            try {
                Map<Long, TxInfo> txInfo = ctx.getTxInfo();
                List<UpdateRule> rules = txInfo.values().stream().map(TxInfo::getRule).collect(Collectors.toList());
                if (balanceLog != null) {
                    balanceLog.startLog(rules, ctx);
                    BalManager.logStart(balanceLog, rules);
                }
                if (!txInfo.isEmpty()) {
                    Map<BalanceTB, List<TxInfo>> balTxs = BalManager.groupTxByBal(txInfo);
                    BalManager.rollBackSyncRules(ctx, balTxs);
                    BalEngineUtil.clearUpdating(txInfo.keySet());
                    BalManager.clearSpData(balTxs);
                }
                ctx.setRollBackOver(true);
                if (balanceLog != null) {
                    BalManager.logSuccess(balanceLog, rules);
                }
            }
            catch (Throwable ex) {
                if (balanceLog != null) {
                    balanceLog.setFail(ctx, ex);
                }
                throw ex;
            }
            finally {
                if (balanceLog != null) {
                    balanceLog.save();
                }
            }
        }
    }

    public static void doRollBackData(UpdateCtx ctx) {
        BalManager.doRollBackData(ctx, true);
    }

    static void tryMarkSpDataReadable(BalanceTB bal, List<Long> txs) {
        StringBuilder sql = new StringBuilder();
        try {
            sql.append(" UPDATE ").append(bal.getTmpSnapshotTb());
            sql.append(" SET ").append("freadtype").append("='").append("1").append("' WHERE ");
            sql.append("fupdatetime").append(QFUtil.getIdsFilter(txs));
            sql.append(" AND ").append("freadtype").append("='").append("0").append("' ");
            try (TXHandle tx = TX.requiresNew((String)"markSpDataReadable");){
                try {
                    DB.update((DBRoute)bal.getDbRoute(), (String)sql.toString());
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
        catch (Throwable t) {
            BalLogUtil.saveError("BalManager", sql.toString(), "markSpDataReadable", t);
        }
    }

    public static void doReUpdate(BalReUpdateParam param) {
        BalLogUtil.info("BalManager.doReUpdate(BalReUpdateParam) start", new Object[0]);
        try (TXHandle tx = TX.required();){
            Set<UpdateRule> rules = param.getReUpdateRules();
            Set<Object> billIds = param.getBillIds();
            if (rules.isEmpty() || billIds == null || billIds.isEmpty()) {
                return;
            }
            String billEntity = BalManager.getAndCheckEntity(rules);
            String op = StringUtils.isBlank((CharSequence)param.getOp()) ? (param.isRollBack() ? "#re_rollback#" : "#re_cal#") : param.getOp();
            rules = rules.stream().filter(rule -> rule.isMatchUpdate(op)).collect(Collectors.toSet());
            UpdateCtx ctx = new UpdateCtx(op, billEntity, billIds);
            ctx.setForceType(2);
            ctx.setReCalMode(true);
            ctx.setEnableUpdatedFs(param.isEnableUpdatedFs());
            BalTxListener listener = new BalTxListener(ctx);
            TX.addCommitListener((CommitListener)listener);
            BalanceLog balanceLog = param.isSaveLog() ? new BalanceLog() : null;
            try {
                BalManager.updateRules(balanceLog, ctx, rules);
                ctx.setOverAndSuccess(true);
            }
            catch (Throwable ex) {
                BalManager.doRollBackData(ctx, param.isSaveLog());
                if (balanceLog != null) {
                    balanceLog.setFail(ctx, ex);
                }
                throw ex;
            }
            finally {
                if (balanceLog != null) {
                    balanceLog.setTypeAsyncTask();
                    balanceLog.save();
                }
            }
        }
    }

    public static void doReUpdate(Set<Object> billIds, UpdateRule rule) {
        BalReUpdateParam updateParam = new BalReUpdateParam(billIds, null, false);
        updateParam.addReUpdateRules(rule);
        BalManager.doReUpdate(updateParam);
    }

    private static void logSuccess(BalanceLog balanceLog, List<UpdateRule> rules) {
        for (UpdateRule rule : rules) {
            balanceLog.setSuccess(rule, 0L, 0);
        }
    }

    private static void logStart(BalanceLog balanceLog, List<UpdateRule> rules) {
        for (UpdateRule rule : rules) {
            balanceLog.startRule(rule);
        }
    }

    private static Map<BalanceTB, List<TxInfo>> groupTxByBal(Map<Long, TxInfo> txInfo) {
        HashMap<BalanceTB, List<TxInfo>> balTxs = new HashMap<BalanceTB, List<TxInfo>>(8);
        int size = txInfo.size();
        for (TxInfo info : txInfo.values()) {
            BalanceTB bal = info.getRule().getBalanceTB();
            balTxs.computeIfAbsent(bal, k -> new ArrayList(size)).add(info);
        }
        return balTxs;
    }

    private static void rollBackSyncRules(UpdateCtx ctx, Map<BalanceTB, List<TxInfo>> balTxs) {
        BalLogUtil.info("BalManager.rollBackSyncRules start", new Object[0]);
        for (Map.Entry<BalanceTB, List<TxInfo>> entry : balTxs.entrySet()) {
            BalanceTB bal = entry.getKey();
            List txIds = entry.getValue().stream().filter(info -> info.isSync() && info.getStatus() == 2).map(TxInfo::getTxid).collect(Collectors.toList());
            if (txIds.isEmpty()) continue;
            BalManager.syncRollbackBal(ctx, bal, new TreeSet<Long>(txIds));
        }
    }

    private static void syncRollbackBal(UpdateCtx ctx, BalanceTB bal, TreeSet<Long> txIds) {
        BalLogUtil.info("BalManager.syncRollbackBal start", new Object[0]);
        try (TXHandle tx = TX.requiresNew((String)"syncRollbackBal");){
            try {
                BalEngineUtil.syncRollbackBal(bal, txIds);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void createAsyncInfo(UpdateCtx ctx, List<UpdateRule> asyncRules) {
        BalanceTB bal;
        BalLogUtil.info("BalManager.createAsyncInfo start", new Object[0]);
        Set<Object> billIds = ctx.getBillIds();
        int size = asyncRules.size() * billIds.size();
        if (size == 0) {
            return;
        }
        String billEntity = ctx.getEntityNumber();
        String op = ctx.getOp();
        Date now = new Date();
        int xdbFlag = ctx.getXdbFlag();
        String db = ctx.getBillType().getDBRouteKey();
        int i = 0;
        long[] ids = DB.genGlobalLongIds((int)size);
        long userId = RequestContext.getOrCreate().getCurrUserId();
        HashMap<BalanceTB, List> asyncInfoParams = new HashMap<BalanceTB, List>(4);
        for (UpdateRule rule : asyncRules) {
            bal = rule.getBalanceTB();
            List params = asyncInfoParams.computeIfAbsent(bal, k -> new ArrayList(size));
            String ruleId = rule.getId();
            for (Object billId : billIds) {
                params.add(new Object[]{ids[i++], billId, ruleId, rule.getBalanceNo(), billEntity, op, db, xdbFlag, userId, now});
            }
        }
        String appId = ctx.getBillType().getAppId();
        DBRoute billDb = DBRoute.of((String)db);
        for (Map.Entry asyncInfoParam : asyncInfoParams.entrySet()) {
            bal = (BalanceTB)asyncInfoParam.getKey();
            BalManager.tryAddBizDBRecord(bal, appId, db, "1");
            BalManager.addAsyncInfo2BizDB(bal, (List)asyncInfoParam.getValue(), billDb);
        }
    }

    private static void createTxInfo(UpdateCtx ctx, List<BalEngine> engines) {
        BalanceTB bal;
        BalLogUtil.info("BalManager.createTxInfo start", new Object[0]);
        Date now = new Date();
        long userId = RequestContext.getOrCreate().getCurrUserId();
        int xdbFlag = ctx.getXdbFlag();
        String db = ctx.getBillType().getDBRouteKey();
        HashMap<BalanceTB, List> txParams = new HashMap<BalanceTB, List>(4);
        for (BalEngine engine : engines) {
            bal = engine.getRule().getBalanceTB();
            List params = txParams.computeIfAbsent(bal, k -> new ArrayList(2));
            params.add(new Object[]{engine.getTxId(), bal.getName(), db, xdbFlag, userId, now, null});
        }
        DBRoute billDb = DBRoute.of((String)db);
        String appId = ctx.getBillType().getAppId();
        for (Map.Entry txParam : txParams.entrySet()) {
            bal = (BalanceTB)txParam.getKey();
            BalManager.tryAddBizDBRecord(bal, appId, db, "2");
            BalManager.addTx2BizDB(bal, (List)txParam.getValue(), billDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateRules(BalanceLog balanceLog, UpdateCtx ctx, Collection<UpdateRule> rules) {
        boolean saveLog;
        BalManager.checkDataArchive(ctx, rules);
        boolean bl = saveLog = balanceLog != null;
        if (saveLog) {
            balanceLog.startLog(rules, ctx);
        }
        ArrayList<BalEngine> engines = new ArrayList<BalEngine>(rules.size());
        try {
            ArrayList<UpdateRule> asyncRules = new ArrayList<UpdateRule>(rules.size());
            boolean isReCal = ctx.isReCalMode();
            for (UpdateRule rule : rules) {
                if (!isReCal && rule.getBalanceTB().isAsyncUpdate()) {
                    asyncRules.add(rule);
                    ctx.getAllAsyncBals().add(rule.getBalanceNo());
                    continue;
                }
                engines.add(new BalEngine(ctx, rule));
                ctx.getPartAsyncBals().add(rule.getBalanceNo());
            }
            BalManager.createTxInfo(ctx, engines);
            UpdateRule tempRule = null;
            BalEngine tempEngine = null;
            try {
                Iterator iterator = engines.iterator();
                while (iterator.hasNext()) {
                    BalEngine engine;
                    tempEngine = engine = (BalEngine)iterator.next();
                    tempRule = engine.getRule();
                    if (saveLog) {
                        balanceLog.startRule(tempRule);
                    }
                    if (isReCal) {
                        engine.doReCal();
                    } else {
                        engine.doUpdate();
                    }
                    if (!saveLog) continue;
                    balanceLog.setSuccess(tempRule, engine.getPluginUseTime(), engine.getSpDataCount());
                }
            }
            catch (Throwable ex) {
                if (tempRule != null && saveLog) {
                    long useTime = 0L;
                    int spDataCount = 0;
                    if (tempEngine != null) {
                        useTime = tempEngine.getPluginUseTime();
                        spDataCount = tempEngine.getSpDataCount();
                    }
                    balanceLog.setFail(tempRule, useTime, spDataCount, ex);
                }
                throw ex;
            }
            BalManager.createAsyncInfo(ctx, asyncRules);
        }
        finally {
            for (BalEngine engine : engines) {
                engine.close();
            }
        }
    }

    private static long getMinBill(Set<Object> billIds) {
        long minBill = Long.MAX_VALUE;
        for (Object billId : billIds) {
            if (!(billId instanceof Number)) continue;
            long id = (Long)billId;
            minBill = Math.min(minBill, id);
        }
        return minBill;
    }

    private static void checkDataArchive(UpdateCtx ctx, Collection<UpdateRule> rules) {
        ISimpleProperty key = ctx.getBillType().getPrimaryKey();
        if (key == null || key.getPropertyType() == null) {
            return;
        }
        String name = key.getPropertyType().getSimpleName();
        if (!"long".equals(name) && !"int".equals(name)) {
            return;
        }
        Set<Object> billIds = ctx.getBillIds();
        long minBill = BalManager.getMinBill(billIds);
        HashSet<String> bals = new HashSet<String>(8);
        for (UpdateRule rule : rules) {
            String bill;
            long limitId;
            String bal = rule.getBalanceNo();
            if (!bals.add(bal) || minBill >= (limitId = BalInnerUtil.getSpDataLimitId4Check(bal, bill = rule.getEntityNumber()))) continue;
            BalManager.throwIdLimitMsg(ctx, limitId);
            return;
        }
    }

    private static void throwIdLimitMsg(UpdateCtx ctx, long limitId) {
        IDataEntityProperty billNoPro = ctx.getBillType().findProperty("billno");
        String selectCol = billNoPro == null ? "id" : "billno";
        QFilter fs = new QFilter("id", "in", ctx.getBillIds()).and("id", "<=", (Object)limitId);
        StringBuilder msg = new StringBuilder();
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)"throwIdLimitMsg", (String)ctx.getEntityNumber(), (String)selectCol, (QFilter[])fs.toArray(), null);){
            int count = 0;
            for (Row data : datas) {
                if (count != 0) {
                    msg.append(", ");
                }
                msg.append(data.get(selectCol));
                ++count;
                if (msg.length() <= 200) continue;
                msg.append("...");
                break;
            }
        }
        String errorMsg = ResManager.loadKDString((String)"\u4f59\u989d\u66f4\u65b0\u5931\u8d25\uff1a\u5feb\u7167\u7ed3\u8f6c\u8bb0\u5f55\u70b9\u8303\u56f4\u5185\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u4f59\u989d\u66f4\u65b0\uff0c\u5177\u4f53\u7684\u5355\u636e\u6709\uff1a{0}\u3002", (String)"BalManager_2", (String)"bos-biz-balance", (Object[])new Object[]{msg});
        throw new KDBizException(errorMsg);
    }

    private static String getAndCheckEntity(Collection<UpdateRule> rules) {
        String entity = null;
        for (UpdateRule rule : rules) {
            String temp = rule.getEntityNumber();
            if (entity == null) {
                entity = temp;
                continue;
            }
            if (entity.equals(temp)) continue;
            throw new RuntimeException(ResManager.loadKDString((String)"\u91cd\u7b97\u7684\u89c4\u5219\u96c6\u5408\uff0c\u5fc5\u987b\u4e3a\u540c\u4e00\u4e2a\u5355\u636e\u7684\u89c4\u5219\u3002", (String)"BalManager_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        return entity;
    }

    private static void clearSpData(Map<BalanceTB, List<TxInfo>> balTxs) {
        BalLogUtil.info("BalManager.clearSpData start", new Object[0]);
        for (Map.Entry<BalanceTB, List<TxInfo>> entry : balTxs.entrySet()) {
            BalanceTB bal = entry.getKey();
            List txIds = entry.getValue().stream().map(TxInfo::getTxid).collect(Collectors.toList());
            if (txIds.isEmpty()) continue;
            BalManager.clearSpData(bal.getDbRoute(), String.format("DELETE FROM %s WHERE FUPDATETIME %s ", bal.getTmpSnapshotTb(), QFUtil.getIdsFilter(txIds)));
        }
    }

    private static void clearSpData(DBRoute db, String sql) {
        try (TXHandle tx = TX.requiresNew((String)"CLEAR_SPDATA");){
            try {
                DB.execute((DBRoute)db, (String)sql);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void addTx2BizDB(BalanceTB bal, List<Object[]> params, DBRoute billDb) {
        String txTb = bal.getOrCreateTxTb(billDb);
        String sql = "INSERT INTO " + txTb + " (FTXID,FBAL,FDB,FXDBFLAG,FCREATERID,FCREATETIME,FPUBLISHTIME) VALUES (?,?,?,?,?,?,?) ";
        DB.executeBatch((DBRoute)billDb, (String)sql, params);
    }

    private static void addAsyncInfo2BizDB(BalanceTB bal, List<Object[]> params, DBRoute billDb) {
        String asyncInfoTb = bal.getOrCreateTempAsyncInfoTb(billDb);
        String sql = "INSERT INTO " + asyncInfoTb + " (FID,FBILLID,FRULEID,FBAL,FBILLENTITY,FOP,FDB,FXDBFLAG,FCREATERID,FCREATETIME) VALUES (?,?,?,?,?,?,?,?,?,?) ";
        DB.executeBatch((DBRoute)billDb, (String)sql, params);
    }

    public static void checkMsgExists(ReUpdateMsg param, TXHandle tx) {
        Set<Object> ids = param.getIds();
        String sql = "SELECT FID FROM " + param.rule.getBalanceTB().getOrCreateAsyncInfoTb(param.occDb) + " WHERE FID " + QFUtil.getIdsFilter(ids);
        HashSet<Object> errorIds = new HashSet<Object>(ids);
        try (DataSet dataSet = DB.queryDataSet((String)"checkMsgExists", (DBRoute)param.occDb, (String)sql);){
            int idx = dataSet.getRowMeta().getFieldIndex("FID");
            for (Row row : dataSet) {
                errorIds.remove(row.getLong(idx));
            }
        }
        if (!errorIds.isEmpty()) {
            tx.markRollback();
            String msg = ResManager.loadKDString((String)"\u8b66\u544a\u4fe1\u606f\uff1a\u5355\u636e\u5df2\u5728\u5176\u4ed6\u8bf7\u6c42\u5904\u7406\u5b8c\u6bd5\uff0c\u5f53\u524d\u8bf7\u6c42\u4e0d\u80fd\u91cd\u590d\u5904\u7406\uff0c\u5df2\u56de\u6eda\u3002", (String)"BalManager_1", (String)"bos-biz-balance", (Object[])new Object[0]);
            BalLogUtil.saveWarn("BalManager", "param=" + param + ", errorIds=" + errorIds, "checkMsgExist", msg);
            param.setMsgSuccess(false);
        } else {
            param.setMsgSuccess(true);
        }
    }

    public static void clearUpdateInfo(ReUpdateMsg param) {
        BalLogUtil.info("BalManager.clearUpdateInfo start: msgSuccess={},ids.size={}", param.isMsgSuccess(), param.getIds().size());
        if (param.getIds().isEmpty()) {
            return;
        }
        if (param.isMsgSuccess()) {
            try (TXHandle tx = TX.requiresNew((String)"clearUpdateInfo");){
                String sql = "DELETE FROM " + param.rule.getBalanceTB().getOrCreateAsyncInfoTb(param.occDb) + " WHERE FID " + QFUtil.getIdsFilter(param.getIds());
                try {
                    DB.execute((DBRoute)param.occDb, (String)sql);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static void addBizDBRecord(String balName, String appId, String dbKey, String type) {
        block16: {
            BalLogUtil.info("BalManager.addBizDBRecord start", new Object[0]);
            QFilter fs = new QFilter("db", "=", (Object)dbKey).and("bal", "=", (Object)balName).and("type", "=", (Object)type);
            if (!QueryServiceHelper.exists((String)"bal_occurred_dbs", (QFilter[])fs.toArray())) {
                try (TXHandle tx = TX.requiresNew((String)"ADD_BIZ_DB_RECORD");){
                    try {
                        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"bal_occurred_dbs");
                        record.set("bal", (Object)balName);
                        record.set("db", (Object)dbKey);
                        record.set("app", (Object)appId);
                        record.set("type", (Object)type);
                        record.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                        record.set("createtime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                    }
                    catch (Throwable e) {
                        tx.markRollback();
                        if (BalLogUtil.isUniqueError(e)) {
                            BalLogUtil.saveError("BalManager", String.format("dbKey=%s", dbKey), "addBizDBRecord", e);
                            break block16;
                        }
                        throw e;
                    }
                }
            }
        }
    }

    private static void tryAddBizDBRecord(BalanceTB bal, String appId, String dbKey, String type) {
        String cacheKey = appId + type;
        if (bal.getOccAppCache().putIfAbsent(cacheKey, cacheKey) == null) {
            BalManager.addBizDBRecord(bal.getName(), appId, dbKey, type);
        }
    }

    public static List<UpdateRule> loadUpdateRule(String balanceTB) {
        BalanceTB bal = BalanceTB.getBalanceTB(balanceTB);
        List<Object> matchRules = new ArrayList();
        if (bal.isEnable()) {
            matchRules = UpdateRuleCache.getUpdateRuleByBal(balanceTB, null);
        }
        return Collections.unmodifiableList(matchRules);
    }

    private static List<UpdateRule> loadUpdateRule(String srcBillNumber, final String op) {
        List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBill(srcBillNumber, new IRuleFilter(){

            @Override
            public boolean filter(UpdateRule rule) {
                return rule.isEnable() && rule.isMatchUpdate(op) && rule.getBalanceTB().isEnable();
            }
        });
        BalLogUtil.info("BalManager.loadUpdateRule size = " + rules.size(), new Object[0]);
        return rules;
    }

    static void publishTx(UpdateCtx ctx) {
        if (ctx != null) {
            MainEntityType billType = ctx.getBillType();
            String dbKey = billType.getDBRouteKey();
            String appId = billType.getAppId();
            ArrayList<NotifyMsg> notifyMsgs = new ArrayList<NotifyMsg>(4);
            for (String bal : ctx.getPartAsyncBals()) {
                notifyMsgs.add(new NotifyMsg(dbKey, appId, bal, true));
            }
            for (String bal : ctx.getAllAsyncBals()) {
                notifyMsgs.add(new NotifyMsg(dbKey, appId, bal, false));
            }
            BalManager.notifyMQConsumer(notifyMsgs);
        }
    }

    public static void notifyMQConsumer(Collection<NotifyMsg> notifyMsgs) {
        if (notifyMsgs != null) {
            BalManager.notifyMQConsumer(notifyMsgs.toArray(new NotifyMsg[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyMQConsumer(NotifyMsg ... notifyMsgs) {
        if (notifyMsgs == null || notifyMsgs.length == 0) {
            return;
        }
        boolean useMQ = BalConfig.isServiceByMQ();
        BalLogUtil.info("BalManager.notifyMQConsumer start: " + Arrays.toString(notifyMsgs) + ",useMQ: " + useMQ, new Object[0]);
        if (useMQ) {
            try (MessagePublisher pub = null;){
                pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.tx_notify", PartitionStrategy.APP_ID);
                for (NotifyMsg info : notifyMsgs) {
                    pub.publish((Object)JSON.toJSONString((Object)info), info.getAppId());
                }
            }
        } else {
            for (NotifyMsg info : notifyMsgs) {
                BalServiceHelper.invokeBalService(info.getAppId(), "mockNotifyMsg", JSON.toJSONString((Object)info));
            }
        }
        BalLogUtil.info("BalManager.notifyMQConsumer end", new Object[0]);
    }

    public static boolean pollingAllTxs() {
        BalLogUtil.info("BalManager.pollingAllTxs start", new Object[0]);
        try (DLock lock = DLock.create((String)"bal_pollingAllTxs");){
            boolean canDo = lock.tryLock();
            if (canDo) {
                BalEngineUtil.pollingAllTxs();
            }
            boolean bl = canDo;
            return bl;
        }
    }
}

