/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.repair;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.repair.RepairPoint;
import kd.bos.bal.business.sparse.SparseDataLoader;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

abstract class RepairBase {
    protected String taskMode;
    protected final int batch;
    protected Long lastSuccessId;
    protected Collection<Object> resultId;
    protected String seqEntityName;
    protected String seqEntityTb;
    protected long fromId;
    protected long toId;
    protected QFilter otherFs;
    protected DynamicObject taskInfo;
    protected String opRange;
    protected final boolean isIncrement;
    protected RepairPoint point;
    protected BalConfig cfg;
    protected Object[] idSet;
    private final long startTime;

    public void setTaskMode(String taskMode) {
        this.taskMode = taskMode;
    }

    protected QFilter parseBalFs() {
        DynamicObject info = QueryServiceHelper.queryOne((String)"bal_check_repair", (String)"balfsinfo_tag", (QFilter[])new QFilter("id", "=", (Object)this.taskInfo.getLong("parenttask.id")).toArray());
        if (info == null) {
            return null;
        }
        return this.parseFs("parenttask.bal.id", info.getString("balfsinfo_tag"));
    }

    private QFilter parseFs(String entityCol, String fsInfo) {
        String entity = this.taskInfo.getString(entityCol);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{entity, fsInfo})) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)fsInfo, FilterCondition.class);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entity);
        FilterBuilder builder = new FilterBuilder(type, condition);
        builder.buildFilter();
        return builder.getQFilter();
    }

    protected QFilter parseBillFs() {
        DynamicObject info = QueryServiceHelper.queryOne((String)"bal_check_repair", (String)"billfsinfo_tag", (QFilter[])new QFilter("id", "=", (Object)this.taskInfo.getLong("parenttask.id")).toArray());
        if (info == null) {
            return null;
        }
        return this.parseFs("parenttask.bill.id", info.getString("billfsinfo_tag"));
    }

    RepairBase(DynamicObject taskInfo) {
        this.taskInfo = taskInfo;
        this.seqEntityName = taskInfo.getString("sparseseq.entity.id");
        this.seqEntityTb = taskInfo.getString("sparseseq.entitytb");
        this.fromId = taskInfo.getLong("fromid");
        this.toId = taskInfo.getLong("toid");
        this.lastSuccessId = taskInfo.getLong("lastsuccessid");
        this.opRange = taskInfo.getString("parenttask.oprange");
        this.isIncrement = "A".equals(this.opRange);
        String taskType = taskInfo.getString("parenttask.tasktype");
        if (!("J".equals(taskType) || "E".equals(taskType) || this.isIncrement)) {
            long idFrom = taskInfo.getLong("parenttask.idfrom");
            long idTo = taskInfo.getLong("parenttask.idto");
            if (idTo > 0L && idTo != Long.MAX_VALUE) {
                ++idTo;
            }
            if (idFrom > 0L && idFrom > this.fromId) {
                this.fromId = idFrom;
            }
            if (idTo > 0L && idTo < this.toId) {
                this.toId = idTo;
            }
            this.idSet = this.tryParseIdSet(taskInfo);
        }
        this.resultId = new ArrayList<Object>(16);
        this.point = this.getPointInfo();
        this.startTime = new Date().getTime();
        this.cfg = BalConfig.loadBalConfig(taskInfo.getString("parenttask.bal.id"));
        this.batch = this.cfg.getRepairDataBatch();
    }

    private Object[] tryParseIdSet(DynamicObject taskInfo) {
        QFilter fs = new QFilter("id", "=", (Object)taskInfo.getLong("parenttask.id"));
        DynamicObject info = QueryServiceHelper.queryOne((String)"bal_check_repair", (String)"idset_tag", (QFilter[])fs.toArray());
        if (info == null) {
            return null;
        }
        String idStr = info.getString("idset_tag");
        if (StringUtils.isBlank((CharSequence)idStr)) {
            return null;
        }
        String[] ids = idStr.split(",");
        int maxSize = Math.min(ids.length, 1000);
        HashSet<Long> idSet = new HashSet<Long>(maxSize);
        BalUtil.tryParseLong(ids, idSet, maxSize);
        return idSet.isEmpty() ? null : idSet.toArray();
    }

    protected void initResultIds() {
        String dataStr = null;
        try {
            dataStr = this.taskInfo.getString("resultdata_tag");
            if (StringUtils.isBlank((CharSequence)dataStr)) {
                this.resultId = new ArrayList<Object>(16);
            } else {
                JSONObject returnData = JSON.parseObject((String)dataStr);
                JSONArray ids = returnData.getJSONArray("ids");
                this.resultId = new ArrayList<Object>((Collection<Object>)ids);
            }
        }
        catch (Throwable e) {
            BalLogUtil.error("initResultIds error : " + dataStr, e);
            this.resultId = new ArrayList<Object>(16);
        }
    }

    protected abstract void handleFs();

    protected final void appendFs(QFilter fs) {
        if (fs != null) {
            this.otherFs = this.otherFs == null ? fs : this.otherFs.and(fs);
        }
    }

    private TreeSet<Long> getAllIds() {
        this.handleFs();
        this.setParam2Task();
        SparseDataLoader loader = new SparseDataLoader(this.taskInfo, this.fromId, this.toId).setOtherFs(this.otherFs);
        if (this.idSet != null) {
            loader.setIdSet(this.idSet);
        }
        return loader.getAllIds();
    }

    public void check() {
        try {
            if ("C".equals(this.taskMode)) {
                this.repair4Check();
            } else {
                this.checkData();
            }
        }
        finally {
            this.setResultId();
        }
        this.savePointInfo();
    }

    protected void savePointInfo() {
        block16: {
            try {
                QFilter fs;
                DynamicObject info;
                String pointKey = this.taskInfo.getString("pointkey");
                if (!this.isIncrement || !"A".equals(this.taskMode) || !this.resultId.isEmpty() || !StringUtils.isNotBlank((CharSequence)pointKey)) break block16;
                long idPoint = this.taskInfo.getLong("lastsuccessid");
                RepairPoint pointInfo = new RepairPoint(idPoint, this.startTime);
                if (this.point != null) {
                    pointInfo.setIdPoint(Math.max(pointInfo.getIdPoint(), this.point.getIdPoint()));
                    pointInfo.setTimePoint(Math.max(pointInfo.getTimePoint(), this.point.getTimePoint()));
                }
                if ((info = BusinessDataServiceHelper.loadSingle((String)"bal_check_repair_mark", (QFilter[])(fs = new QFilter("pointkey", "=", (Object)pointKey)).toArray())) == null) {
                    info = BusinessDataServiceHelper.newDynamicObject((String)"bal_check_repair_mark");
                    info.set("pointkey", (Object)pointKey);
                }
                info.set("modifydate", (Object)new Date());
                info.set("tasktype", (Object)this.getTaskType4Point());
                info.set("modifier", (Object)RequestContext.getOrCreate().getCurrUserId());
                info.set("pointinfo", (Object)pointInfo.toJsonStr());
                try (TXHandle tx = TX.requiresNew();){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
                }
            }
            catch (Throwable e) {
                BalLogUtil.error("savePointInfo error:", e);
            }
        }
    }

    protected String getTaskType4Point() {
        return null;
    }

    protected String buildParamMsg() {
        String paramStr = String.format("fromId=%s, toId=%s, otherFs = [%s]", this.fromId, this.toId, this.otherFs);
        if (this.point != null) {
            paramStr = paramStr + ", pointInfo=" + this.point;
        }
        paramStr = paramStr + ", idSet.size=" + (this.idSet == null ? 0 : this.idSet.length);
        return paramStr;
    }

    private void setParam2Task() {
        this.taskInfo.set("param_tag", (Object)this.buildParamMsg());
    }

    protected void setResultId() {
        if (!this.resultId.isEmpty()) {
            JSONObject param = new JSONObject();
            param.put("ids", this.resultId);
            this.taskInfo.set("resultdata_tag", (Object)param.toJSONString());
        } else {
            this.taskInfo.set("resultdata_tag", null);
        }
    }

    private void repair4Check() {
        this.initResultIds();
        ArrayList<Object> resultDatas = new ArrayList<Object>(this.batch);
        ArrayList<Object> failDatas = new ArrayList<Object>(this.batch);
        for (Object id : this.resultId) {
            resultDatas.add(id);
            if (resultDatas.size() < this.batch) continue;
            this.innerRepair4Check(resultDatas, failDatas);
            resultDatas.clear();
        }
        if (!resultDatas.isEmpty()) {
            this.innerRepair4Check(resultDatas, failDatas);
        }
        this.resultId = failDatas;
    }

    private void innerRepair4Check(List<Object> resultDatas, List<Object> failDatas) {
        try {
            this.repair4Check(resultDatas);
        }
        catch (Throwable e) {
            failDatas.addAll(resultDatas);
            BalLogUtil.error("repair4Check error : ", e);
            this.taskInfo.set("errormsg_tag", (Object)BalLogUtil.parseMsg(e, 1600));
        }
    }

    protected abstract void repair4Check(List<?> var1);

    protected void checkUpdateRule() {
    }

    protected void checkData() {
        this.checkUpdateRule();
        TreeSet<Object> batchIds = new TreeSet<Object>();
        TreeSet<Long> allIds = this.getAllIds();
        for (Long id : allIds) {
            batchIds.add(id);
            if (batchIds.size() < this.batch) continue;
            this.checkData(batchIds);
            this.setLastSuccessId(batchIds.last());
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.checkData(batchIds);
            this.setLastSuccessId(batchIds.last());
        }
    }

    protected abstract void checkData(TreeSet<Object> var1);

    public void repair() {
        this.checkUpdateRule();
        TreeSet<Object> batchIds = new TreeSet<Object>();
        TreeSet<Long> allIds = this.getAllIds();
        for (Long id : allIds) {
            batchIds.add(id);
            if (batchIds.size() < this.batch) continue;
            this.repairData(batchIds);
            this.setLastSuccessId(batchIds.last());
            batchIds.clear();
        }
        if (!batchIds.isEmpty()) {
            this.repairData(batchIds);
            this.setLastSuccessId(batchIds.last());
        }
        this.savePointInfo();
    }

    protected abstract void repairData(TreeSet<Object> var1);

    public Collection<Object> getResult() {
        return this.resultId;
    }

    protected void setLastSuccessId(Object lastId) {
        this.taskInfo.set("lastsuccessid", lastId);
    }

    private RepairPoint getPointInfo() {
        String pointKey;
        RepairPoint pointInfo = null;
        if (this.isIncrement && StringUtils.isNotBlank((CharSequence)(pointKey = this.taskInfo.getString("pointkey")))) {
            QFilter fs = new QFilter("pointkey", "=", (Object)pointKey);
            DynamicObject info = QueryServiceHelper.queryOne((String)"bal_check_repair_mark", (String)"pointinfo", (QFilter[])fs.toArray());
            String infoStr = info == null ? null : info.getString("pointinfo");
            pointInfo = RepairPoint.buildRepairPoint(infoStr);
        }
        return pointInfo;
    }
}

