/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.repair;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalInnerUtil;
import kd.bos.bal.business.repair.RepairBase;
import kd.bos.bal.business.repair.RepairTaskUtil;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

class RepairBillIsDel
extends RepairBase {
    private final String balName;
    private List<UpdateRule> rules;
    private final String ruleId;
    private final String billName;
    private final long minLimitBillId;

    public RepairBillIsDel(DynamicObject taskInfo) {
        super(taskInfo);
        this.fromId = this.fromId == 0L ? 1L : this.fromId;
        this.balName = taskInfo.getString("parenttask.bal.id");
        this.billName = taskInfo.getString("bill.id");
        this.minLimitBillId = BalInnerUtil.getSpDataLimitId4Check(this.balName, this.billName);
        this.ruleId = taskInfo.getString("rule.id");
        if (StringUtils.isNotBlank((CharSequence)this.ruleId)) {
            UpdateRule rule = UpdateRuleCache.getUpdateRuleFromCache(this.ruleId);
            if (rule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u89e3\u6790\u5931\u8d25\uff1arule is null\u3002", (String)"RepairBillIsDel_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            this.rules = new ArrayList<UpdateRule>(1);
            this.rules.add(rule);
        }
        this.resultId = new HashSet(this.batch);
    }

    @Override
    protected void checkData() {
        this.handleFs();
        this.taskInfo.set("param_tag", (Object)this.buildParamMsg());
        if (this.fromId >= this.toId) {
            return;
        }
        String actualTb = this.taskInfo.getString("sparseseq.actualtb");
        String dbKey = this.taskInfo.getString("sparseseq.dbkey");
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT DISTINCT", new Object[0]).append("fbillid", new Object[0]).append("FROM", new Object[0]).append(actualTb, new Object[0]);
        sql.append("WHERE", new Object[0]).append("fbillid>=?", new Object[]{this.fromId});
        sql.append("AND", new Object[0]).append("fbillid<?", new Object[]{this.toId});
        if (this.idSet != null) {
            sql.append("AND", new Object[0]).appendIn("fbillid", this.idSet);
        }
        sql.append("AND", new Object[0]).append("fbillname=?", new Object[]{this.billName});
        if (StringUtils.isNotBlank((CharSequence)this.ruleId)) {
            sql.append("AND", new Object[0]).append("fupdateruleid=?", new Object[]{this.ruleId});
        }
        sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"A"});
        long maxId = this.fromId;
        try (DataSet balData = DB.queryDataSet((String)"CheckBillIsDel.check", (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sql);){
            for (Row row : balData) {
                long tempId = row.getLong("fbillid");
                this.resultId.add(tempId);
                maxId = Math.max(maxId, tempId);
            }
        }
        QFilter fs = new QFilter("id", "in", (Object)this.resultId);
        try (DataSet billData = QueryServiceHelper.queryDataSet((String)"CheckBillIsDel.check", (String)this.billName, (String)"id", (QFilter[])fs.toArray(), null);){
            for (Row row : billData) {
                this.resultId.remove(row.getLong("id"));
            }
        }
        if (this.resultId.isEmpty()) {
            this.setLastSuccessId(maxId);
        }
    }

    private List<UpdateRule> getBillRules() {
        if (this.rules == null) {
            this.rules = UpdateRuleCache.getUpdateRule(this.balName, this.billName);
        }
        return this.rules;
    }

    @Override
    protected void repair4Check(List<?> dataIds) {
        List<UpdateRule> rules = this.getBillRules();
        RepairTaskUtil.repair4rollBack(rules, dataIds);
    }

    @Override
    public void repairData(TreeSet<Object> ids) {
        List<UpdateRule> rules = this.getBillRules();
        RepairTaskUtil.repair4rollBack(rules, ids);
    }

    @Override
    protected String buildParamMsg() {
        String msg = super.buildParamMsg();
        msg = msg + ", minLimitBillId = " + this.minLimitBillId;
        return msg;
    }

    @Override
    public void repair() {
        this.checkData();
        if (!this.resultId.isEmpty()) {
            TreeSet<Object> ids = new TreeSet<Object>();
            for (Object billId : this.resultId) {
                ids.add(billId);
                if (ids.size() < this.batch) continue;
                this.repairData(ids);
                ids.clear();
            }
            if (!ids.isEmpty()) {
                this.repairData(ids);
            }
            this.resultId.clear();
        }
        if (this.fromId < this.toId && this.toId < Long.MAX_VALUE) {
            this.setLastSuccessId(this.toId);
        }
        this.savePointInfo();
    }

    @Override
    protected void handleFs() {
        if (this.point != null) {
            this.fromId = Math.max(this.point.getIdPoint(), this.fromId);
        }
        if (this.minLimitBillId > this.fromId) {
            this.fromId = this.minLimitBillId;
        }
        if ("B".equals(this.taskMode)) {
            this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
    }

    @Override
    protected void checkData(TreeSet<Object> dataIds) {
    }

    @Override
    protected String getTaskType4Point() {
        return "D";
    }
}

