/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.repair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.bal.business.core.BalInnerUtil;
import kd.bos.bal.business.core.BalSparseTaskHandle;
import kd.bos.bal.business.repair.RepairBillIsDel;
import kd.bos.bal.business.repair.RepairBillSpData;
import kd.bos.bal.business.repair.RepairKeyCol;
import kd.bos.bal.business.repair.RepairRuleDisable;
import kd.bos.bal.business.repair.RepairSpDataSumBal;
import kd.bos.bal.business.repair.RepairTask;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.BalTaskUtil;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

class RepairTaskHandle
extends BalSparseTaskHandle {
    protected RepairTaskHandle() {
        super("bal_check_repair", "bal_check_repair_task", "1");
    }

    @Override
    protected void handleTaskMsg(TaskMsg msg, DynamicObject taskInfo) {
        String taskType;
        this.setPointKey(taskInfo, this.getTaskKey(taskInfo));
        String opresult = taskInfo.getString("parenttask.opresult");
        if ("D".equals(opresult)) {
            taskInfo.set("status", (Object)"E");
            String showMsg = ResManager.loadKDString((String)"\u7236\u4efb\u52a1\u5df2\u624b\u5de5\u7ec8\u6b62\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"RepairTaskHandle_0", (String)"bos-biz-balance", (Object[])new Object[0]);
            taskInfo.set("errormsg_tag", (Object)showMsg);
            return;
        }
        switch (taskType = taskInfo.getString("parenttask.tasktype")) {
            case "A": {
                this.checkBalKeyCol(taskInfo, msg);
                break;
            }
            case "B": {
                this.checkBillSpData(taskInfo, msg);
                break;
            }
            case "D": {
                this.checkBillIsDel(taskInfo, msg);
                break;
            }
            case "J": {
                this.checkRuleDisable(taskInfo, msg);
                break;
            }
            case "C": {
                this.checkSpDataSumBal(taskInfo, msg);
                break;
            }
            case "E": {
                this.clearSpData(taskInfo);
                break;
            }
            case "F": {
                this.repairBalKeyCol(taskInfo, msg);
                break;
            }
            case "G": {
                this.repairBillSpData(taskInfo, msg);
                break;
            }
            case "I": {
                this.repairBillIsDel(taskInfo, msg);
                break;
            }
            case "H": {
                this.repairSpDataSumBal(taskInfo, msg);
                break;
            }
        }
    }

    private void checkRuleDisable(DynamicObject taskInfo, TaskMsg msg) {
        RepairRuleDisable checker = new RepairRuleDisable(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        this.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private void repairSpDataSumBal(DynamicObject taskInfo, TaskMsg msg) {
        RepairSpDataSumBal checker = new RepairSpDataSumBal(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private void repairBillIsDel(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillIsDel checker = new RepairBillIsDel(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private void repairBillSpData(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillSpData checker = new RepairBillSpData(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private void repairBalKeyCol(DynamicObject taskInfo, TaskMsg msg) {
        RepairKeyCol checker = new RepairKeyCol(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private void clearSpData(DynamicObject taskInfo) {
        long fromId = taskInfo.getLong("fromid");
        long toId = taskInfo.getLong("toid");
        long lastSuccessId = taskInfo.getLong("lastsuccessid");
        fromId = Math.max(fromId, lastSuccessId);
        String paramStr = String.format("fromId=%s,toId=%s", fromId, toId);
        taskInfo.set("param_tag", (Object)paramStr);
        if (toId > fromId) {
            DBRoute db = DBRoute.of((String)taskInfo.getString("sparseseq.dbkey"));
            String entitytb = taskInfo.getString("sparseseq.actualtb");
            SqlBuilder sql = new SqlBuilder();
            sql.append("DELETE FROM", new Object[0]).append(entitytb, new Object[0]).append("WHERE", new Object[0]);
            sql.append("fid>=?", new Object[]{fromId});
            sql.append("AND", new Object[0]).append("fid<?", new Object[]{toId});
            sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"B"});
            try (TXHandle tx = TX.requiresNew((String)"clearSpData");){
                DB.execute((DBRoute)db, (SqlBuilder)sql);
            }
            taskInfo.set("lastsuccessid", (Object)toId);
        }
        taskInfo.set("status", (Object)"F");
    }

    private void checkSpDataSumBal(DynamicObject taskInfo, TaskMsg msg) {
        RepairSpDataSumBal checker = new RepairSpDataSumBal(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        this.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private void checkBillIsDel(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillIsDel checker = new RepairBillIsDel(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        this.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private void checkBillSpData(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillSpData checker = new RepairBillSpData(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        this.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private void checkBalKeyCol(DynamicObject taskInfo, TaskMsg msg) {
        RepairKeyCol checker = new RepairKeyCol(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        this.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private void updateTaskInfo(TaskMsg msg, DynamicObject taskInfo, Collection<Object> result) {
        String status = taskInfo.getString("status");
        status = !result.isEmpty() ? (this.isRepairError(msg, status) ? status : "C") : (this.isRepairError(msg, status) ? status : "D");
        taskInfo.set("status", (Object)status);
    }

    private boolean isRepairError(TaskMsg msg, String status) {
        return "C".equals(msg.getMode()) && "E".equals(status);
    }

    @Override
    protected String getLockKey4Consumer(TaskMsg msg, DynamicObject taskInfo) {
        String ponitKey = this.getTaskKey(taskInfo);
        return "bal_" + ponitKey;
    }

    private void setPointKey(DynamicObject taskInfo, String key) {
        String opRange = taskInfo.getString("parenttask.oprange");
        if ("A".equals(opRange)) {
            taskInfo.set("pointkey", (Object)key);
        }
    }

    private String getTaskKey(DynamicObject taskInfo) {
        String taskType = taskInfo.getString("parenttask.tasktype");
        String seqInfo = taskInfo.getString("sparseseq.id") + "_" + taskInfo.getLong("fromid");
        String billId = taskInfo.getString("bill.id");
        String ruleId = taskInfo.getString("rule.id");
        switch (taskType) {
            case "A": 
            case "F": {
                return "A_" + seqInfo;
            }
            case "B": 
            case "G": {
                return "B_" + seqInfo + "_" + ruleId;
            }
            case "D": 
            case "I": {
                return "D_" + seqInfo + "_" + billId;
            }
            case "C": 
            case "H": {
                return "C_" + seqInfo;
            }
            case "J": {
                return "E_" + seqInfo + "_" + ruleId;
            }
            case "E": {
                return "F_" + seqInfo;
            }
        }
        throw new KDBizException("taskType: " + taskType + " not support");
    }

    @Override
    protected void addTask(DynamicObject parentTask) {
        String taskType;
        switch (taskType = parentTask.getString("tasktype")) {
            case "A": {
                this.addCheckBalKeyCol(parentTask);
                break;
            }
            case "B": {
                this.addCheckBillCreateSpData(parentTask);
                break;
            }
            case "D": {
                this.addCheckBillIsDel(parentTask);
                break;
            }
            case "J": {
                this.addCheckRuleDisable(parentTask);
                break;
            }
            case "C": {
                this.addCheckSpDataSumBal(parentTask);
                break;
            }
            case "E": {
                this.addClearSpData(parentTask);
                break;
            }
            case "F": {
                this.addRepairBalKeyCol(parentTask);
                break;
            }
            case "G": {
                this.addRepairBillCreateSpData(parentTask);
                break;
            }
            case "I": {
                this.addRepairBillIsDelOrRollback(parentTask);
                break;
            }
            case "H": {
                this.addRepairSpDataSumBal(parentTask);
                break;
            }
        }
    }

    private void addRepairSpDataSumBal(DynamicObject parentTask) {
        this.addCheckSpDataSumBal(parentTask);
    }

    private void addRepairBillIsDelOrRollback(DynamicObject parentTask) {
        this.addCheckBillIsDel(parentTask);
    }

    private void addRepairBillCreateSpData(DynamicObject parentTask) {
        this.addCheckBillCreateSpData(parentTask);
    }

    private void addRepairBalKeyCol(DynamicObject parentTask) {
        this.addCheckBalKeyCol(parentTask);
    }

    private void addCheckBalKeyCol(DynamicObject parentTask) {
        this.buildTasksByBal(parentTask);
    }

    private void addCheckBillCreateSpData(DynamicObject parentTask) {
        List<UpdateRule> rules = this.parseRuleFromParentTask(parentTask);
        for (UpdateRule rule : rules) {
            if (!rule.isEnable()) continue;
            this.buildTasksByBill(parentTask, rule);
        }
    }

    private void addCheckBillIsDel(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        String billName = parentTask.getString("bill.id");
        String ruleId = parentTask.getString("updaterule.id");
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            this.buildTaskBySpTb(parentTask, bal, ruleId, billName, "fbillid");
        } else if (StringUtils.isNotBlank((CharSequence)billName)) {
            this.buildTaskBySpTb(parentTask, bal, null, billName, "fbillid");
        } else {
            List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
            Set billNames = rules.stream().map(UpdateRule::getEntityNumber).collect(Collectors.toSet());
            for (String bill : billNames) {
                this.buildTaskBySpTb(parentTask, bal, null, bill, "fbillid");
            }
        }
    }

    private void addCheckSpDataSumBal(DynamicObject parentTask) {
        this.buildTasksByBal(parentTask);
    }

    private void addClearSpData(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        this.buildTaskBySpTb(parentTask, bal, null, null, "fid");
    }

    private void addCheckRuleDisable(DynamicObject parentTask) {
        List<UpdateRule> rules = this.parseRuleFromParentTask(parentTask);
        for (UpdateRule rule : rules) {
            if (rule.isEnable()) continue;
            this.buildTaskBySpTb(parentTask, rule.getBalanceTB(), rule.getId(), rule.getEntityNumber(), "fbillid");
        }
    }

    private void buildTaskByEntity(String entityName, DynamicObject parentTask, UpdateRule rule) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityName);
        String[] tbs = BalTaskUtil.getXdbs(type.getAlias(), DBRoute.of((String)type.getDBRouteKey()));
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
        for (String table : tbs) {
            params.add(new SparseSeqParam(entityName, table));
        }
        String ruleId = null;
        String billName = null;
        if (rule != null) {
            ruleId = rule.getId();
            billName = rule.getEntityNumber();
        }
        this.buildTaskBySeqParam(parentTask, params, ruleId, billName);
    }

    private void setLimitIdInfo(List<SparseSeqParam> params, String entityName, DynamicObject parentTask) {
        String taskType = parentTask.getString("tasktype");
        String opRange = parentTask.getString("oprange");
        long fromId = 0L;
        long toId = 0L;
        if (!("A".equals(opRange) || "J".equals(taskType) || "E".equals(taskType))) {
            fromId = parentTask.getLong("idfrom");
            toId = parentTask.getLong("idto");
            long[] idRange = this.getIdRangeFormIdSet(parentTask.getString("idset_tag"));
            fromId = Math.max(fromId, idRange[0]);
            long l = toId = toId == 0L ? idRange[1] : Math.min(toId, idRange[1]);
            if (toId > 0L && toId < Long.MAX_VALUE) {
                ++toId;
            }
        }
        String balName = parentTask.getString("bal.id");
        if ("B".equals(taskType) || "G".equals(taskType) || "J".equals(taskType) || "D".equals(taskType) || "I".equals(taskType)) {
            long limitId = BalInnerUtil.getSpDataLimitId4Check(balName, entityName);
            fromId = Math.max(fromId, limitId);
        }
        BalLogUtil.info("RepairTaskHandle.setLimitIdInfo : fromId = " + fromId + ", to " + toId, new Object[0]);
        for (SparseSeqParam param : params) {
            if (fromId > 0L) {
                param.setMinLimit(fromId);
            }
            if (toId <= 0L) continue;
            param.setMaxLimit(toId);
        }
    }

    private long[] getIdRangeFormIdSet(String idStr) {
        long idFrom = 0L;
        long idTo = 0L;
        if (StringUtils.isNotBlank((CharSequence)idStr)) {
            String[] ids = idStr.split(",");
            int maxSize = Math.min(ids.length, 1000);
            ArrayList<Long> idSet = new ArrayList<Long>(maxSize);
            BalUtil.tryParseLong(ids, idSet, maxSize);
            for (Long id : idSet) {
                idFrom = idFrom == 0L ? id : Math.min(idFrom, id);
                idTo = idTo == 0L ? id : Math.max(idTo, id);
            }
        }
        return new long[]{idFrom, idTo};
    }

    private void buildTaskBySeqParam(DynamicObject parentTask, List<SparseSeqParam> params, String ruleId, String billName) {
        this.setLimitIdInfo(params, billName, parentTask);
        ArrayList<Callable<String>> tasks = new ArrayList<Callable<String>>(params.size());
        for (SparseSeqParam param : params) {
            tasks.add(new RepairTask(parentTask, param, ruleId, billName));
        }
        this.buildTask(tasks);
    }

    private void buildTasksByBill(DynamicObject parentTask, UpdateRule rule) {
        this.buildTaskByEntity(rule.getEntityNumber(), parentTask, rule);
    }

    private void buildTasksByBal(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        this.buildTaskByEntity(balName, parentTask, null);
    }

    private void buildTaskBySpTb(DynamicObject parentTask, BalanceTB bal, String ruleId, String billName, String sparseCol) {
        DBRoute dbRoute = bal.getDbRoute();
        String entityTb = bal.getSnapshotTb();
        String[] tbs = BalTaskUtil.getXdbs(entityTb, dbRoute);
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
        for (String table : tbs) {
            params.add(new SparseSeqParam(dbRoute, entityTb, table, sparseCol));
        }
        this.buildTaskBySeqParam(parentTask, params, ruleId, billName);
    }

    private List<UpdateRule> parseRuleFromParentTask(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        String billName = parentTask.getString("bill.id");
        String ruleId = parentTask.getString("updaterule.id");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            ArrayList<UpdateRule> rules = new ArrayList<UpdateRule>(1);
            rules.add(UpdateRuleCache.getUpdateRuleFromCache(ruleId));
            return rules;
        }
        if (StringUtils.isNotBlank((CharSequence)billName)) {
            return UpdateRuleCache.getUpdateRule(balName, billName);
        }
        return UpdateRuleCache.getUpdateRuleByBal(balName);
    }
}

