/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.common;

import java.sql.SQLException;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;

public class BalLogUtil {
    private static final Log LOG = LogFactory.getLog(BalLogUtil.class);

    public static void warn(String msg, Object ... params) {
        LOG.warn("BalLog: " + msg, params);
    }

    public static void info(String msg, Object ... params) {
        LOG.info("BalLog: " + msg, params);
    }

    public static void error(String msg, Throwable e) {
        LOG.error(msg, e);
    }

    public static String buildMsg(String classInfo, String param, String tips) {
        return "classInfo=" + classInfo + ", param=" + param + ", " + tips;
    }

    public static String buildMsgWithTraceId(String classInfo, String param, String tips, Throwable t) {
        String msg = "traceId=" + TraceIdUtil.getCurrentTraceIdString() + ", " + BalLogUtil.buildMsg(classInfo, param, tips);
        if (t != null) {
            msg = msg + BalLogUtil.parseMsg(t, 500);
        }
        return msg;
    }

    public static void error(String classInfo, String param, String tips, Throwable t) {
        String msg = BalLogUtil.buildMsg(classInfo, param, tips);
        LOG.error(msg, t);
    }

    private static void saveLog2DB(String classInfo, String param, String tips, String msg) {
        DynamicObject error = BusinessDataServiceHelper.newDynamicObject((String)"bal_error_log");
        error.set("id", (Object)DB.genGlobalLongId());
        error.set("classinfo", (Object)classInfo);
        error.set("params_tag", (Object)param);
        error.set("tips", (Object)(tips == null ? "" : tips));
        error.set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
        error.set("errormsg_tag", (Object)msg);
        long createrId = RequestContext.getOrCreate().getCurrUserId();
        error.set("creater", (Object)(createrId == 0L ? 1L : createrId));
        error.set("createtime", (Object)new Date());
        try (TXHandle tx = TX.requiresNew((String)"BalLogManager.error");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{error});
        }
    }

    public static void saveWarn(String classInfo, String param, String tips, String warnMsg) {
        try {
            tips = "warn:" + tips;
            LOG.warn("BalLog: " + BalLogUtil.buildMsg(classInfo, param, tips) + ", msg = " + warnMsg);
            BalLogUtil.saveLog2DB(classInfo, param, tips, warnMsg);
        }
        catch (Throwable e) {
            LOG.error("BalLog save log error:", e);
        }
    }

    public static void saveError(String classInfo, String param, String tips, Throwable t) {
        try {
            BalLogUtil.error(classInfo, param, tips, t);
            BalLogUtil.saveLog2DB(classInfo, param, tips, BalLogUtil.parseMsg(t, 1600));
        }
        catch (Throwable e) {
            LOG.error("BalLog save log error:", e);
        }
    }

    public static String parseMsg(Throwable e, int size) {
        StringBuilder msgStr = new StringBuilder();
        try {
            e = e.getCause() == null ? e : e.getCause();
            msgStr.append(e.getMessage());
            msgStr.append("\r\n").append(e.getClass().getName());
            StackTraceElement[] stackTrace = e.getStackTrace();
            int len = stackTrace.length;
            for (int i = 0; i < len; ++i) {
                if (msgStr.length() > size) {
                    msgStr.setLength(size);
                    break;
                }
                msgStr.append("\r\n at ").append(stackTrace[i]);
            }
            if (msgStr.length() > size) {
                msgStr.setLength(size);
            }
        }
        catch (Throwable t) {
            msgStr.append("BalLog parseMsg error");
            LOG.error("BalLog parseMsg log error:", t);
        }
        return msgStr.toString();
    }

    private static String getSqlErrorMsg(Throwable e) {
        Throwable cause = e.getCause();
        cause = cause == null ? e : cause;
        return cause instanceof SQLException ? cause.getMessage() : null;
    }

    public static boolean isUniqueError(Throwable e) {
        String msg = BalLogUtil.getSqlErrorMsg(e);
        return msg == null ? false : msg.contains("Duplicate entry") || msg.contains("ORA-00001") || msg.contains("unique constraint") || msg.contains("\u552f\u4e00");
    }

    public static boolean isDeadkLockError(Throwable e) {
        String msg = BalLogUtil.getSqlErrorMsg(e);
        return msg == null ? false : msg.contains("Deadlock") || msg.contains("ORA-00060") || msg.contains("deadlock") || msg.contains("\u6b7b\u9501");
    }
}

