/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.common;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.bal.common.OccDBInfo;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.id.IDGenner;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.policy.BalanceFieldMapItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalUtil {
    public static Set<String> splitCombColToList(String combColVal) {
        HashSet<String> tempSet = new HashSet<String>(8);
        if (combColVal != null) {
            String[] keys;
            for (String key : keys = combColVal.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                tempSet.add(key);
            }
        }
        return tempSet;
    }

    public static Set<OccDBInfo> getOccDBInfo(QFilter fs) {
        return BalUtil.getOccDBInfo(fs, false);
    }

    public static Set<OccDBInfo> getOccDBInfoWithBalDb(QFilter fs) {
        return BalUtil.getOccDBInfo(fs, true);
    }

    private static Set<OccDBInfo> getOccDBInfo(QFilter fs, boolean needBalDb) {
        HashSet<OccDBInfo> dbs = new HashSet<OccDBInfo>(8);
        HashSet<String> balNames = new HashSet<String>(8);
        DataSet datas = QueryServiceHelper.queryDataSet((String)"getOccurredBalDBKeys", (String)"bal_occurred_dbs", (String)"bal,db", (QFilter[])fs.toArray(), null);
        Object object = null;
        try {
            for (Row row : datas) {
                BalanceTB bal;
                String dbKey = row.getString("db");
                String balName = row.getString("bal");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{balName, dbKey}) || (bal = BalUtil.tryGetBalanceTB(balName)) == null) continue;
                dbs.add(new OccDBInfo(balName, dbKey));
                balNames.add(balName);
            }
        }
        catch (Throwable balName) {
            object = balName;
            throw balName;
        }
        finally {
            if (datas != null) {
                if (object != null) {
                    try {
                        datas.close();
                    }
                    catch (Throwable balName) {
                        ((Throwable)object).addSuppressed(balName);
                    }
                } else {
                    datas.close();
                }
            }
        }
        if (needBalDb) {
            for (String name : balNames) {
                BalanceTB bal = BalUtil.tryGetBalanceTB(name);
                if (bal == null) continue;
                dbs.add(new OccDBInfo(bal.getName(), bal.getDbRoute().getRouteKey()));
            }
        }
        return dbs;
    }

    private static BalanceTB tryGetBalanceTB(String name) {
        try {
            return BalanceTB.getBalanceTB(name);
        }
        catch (Exception e) {
            BalLogUtil.error("BalUtil", "name=" + name, "tryGetBalanceTB", e);
            return null;
        }
    }

    public static void handleCompatible(BalanceUpdateRuleElement rule, Collection<String> dimEntryCols, Collection<String> occEntyCols) {
        BalanceFieldMapItem item;
        if (rule == null) {
            return;
        }
        HashSet<String> tempDimEntryCols = new HashSet<String>(dimEntryCols);
        HashSet<String> tempOccEntyCols = new HashSet<String>(occEntyCols);
        List items = rule.getFieldMapPolicy().getBalanceFieldMapItems();
        String balCol = null;
        String valType = null;
        for (BalanceFieldMapItem item2 : items) {
            balCol = item2.getTargetField();
            if (tempDimEntryCols.remove(balCol)) {
                valType = item2.getValType();
                if (valType == null) {
                    valType = "0";
                }
                if (valType.equals("0") && StringUtils.isBlank((CharSequence)item2.getSourceField())) {
                    valType = "4";
                }
                item2.setValType(valType);
                continue;
            }
            if (!tempOccEntyCols.remove(balCol)) continue;
            valType = item2.getValType();
            if (valType == null) {
                valType = "0";
            }
            if (valType.equals("0") && StringUtils.isBlank((CharSequence)item2.getSourceField())) {
                valType = "5";
            }
            item2.setValType(valType);
        }
        for (String col : tempDimEntryCols) {
            item = new BalanceFieldMapItem();
            item.setTargetField(col);
            item.setValType("4");
            items.add(item);
        }
        for (String col : tempOccEntyCols) {
            item = new BalanceFieldMapItem();
            item.setTargetField(col);
            item.setValType("5");
            items.add(item);
        }
    }

    public static String buildColExpr(String name, String asName) {
        return name + " " + asName;
    }

    public static boolean isMatch(String str, String ... items) {
        for (String item : items) {
            if (!str.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static Date getDateByDays(int beforeDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(System.currentTimeMillis() - (long)(beforeDays * 24) * 3600L * 1000L));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static long getIdByDate(Date date) {
        IDGenner gen = new IDGenner(1, 1L);
        return gen.getIDRangeOfDay(date).getMinId();
    }

    public static long getIdByDays(int beforeDays) {
        return BalUtil.getIdByDate(BalUtil.getDateByDays(beforeDays));
    }

    public static void tryParseLong(String[] idStr, Collection<Long> idSet, int limitSize) {
        for (String id : idStr) {
            BalUtil.tryParseLong(id, idSet);
            if (idSet.size() <= limitSize) continue;
            return;
        }
    }

    private static void tryParseLong(String id, Collection<Long> idSet) {
        if (StringUtils.isBlank((CharSequence)(id = StringUtils.trim((String)id)))) {
            return;
        }
        try {
            idSet.add(Long.valueOf(id));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

