/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.HashSet;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;

public class BalRecordTplDelOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("keycol");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BalDelValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        String balName = datas[0].getDataEntityType().getName();
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        TreeSet<String> keys = new TreeSet<String>();
        for (DynamicObject data : datas) {
            keys.add(data.getString("keycol"));
        }
        Object[] inKeys = keys.toArray();
        DBRoute dbRoute = bal.getDbRoute();
        if (bal.isPerBal()) {
            SqlBuilder delPerBalRecord = new SqlBuilder();
            delPerBalRecord.append("DELETE FROM", new Object[0]).append(bal.getTb(), new Object[0]);
            delPerBalRecord.append("WHERE", new Object[0]).appendIn("fkeycol", inKeys);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)delPerBalRecord);
        }
        this.tryDelSpData(dbRoute, bal.getTmpSnapshotTb(), inKeys);
        this.tryDelSpData(dbRoute, bal.getSnapshotTb(), inKeys);
    }

    private void tryDelSpData(DBRoute dbRoute, String spTb, Object[] inKeys) {
        SqlBuilder delSp = new SqlBuilder();
        delSp.append("DELETE FROM", new Object[0]).append(spTb, new Object[0]);
        delSp.append("WHERE", new Object[0]).appendIn("fkeycol", inKeys);
        int row = DB.update((DBRoute)dbRoute, (SqlBuilder)delSp);
        if (row > 0) {
            this.throwMsg();
        }
    }

    private void throwMsg() {
        throw new KDBizException(ResManager.loadKDString((String)"\u4e8b\u52a1\u4e2d\u53d1\u73b0\u5b58\u5728\u5df2\u66f4\u65b0\u72b6\u6001\u5feb\u7167\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BalRecordTplDelOp_0", (String)"bos-biz-balance", (Object[])new Object[0]));
    }

    private static class BalDelValidator
    extends AbstractValidator {
        private BalDelValidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate() {
            ExtendedDataEntity[] eDatas = this.getDataEntities();
            if (eDatas == null) {
                return;
            }
            String balName = eDatas[0].getDataEntity().getDataEntityType().getName();
            HashSet<String> keys = new HashSet<String>(100);
            for (ExtendedDataEntity eData : eDatas) {
                keys.add(eData.getDataEntity().getString("keycol"));
            }
            BalanceTB bal = BalanceTB.getBalanceTB(balName);
            SqlBuilder selectSp = new SqlBuilder();
            selectSp.append("SELECT DISTINCT", new Object[0]).append("fkeycol", new Object[0]).append("FROM", new Object[0]).append(bal.getSnapshotTb(), new Object[0]);
            selectSp.append("WHERE", new Object[0]).append("fstatus=?", new Object[]{"A"});
            selectSp.append("AND", new Object[0]).appendIn("fkeycol", keys.toArray());
            SqlBuilder selectTempSp = new SqlBuilder();
            selectTempSp.append("SELECT DISTINCT", new Object[0]).append("fkeycol", new Object[0]).append("FROM", new Object[0]).append(bal.getTmpSnapshotTb(), new Object[0]);
            selectTempSp.append("WHERE", new Object[0]).appendIn("fkeycol", keys.toArray());
            DBRoute dbRoute = bal.getDbRoute();
            try (DataSet spData = null;){
                spData = DB.queryDataSet((String)"BalDelValidator_spData", (DBRoute)dbRoute, (SqlBuilder)selectSp);
                spData = spData.union(DB.queryDataSet((String)"BalDelValidator_tempSpData", (DBRoute)dbRoute, (SqlBuilder)selectTempSp));
                keys.clear();
                for (Row row : spData) {
                    keys.add(row.getString("fkeycol"));
                }
            }
            String key = null;
            String tip = ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u66f4\u65b0\u72b6\u6001\u5feb\u7167\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"BalRecordTplDelOp_1", (String)"bos-biz-balance", (Object[])new Object[0]);
            for (ExtendedDataEntity eData : eDatas) {
                key = eData.getDataEntity().getString("keycol");
                if (!keys.contains(key)) continue;
                this.addErrorMessage(eData, "KEYCOL=" + key + ", " + tip);
            }
        }
    }
}

