/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bal.business.archive.BalRecordSplitManager;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class BalRecordRevertRptForm
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map customParam = queryParam.getCustomParam();
        DynamicObject data = this.getModel().getDataEntity();
        customParam.put("bal", data.getString("bal_s.id"));
        customParam.put("idfrom", data.get("idfrom"));
        customParam.put("idto", data.get("idto"));
        String keycolStr = data.getString("keycol_s");
        Set<String> keys = this.buildList(keycolStr);
        if (!keys.isEmpty()) {
            customParam.put("keycol", keys);
        } else {
            customParam.put("keycol", null);
        }
    }

    private Set<String> buildList(String keycolStr) {
        String[] splits;
        if (StringUtils.isBlank((CharSequence)keycolStr)) {
            return Collections.emptySet();
        }
        HashSet<String> keys = new HashSet<String>(16);
        for (String split : splits = keycolStr.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)split)) continue;
            keys.add(split.trim());
        }
        return keys;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "revertbyselect": {
                this.revertBySelect();
                break;
            }
        }
    }

    private void revertBySelect() {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u6570\u636e\u884c\u3002", (String)"BalRecordRevertRptForm_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        IReportListModel reportModel = reportList.getReportModel();
        ArrayList<String> keycols = new ArrayList<String>(selectedRows.length);
        String balName = null;
        for (int rowIdx : selectedRows) {
            DynamicObject rowData = reportModel.getRowData(rowIdx);
            balName = rowData.getString("bal.id");
            keycols.add(rowData.getString("keycol"));
        }
        try {
            Set<String> errorKeys = BalRecordSplitManager.revertRecordByKeycol(BalanceTB.getBalanceTB(balName), keycols);
            if (!errorKeys.isEmpty()) {
                this.showErrorKeyMessage();
            }
        }
        catch (Throwable e) {
            BalLogUtil.error("BalRecordRevertRptForm.revertBySelect error", e);
            this.showErrorKeyMessage();
        }
        this.getView().refresh();
    }

    private void showErrorKeyMessage() {
        String msg = ResManager.loadKDString((String)"\u538b\u7f29\u8bb0\u5f55\u53ef\u80fd\u5df2\u88ab\u635f\u574f\u65e0\u6cd5\u6b63\u5e38\u8fd8\u539f\u3002", (String)"BalRecordRevertRptForm_1", (String)"bos-biz-balance", (Object[])new Object[0]);
        this.getView().showTipNotification(msg);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "bal_s": {
                this.balChanged(e);
            }
        }
    }

    private void balChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        model.setValue("idfrom", null);
        model.setValue("idto", null);
        model.setValue("keycol_s", null);
    }
}

