/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.servicehelper;

import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.rpc.RpcException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.DubboErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.mservice.rpc.dubbo.DubboBeanManager;
import kd.bos.mservice.rpc.dubbo.DubboServiceLookup;
import kd.bos.mservice.rpc.dubbo.config.KDReferenceConfig;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.PropertiesUtil;
import kd.bos.util.StringUtils;

class BalHandle
implements InvocationHandler {
    private String interfaze;
    private String appId;
    private String dataCodecType = "javaobj";
    private static ConcurrentHashMap<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMap();
    private static final String CLUSTERINSTANCEID = "clusterInstanceId";

    public BalHandle(String interfaze, String appId) {
        this.interfaze = interfaze;
        this.appId = appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ReferenceConfig config = this.appId == null ? referenceConfigMap.computeIfAbsent(this.interfaze, k -> {
            ReferenceConfig cacheConfig = DubboBeanManager.getReferenceConfig((String)this.interfaze);
            cacheConfig = this.copyReferenceConfig(cacheConfig);
            cacheConfig.setScope("remote");
            return cacheConfig;
        }) : referenceConfigMap.computeIfAbsent(this.interfaze + ":" + this.appId, k -> {
            ReferenceConfig cacheConfig = DubboBeanManager.getReferenceConfig((String)this.interfaze);
            cacheConfig = this.copyReferenceConfig(cacheConfig);
            cacheConfig.setProtocol("dubbo");
            String group = System.getProperty(CLUSTERINSTANCEID, "") + this.appId;
            cacheConfig.setGroup(group);
            String appGroup = GrayStrategy.getAppGroup((String)this.appId);
            cacheConfig.setAppgroup(appGroup);
            cacheConfig.setScope("remote");
            return cacheConfig;
        });
        Object bean = null;
        Throwable error = null;
        if (config != null) {
            try {
                bean = config.get();
            }
            catch (Error | Exception t) {
                error = t;
            }
        }
        if (bean == null) {
            String partReason;
            String string = partReason = this.appId != null ? " by appId " + this.appId : "no appId";
            if (error != null) {
                if (error instanceof KDException) {
                    throw error;
                }
                throw new KDException(error, DubboServiceLookup.getErrorCode(), new Object[]{"BalServiceHelper Can't lookup mservice:" + this.interfaze + partReason});
            }
            throw new KDException(error, DubboServiceLookup.getErrorCode(), new Object[]{"BalServiceHelper Can't lookup mservice:" + this.interfaze + partReason + ", no consumer configured."});
        }
        try {
            Throwable throwable = null;
            try (MemSpanTrace span = MemSpanTrace.create((String)method.getDeclaringClass().getName(), (String)(method.getName() + this.toArrayString(args)));){
                Object object;
                if (this.appId != null) {
                    span.addTag("appid", this.appId);
                }
                try {
                    Object result;
                    ThreadTruck.put((Object)"DATACODEC_TYPE_KEY", (Object)this.dataCodecType);
                    object = result = method.invoke(bean, args);
                }
                catch (Throwable throwable2) {
                    try {
                        ThreadTruck.remove((Object)"DATACODEC_TYPE_KEY");
                        throw throwable2;
                    }
                    catch (Throwable result) {
                        throwable = result;
                        throw result;
                    }
                }
                ThreadTruck.remove((Object)"DATACODEC_TYPE_KEY");
                return object;
            }
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException && (e = ((InvocationTargetException)e).getTargetException()) instanceof RpcException) {
                String errorMsg = this.getDubboErrorMessage(this.appId, method, args, e);
                if (e.getCause() != null && e.getCause() instanceof RemotingException) {
                    e = e.getCause();
                }
                if (e instanceof KDException) {
                    throw (KDException)e;
                }
                String msg = StringUtils.isNotEmpty((String)errorMsg) ? errorMsg : "Exception in invoke " + this.interfaze + "(appId=" + this.getShowAppIdInException(this.appId) + "), error is: " + e.getMessage();
                throw new KDException(e, DubboServiceLookup.getErrorCode(), new Object[]{msg});
            }
            if (e instanceof KDException) {
                throw e;
            }
            throw new KDException(e, DubboServiceLookup.getErrorCode(), new Object[]{"Exception in invoke " + this.interfaze + "(appId=" + this.getShowAppIdInException(this.appId) + "), error is: " + e.getMessage()});
        }
    }

    private ReferenceConfig copyReferenceConfig(ReferenceConfig config) {
        List methodConfigList;
        KDReferenceConfig copy = new KDReferenceConfig();
        copy.setApplication(config.getApplication());
        copy.setConsumer(config.getConsumer());
        copy.setRegistries(config.getRegistries());
        copy.setInterface(config.getInterface());
        copy.setTimeout(config.getTimeout());
        copy.setUrl(config.getUrl());
        copy.setScope(config.getScope());
        Integer retries = config.getRetries();
        if (retries != null) {
            copy.setRetries(retries);
        }
        if ((methodConfigList = config.getMethods()) != null) {
            copy.setMethods(methodConfigList);
        }
        return copy;
    }

    private String getDubboErrorMessage(String appId, Method method, Object[] args, Throwable e) {
        String logId = TraceIdUtil.idToHex((long)TraceIdUtil.createId());
        String fullApiName = this.getApiName(method.getDeclaringClass().getName() + "." + method.getName(), args, appId);
        String appIdName = PropertiesUtil.getAppIdName((String)appId);
        String appgroup = GrayStrategy.getAppGroup((String)appId);
        appgroup = "defaultGroup".equals(appgroup) ? "" : appgroup + ".";
        appIdName = (appIdName == null ? "" : appIdName) + (appId == null ? "" : "(" + appgroup + appId + ")");
        int errorCode = ((RpcException)e).getCode();
        String errorMsg = DubboErrorCode.getMsgByCode((int)errorCode, (String)fullApiName, (String)appIdName, (String)logId, (Throwable)e);
        return errorMsg;
    }

    private String getApiName(String classMethodName, Object[] args, String appId) {
        if ("kd.bos.service.DispatchService.invoke".equals(classMethodName) && args.length > 2) {
            String urlMethodName;
            StringBuilder apiNameBuild = new StringBuilder();
            String serviceName = String.valueOf(args[1]);
            String methodName = String.valueOf(args[2]);
            if ("batchInvokeAction".equals(methodName) && StringUtils.isNotEmpty((String)(urlMethodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction")))) {
                methodName = "(" + urlMethodName.replace(appId + ".", "") + ")";
            }
            String fullApiName = apiNameBuild.append(serviceName).append(":").append(methodName).toString();
            return fullApiName;
        }
        return classMethodName;
    }

    private String getShowAppIdInException(String appId) {
        if (appId == null) {
            return "";
        }
        if ("custom".equals(appId)) {
            return "custom[" + ThreadTruck.get((Object)"customForLastestAppid") + "]";
        }
        return appId;
    }

    private String toArrayString(Object[] args) {
        try {
            StringBuilder sb = new StringBuilder("[");
            for (Object o : args) {
                if (o == null) continue;
                if (o instanceof Object[]) {
                    sb.append(Arrays.toString((Object[])o));
                } else {
                    sb.append(o);
                }
                sb.append(" , ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]");
            if (sb.length() > 3000) {
                sb.setLength(3000);
                sb.append(".......");
            }
            return sb.toString();
        }
        catch (Error | Exception e) {
            return Arrays.toString(args);
        }
    }
}

