/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.servicehelper;

import com.alibaba.dubbo.config.ReferenceConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bal.servicehelper.BalHandle;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.instance.Instance;
import kd.bos.mservice.rpc.dubbo.DubboBeanManager;
import kd.bos.mservice.rpc.dubbo.ProxyFactory;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.AppUtils;

public class BalServiceHelper {
    private static final String UPDATE_SERVICE = "BalUpdateService";
    public static final String MOCK_RE_UPDATE_MSG = "mockReUpdateMsg";
    public static final String MOCK_NOTIFY_MSG = "mockNotifyMsg";
    public static final String MOCK_TX_MSG = "mockTxMsg";
    public static final String MOCK_CHECK_TASK_MSG = "mockCheckTaskMsg";
    private static ConcurrentHashMap<String, Object> appIdInstanceMap = new ConcurrentHashMap();

    public static Object invokeBalService(String appId, String methodName, Object ... params) {
        String type = System.getProperty("bal.service.type");
        if ("rpc".equals(type)) {
            return BalServiceHelper.invokeBalServiceByRpc(appId, methodName, params);
        }
        if ("rpc_2".equals(type)) {
            return DispatchServiceHelper.invokeBOSService((String)appId, (String)UPDATE_SERVICE, (String)methodName, (Object[])params);
        }
        throw new RuntimeException("invokeBalService type is not rpc");
    }

    public static Object invokeBalServiceByRpc(String appId, String methodName, Object ... params) {
        try (EntityTraceSpan span = EntityTracer.create((String)(appId + "." + UPDATE_SERVICE), (String)methodName);){
            Object result;
            String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
            DispatchService service = BalServiceHelper.serviceLookup(serviceAppId, DispatchService.class);
            if (service == null) {
                throw new RuntimeException("BalServiceHelper: Mservice consumer by class '" + DispatchService.class + "' and appId '" + appId + "' not found.");
            }
            Object object = result = service.invoke("kd.bos.bal.servicehelper.ServiceFactory", UPDATE_SERVICE, methodName, params);
            return object;
        }
    }

    private static <T> T serviceLookup(String appId, Class<T> clazz) {
        if (!Instance.isAppSplit() && !AppUtils.isDeployAloneApp((String)appId)) {
            ReferenceConfig config = DubboBeanManager.getReferenceConfig((String)clazz.getName());
            if (config == null) {
                return null;
            }
            appId = null;
        }
        String newAppId = appId;
        String key = clazz.getName() + ":" + newAppId;
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> {
            BalHandle handler = new BalHandle(clazz.getName(), newAppId);
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
        });
    }

    private static <T> T serviceLookup(String appId, Class<T> clazz, String prototol, String dataCodecType) {
        if (!Instance.isAppSplit() && !AppUtils.isDeployAloneApp((String)appId)) {
            ReferenceConfig config = DubboBeanManager.getReferenceConfig((String)clazz.getName());
            if (config == null) {
                return null;
            }
            String key = clazz.getName() + "_";
            return (T)appIdInstanceMap.computeIfAbsent(key, k -> BalProxyFactory.localCreateProxyNoAppId(clazz));
        }
        String key = clazz.getName() + ":" + appId + ":" + prototol + ":" + dataCodecType;
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> ProxyFactory.createProxy((Class)clazz, (String)appId, (String)prototol, (String)dataCodecType));
    }

    private static class BalProxyFactory
    extends ProxyFactory {
        private BalProxyFactory() {
        }

        protected static <T> T localCreateProxyNoAppId(Class<T> model) {
            return (T)BalProxyFactory.createProxyNoAppId(model);
        }
    }
}

