/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.util;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;

class RealBalQtyReduceFunc
extends ReduceGroupFunctionWithCollector {
    public static final String DATA_TYPE_FLAG = "balorspdataflag";
    public static final int DATA_BAL = 1;
    public static final int DATA_SP = 2;
    private int dataTypeIdx;
    private int[] qtyIdxs;
    private RowMeta rowMeta;
    private static final long serialVersionUID = 1L;

    public RealBalQtyReduceFunc(RowMeta rowMeta, List<String> spQtyCols) {
        this.rowMeta = rowMeta;
        this.dataTypeIdx = rowMeta.getFieldIndex(DATA_TYPE_FLAG);
        this.qtyIdxs = new int[spQtyCols.size()];
        for (int i = 0; i < this.qtyIdxs.length; ++i) {
            this.qtyIdxs[i] = rowMeta.getFieldIndex(spQtyCols.get(i));
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private BigDecimal[] initQtys(int len) {
        BigDecimal[] qtys = new BigDecimal[len];
        for (int i = 0; i < len; ++i) {
            qtys[i] = BigDecimal.ZERO;
        }
        return qtys;
    }

    public void reduce(Iterator<Row> rows, Collector ct) {
        Object[] balData = null;
        BigDecimal[] qtys = this.initQtys(this.qtyIdxs.length);
        while (rows.hasNext()) {
            Object[] rowData = RowUtil.toArray((Row)rows.next());
            if ((Integer)rowData[this.dataTypeIdx] == 1) {
                balData = balData == null ? rowData : balData;
                continue;
            }
            this.mergeQty(qtys, rowData);
        }
        if (balData != null) {
            for (int i = 0; i < qtys.length; ++i) {
                BigDecimal bal = (BigDecimal)balData[this.qtyIdxs[i]];
                if (qtys[i].compareTo(BigDecimal.ZERO) >= 0) continue;
                balData[this.qtyIdxs[i]] = bal == null ? qtys[i] : bal.add(qtys[i]);
            }
            ct.collect(balData);
        }
    }

    private void mergeQty(BigDecimal[] qtys, Object[] rowData) {
        BigDecimal qty = null;
        for (int i = 0; i < qtys.length; ++i) {
            qty = (BigDecimal)rowData[this.qtyIdxs[i]];
            if (qty == null) continue;
            qtys[i] = qtys[i].add(qty);
        }
    }
}

