/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.DB;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BalanceRuleCacheUtils {
    private static final String CACHETYPE_RULELISTBYBILL = "BalRuleList_ByBill";
    private static final String CACHETYPE_RULELISTBYTABLE = "BalRuleList_ByBalTable";
    private static final String CACHETYPE_RULE = "BalRule";
    private static final String TB_CACHE_KEY_FREFIX = "balance_table_";
    private static final String RULE_CACHE_KEY_FREFIX = "balance_rule_";
    private static final String APP_BPM = "bpm";
    private static final String TWO_STR_PLACEHOLDER = "%s_%s";
    private static final String THREE_STR_PLACEHOLDER = "%s_%s_%s";

    @SdkInternal
    public static Long updateBalVersion(String balEntity) {
        IAppCache cache = AppCache.get((String)APP_BPM);
        Long version = DB.genGlobalLongId();
        cache.put(TB_CACHE_KEY_FREFIX + balEntity, (Object)DB.genGlobalLongId());
        BalanceRuleCacheUtils.updateRuleVersion(balEntity);
        return version;
    }

    public static void removeBalVersion(String balEntity) {
        IAppCache cache = AppCache.get((String)APP_BPM);
        cache.remove(TB_CACHE_KEY_FREFIX + balEntity);
    }

    @SdkInternal
    public static Long getBalTBVersion(String balEntity) {
        IAppCache cache = AppCache.get((String)APP_BPM);
        return (Long)cache.get(TB_CACHE_KEY_FREFIX + balEntity, Long.class);
    }

    @SdkInternal
    public static Long getRuleVersion(String entityName) {
        IAppCache cache = AppCache.get((String)APP_BPM);
        String key = RULE_CACHE_KEY_FREFIX + entityName;
        return (Long)cache.get(key, Long.class);
    }

    @SdkInternal
    public static Long updateRuleVersion(String entityName) {
        IAppCache cache = AppCache.get((String)APP_BPM);
        Long version = DB.genGlobalLongId();
        String key = RULE_CACHE_KEY_FREFIX + entityName;
        cache.put(key, (Object)version);
        return version;
    }

    @SdkInternal
    public static String getRuleDistributeCache(String number, String key, int metaType) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(THREE_STR_PLACEHOLDER, accountId, CACHETYPE_RULE, number);
        return (String)cache.get(cacheType, BalanceRuleCacheUtils.getCacheKey(key, metaType));
    }

    @SdkInternal
    public static void putRuleDistributeCache(String number, String key, int metaType, String val) {
        if (val == null) {
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(THREE_STR_PLACEHOLDER, accountId, CACHETYPE_RULE, number);
        cache.put(cacheType, BalanceRuleCacheUtils.getCacheKey(key, metaType), (Object)val);
    }

    @SdkInternal
    public static void removeRuleDistributeCache(String number, String key, int metaType) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(THREE_STR_PLACEHOLDER, accountId, CACHETYPE_RULE, number);
        cache.remove(cacheType, BalanceRuleCacheUtils.getCacheKey(key, metaType));
    }

    @SdkInternal
    public static void removeRuleDistributeCache(String ... numbers) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String[] cacheTypes = new String[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            cacheTypes[i] = String.format(THREE_STR_PLACEHOLDER, accountId, CACHETYPE_RULE, numbers[i]);
        }
        cache.remove(cacheTypes);
    }

    @SdkInternal
    public static String getBillRuleListDistributeCache(String sourceEntityNumber) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYBILL);
        return (String)cache.get(cacheType, sourceEntityNumber);
    }

    @SdkInternal
    public static void putBillRuleListDistributeCache(String sourceEntityNumber, String val) {
        if (val == null) {
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYBILL);
        cache.put(cacheType, sourceEntityNumber, (Object)val);
    }

    @SdkInternal
    public static void removeBillRuleListDistributeCache(String sourceEntityNumber) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYBILL);
        cache.remove(cacheType, sourceEntityNumber);
    }

    @SdkInternal
    public static void removeBillRuleListDistributeCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYBILL);
        cache.remove(cacheType);
    }

    @SdkInternal
    public static String getTableRuleListDistributeCache(String balanceTableNumber) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYTABLE);
        return (String)cache.get(cacheType, balanceTableNumber);
    }

    @SdkInternal
    public static void putTableRuleListDistributeCache(String balanceTableNumber, String val) {
        if (val == null) {
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYTABLE);
        cache.put(cacheType, balanceTableNumber, (Object)val);
    }

    @SdkInternal
    public static void removeTableRuleListDistributeCache(String balanceTableNumber) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYTABLE);
        cache.remove(cacheType, balanceTableNumber);
    }

    @SdkInternal
    public static void removeTableRuleListDistributeCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String accountId = CacheKeyUtil.getAcctId();
        String cacheType = String.format(TWO_STR_PLACEHOLDER, accountId, CACHETYPE_RULELISTBYTABLE);
        cache.remove(cacheType);
    }

    private static String getCacheKey(String key, int metaType) {
        return String.format("_%s_%s", metaType, key);
    }
}

