/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CheckMessage;
import kd.bos.entity.botp.CheckMessageType;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.model.BalanceUpdateRule;
import kd.bos.metadata.balance.policy.BalanceDataFilterPolicy;
import kd.bos.metadata.balance.policy.BalanceFieldMapPolicy;
import kd.bos.metadata.balance.policy.BalanceLogicConf;
import kd.bos.metadata.balance.policy.BalanceSortCol;
import kd.bos.metadata.exception.ErrorInfo;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BalanceUpdateRuleElement {
    private static final String SYSSTATUS_NORMUAL = "0";
    private static final String CUSTSTATUS_NORMUAL = "2";
    private String id;
    private String number;
    private LocaleString name;
    private long oriVersion = 0L;
    private long extVersion = 0L;
    private String sourceEntityNumber;
    private String balanceTableNumber;
    private String sysStatus = "0";
    private String custStatus = "2";
    private String updateType;
    private String srcMainField;
    private String periodFilterType;
    private String bizDateField;
    private String periodField;
    private String yearField;
    private String monthField;
    private String periodQtyType = "1";
    private String readableType;
    private String update;
    private String rollback;
    private BalanceFieldMapPolicy fieldMapPolicy = new BalanceFieldMapPolicy();
    private BalanceDataFilterPolicy dfPolicy = new BalanceDataFilterPolicy();
    private List<BalanceSortCol> sortCols = new ArrayList<BalanceSortCol>();
    private List<BalanceLogicConf> logicConfs = new ArrayList<BalanceLogicConf>();

    @CollectionPropertyAttribute(collectionItemPropertyType=BalanceSortCol.class)
    public List<BalanceSortCol> getSortEntryRows() {
        return this.sortCols;
    }

    @SdkInternal
    public void setSortEntryRows(List<BalanceSortCol> sortEntryRows) {
        this.sortCols = sortEntryRows;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=BalanceLogicConf.class)
    public List<BalanceLogicConf> getLogicConfs() {
        return this.logicConfs;
    }

    @SdkInternal
    public void setLogicConfs(List<BalanceLogicConf> logicConfs) {
        this.logicConfs = logicConfs;
    }

    public BalanceUpdateRuleElement() {
        this.name = new LocaleString();
    }

    @SimplePropertyAttribute
    public String getReadableType() {
        return this.readableType;
    }

    @SdkInternal
    public void setReadableType(String readableType) {
        this.readableType = readableType;
    }

    @SimplePropertyAttribute
    public String getPeriodQtyType() {
        return this.periodQtyType;
    }

    @SdkInternal
    public void setPeriodQtyType(String periodQtyType) {
        this.periodQtyType = periodQtyType;
    }

    public String getId() {
        return this.id;
    }

    @SdkInternal
    public void setId(String id) {
        this.id = id;
    }

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getNumber() {
        return this.number;
    }

    @SdkInternal
    public void setNumber(String number) {
        this.number = number;
    }

    @SimplePropertyAttribute
    public LocaleString getName() {
        return this.name;
    }

    @SdkInternal
    public void setName(LocaleString name) {
        this.name = name;
    }

    @SimplePropertyAttribute
    public long getOriVersion() {
        return this.oriVersion;
    }

    @SdkInternal
    public void setOriVersion(long oriVersion) {
        this.oriVersion = oriVersion;
    }

    @SimplePropertyAttribute
    public long getExtVersion() {
        return this.extVersion;
    }

    @SdkInternal
    public void setExtVersion(long extVersion) {
        this.extVersion = extVersion;
    }

    @SimplePropertyAttribute
    public String getSourceEntityNumber() {
        return this.sourceEntityNumber;
    }

    @SdkInternal
    public void setSourceEntityNumber(String sourceEntityNumber) {
        this.sourceEntityNumber = sourceEntityNumber;
    }

    @SimplePropertyAttribute
    public String getUpdateType() {
        return this.updateType;
    }

    @SdkInternal
    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    @SimplePropertyAttribute
    public String getPeriodFilterType() {
        return this.periodFilterType;
    }

    @SdkInternal
    public void setPeriodFilterType(String periodFilterType) {
        this.periodFilterType = periodFilterType;
    }

    @SimplePropertyAttribute
    public String getBalanceTableNumber() {
        return this.balanceTableNumber;
    }

    @SdkInternal
    public void setBalanceTableNumber(String balanceTableNumber) {
        this.balanceTableNumber = balanceTableNumber;
    }

    @ComplexPropertyAttribute
    public BalanceDataFilterPolicy getDfPolicy() {
        return this.dfPolicy;
    }

    @SdkInternal
    public void setDfPolicy(BalanceDataFilterPolicy dfPolicy) {
        this.dfPolicy = dfPolicy;
    }

    @SimplePropertyAttribute
    public String getUpdate() {
        return this.update;
    }

    @SdkInternal
    public void setUpdate(String update) {
        this.update = update;
    }

    @SimplePropertyAttribute
    public String getRollback() {
        return this.rollback;
    }

    @SdkInternal
    public void setRollback(String rollback) {
        this.rollback = rollback;
    }

    @SimplePropertyAttribute
    public String getSrcMainField() {
        return this.srcMainField;
    }

    @SdkInternal
    public void setSrcMainField(String srcMainField) {
        this.srcMainField = srcMainField;
    }

    @SimplePropertyAttribute
    public String getBizDateField() {
        return this.bizDateField;
    }

    @SdkInternal
    public void setBizDateField(String bizDateField) {
        this.bizDateField = bizDateField;
    }

    @SimplePropertyAttribute
    public String getPeriodField() {
        return this.periodField;
    }

    @SdkInternal
    public void setPeriodField(String periodField) {
        this.periodField = periodField;
    }

    @SimplePropertyAttribute
    public String getYearField() {
        return this.yearField;
    }

    @SdkInternal
    public void setYearField(String yearField) {
        this.yearField = yearField;
    }

    @SimplePropertyAttribute
    public String getMonthField() {
        return this.monthField;
    }

    @SdkInternal
    public void setMonthField(String monthField) {
        this.monthField = monthField;
    }

    @ComplexPropertyAttribute
    public BalanceFieldMapPolicy getFieldMapPolicy() {
        return this.fieldMapPolicy;
    }

    @SdkInternal
    public void setFieldMapPolicy(BalanceFieldMapPolicy fieldMapPolicy) {
        this.fieldMapPolicy = fieldMapPolicy;
    }

    @SimplePropertyAttribute
    public String getSysStatus() {
        return this.sysStatus;
    }

    @SdkInternal
    public void setSysStatus(String sysStatus) {
        this.sysStatus = sysStatus;
    }

    @SimplePropertyAttribute
    public String getCustStatus() {
        return this.custStatus;
    }

    @SdkInternal
    public void setCustStatus(String custStatus) {
        this.custStatus = custStatus;
    }

    public boolean isNormual() {
        return SYSSTATUS_NORMUAL.equals(this.sysStatus) && CUSTSTATUS_NORMUAL.equals(this.custStatus);
    }

    @SdkInternal
    public BalanceUpdateRule buildRuntimeRule(BalanceUpdateRuleMetadata metadata) {
        CheckResult checkResult = new CheckResult();
        this.check(null, checkResult);
        for (CheckMessage message : checkResult.getMessages()) {
            ErrorInfo errorInfo;
            if (message.getMsgType() == CheckMessageType.Warn) {
                errorInfo = new ErrorInfo(message.getMessage());
                errorInfo.setLevel(1);
                metadata.addError(errorInfo);
                continue;
            }
            if (message.getMsgType() != CheckMessageType.Error) continue;
            errorInfo = new ErrorInfo(message.getMessage());
            errorInfo.setLevel(2);
            metadata.addError(errorInfo);
        }
        BalanceUpdateRule runtimeRule = new BalanceUpdateRule();
        runtimeRule.setNumber(this.getNumber());
        runtimeRule.setName(this.getName());
        runtimeRule.setBalanceTableNumber(this.getBalanceTableNumber());
        runtimeRule.setSourceEntityNumber(this.getSourceEntityNumber());
        runtimeRule.setOriVersion(this.getOriVersion());
        runtimeRule.setExtVersion(this.getExtVersion());
        runtimeRule.setEnable(this.isNormual());
        return runtimeRule;
    }

    @SdkInternal
    public boolean check(CheckPoint parentPoint, CheckResult checkResult) {
        String ruleName = this.getName() == null ? ResManager.loadKDString((String)"\u4f59\u989d\u89c4\u5219", (String)"BalanceUpdateRuleElement_0", (String)"bos-bal-metadata", (Object[])new Object[0]) : this.getName().toString();
        CheckPoint checkPoint = new CheckPoint(parentPoint, ruleName);
        if (StringUtils.isBlank((CharSequence)this.getSourceEntityNumber())) {
            checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceUpdateRuleElement_1", (String)"bos-bal-metadata", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getBalanceTableNumber())) {
            checkResult.addErrorMessage(checkPoint, ResManager.loadKDString((String)"\u4f59\u989d\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceUpdateRuleElement_2", (String)"bos-bal-metadata", (Object[])new Object[0]));
        }
        return checkResult.isPass();
    }
}

