/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.balance;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.dao.MetadataReader;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.StringUtils;

@SdkPublic
public class BalanceUpdateRuleReader {
    public BalanceUpdateRuleMetadata loadMeta(String id, boolean runtime) {
        return this.loadMeta(id, runtime, false);
    }

    public BalanceUpdateRuleMetadata loadMeta(String id, boolean runtime, boolean isBaseMeta) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
        MetadataReader reader = new MetadataReader();
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        return (BalanceUpdateRuleMetadata)meta;
    }

    @SdkInternal
    public static String getIdByNumber(String number) {
        String sql = "select FID from T_BAL_UpdateRuleDesign where FNUMBER = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FNUMBER", 12, (Object)number)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString("FID");
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    @SdkInternal
    public static String getNumberById(String id) {
        String sql = "select FNUMBER from T_BAL_UpdateRuleDesign where FID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    @SdkInternal
    public boolean hadExtRules(String id) {
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
        DesignBalanceRuleMeta designMeta = (DesignBalanceRuleMeta)((Object)BusinessDataReader.read((Object)id, (IDataEntityType)dType, (Boolean)false));
        if (designMeta.getDevType().equals("2")) {
            return true;
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM T_BAL_UpdateRuleDesign ");
        sBuilder.append("WHERE FMasterId = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FMasterId", 12, (Object)id)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List extRuleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        return extRuleIds.size() > 0;
    }

    public static List<BalanceUpdateRuleElement> loadRulesByBalance(String balanceNumber) {
        List<String> ruleIds = BalanceUpdateRuleReader.loadRuleIdsByBalance(balanceNumber, true);
        return BalanceUpdateRuleReader.loadRules(ruleIds);
    }

    public static List<BalanceUpdateRuleElement> loadRulesBySrcBill(String srcEntityNumber) {
        List<String> ruleIds = BalanceUpdateRuleReader.loadRuleIdsBySrcBill(srcEntityNumber, true);
        return BalanceUpdateRuleReader.loadRules(ruleIds);
    }

    @SdkInternal
    public static List<BalanceUpdateRuleElement> loadRules(List<String> ruleIds) {
        if (ruleIds.isEmpty()) {
            return Collections.emptyList();
        }
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
        MetadataReader reader = new MetadataReader();
        ArrayList<BalanceUpdateRuleElement> rules = new ArrayList<BalanceUpdateRuleElement>(ruleIds.size());
        for (String ruleId : ruleIds) {
            BalanceUpdateRuleMetadata metadata = (BalanceUpdateRuleMetadata)reader.readMeta(ruleId, designerMetaType, true, false);
            rules.add(metadata.getRuleElement());
        }
        return rules;
    }

    @SdkInternal
    public static BalanceUpdateRuleElement loadRules(String ruleId) {
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            return null;
        }
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
        MetadataReader reader = new MetadataReader();
        BalanceUpdateRuleMetadata metadata = (BalanceUpdateRuleMetadata)reader.readMeta(ruleId, designerMetaType, true, false);
        return metadata.getRuleElement();
    }

    private static List<String> loadRuleIds(SqlParameter[] params, boolean runtime) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM T_BAL_UpdateRuleDesign WHERE ");
        int index = 0;
        for (SqlParameter param : params) {
            if (index != 0) {
                sBuilder.append(" AND ");
            }
            sBuilder.append(param.getName().replace(":", "")).append(" = ?");
            ++index;
        }
        if (runtime) {
            if (index != 0) {
                sBuilder.append(" AND ");
            }
            sBuilder.append(" FType <> '2'");
        }
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        return ruleIds;
    }

    @SdkInternal
    public static List<String> loadRuleIdsBySrcBill(String srcEntityNumber, boolean runtime) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FSOURCEENTITYNUMBER", 12, (Object)srcEntityNumber)};
        return BalanceUpdateRuleReader.loadRuleIds(params, runtime);
    }

    @SdkInternal
    public static List<String> loadRuleIdsByBalance(String balanceNumber, boolean runtime) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(":FBALANCETABLENUMBER", 12, (Object)balanceNumber)};
        return BalanceUpdateRuleReader.loadRuleIds(params, runtime);
    }
}

