/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.billinterface;

import java.util.EventObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BillInterfacePlugin
extends AbstractFormPlugin {
    private static final String[] combineType_1_fields = new String[5];
    private static final String[] combineType_2_fields = new String[4];

    public void afterCreateNewData(EventObject e) {
        this.showConditionFieldsByBaseInfo(true);
    }

    public void afterBindData(EventObject e) {
        this.showConditionFieldsByBaseInfo(false);
        if ("service".equals(this.getModel().getValue("method"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"method"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("servicename".equals(eventName) || "bill".equals(eventName) || "method".equals(eventName)) {
            if ("servicename".equals(eventName)) {
                if ("billTaxService".equals(newValue)) {
                    this.getModel().setValue("method", (Object)"service");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"method"});
                } else if ("billTaxLineService".equals(newValue)) {
                    this.getModel().setValue("method", (Object)"wholeService");
                    this.getView().setEnable(Boolean.TRUE, new String[]{"method"});
                } else {
                    this.getModel().setValue("method", null);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"method"});
                }
            }
            this.clearConditionFields();
            this.showConditionFieldsByBaseInfo(false);
        }
    }

    private void showConditionFieldsByBaseInfo(boolean isNew) {
        Object bill = this.getModel().getValue("bill");
        Object serviceName = this.getModel().getValue("servicename");
        Object method = this.getModel().getValue("method");
        if (isNew || null != serviceName && null != bill && null != method) {
            if ("billTaxService".equals(serviceName) && "service".equals(method)) {
                this.setVisibleAndMustInput(combineType_2_fields, false);
                this.setVisibleAndMustInput(combineType_1_fields, true);
            } else if ("billTaxLineService".equals(serviceName) && ("wholeService".equals(method) || "partService".equals(method))) {
                this.setVisibleAndMustInput(combineType_1_fields, false);
                this.setVisibleAndMustInput(combineType_2_fields, true);
            } else {
                this.setVisibleAndMustInput(combineType_1_fields, false);
                this.setVisibleAndMustInput(combineType_2_fields, false);
            }
        }
    }

    private void setVisibleAndMustInput(String[] combineTypeFields, boolean value) {
        this.getView().setVisible(Boolean.valueOf(value), combineTypeFields);
        for (String field : combineTypeFields) {
            FieldEdit control = (FieldEdit)this.getControl(field);
            control.setMustInput(value);
            IDataEntityProperty property = this.getModel().getProperty(field);
            if (!(property instanceof FieldProp)) continue;
            ((FieldProp)property).setMustInput(value);
        }
    }

    private void clearConditionFields() {
        for (String field : combineType_1_fields) {
            this.getModel().setValue(field, null);
        }
        for (String field : combineType_2_fields) {
            this.getModel().setValue(field, null);
        }
    }

    static {
        BillInterfacePlugin.combineType_1_fields[0] = "orgkey";
        BillInterfacePlugin.combineType_1_fields[1] = "countrykey";
        BillInterfacePlugin.combineType_1_fields[2] = "datekey";
        BillInterfacePlugin.combineType_1_fields[3] = "taxbillentrykeykey";
        BillInterfacePlugin.combineType_1_fields[4] = "vat";
        BillInterfacePlugin.combineType_2_fields[0] = "taxbillentrykeykey";
        BillInterfacePlugin.combineType_2_fields[1] = "internationaltaxkeykey";
        BillInterfacePlugin.combineType_2_fields[2] = "taxtypekeykey";
        BillInterfacePlugin.combineType_2_fields[3] = "taxcodekeykey";
    }
}

