/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.calformula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class FormulaSetPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(FormulaSetPlugin.class);
    private static final String OK = "btnok";
    private static final String CANCEL = "btncancel";
    private static final String TAX_TYPE = "taxtype";
    private static final String CLEAR = "clr";
    private static final String BACKSPACE = "backspace";
    private static final String ADD = "btnadd";
    private static final String SUBTRACTION = "btnsubtraction";
    private static final String MULTIPLICATION = "btnmultiplication";
    private static final String DIVISON = "btndivison";
    private static final String EQUAL = "btnequal";
    private static final String NOT_EQUAL = "btnnotequal";
    private static final String LESS_THAN = "btnlessthen";
    private static final String MORE_THAN = "btnmorethen";
    private static final String LESS_EQUAL = "btnlessequal";
    private static final String MORE_EQUAL = "btnmoreequal";
    private static final String AND = "btnand";
    private static final String OR = "btnor";
    private static final String LEFT = "btnleft";
    private static final String RIGHT = "btnright";
    private static final String TREE_FIELD = "tv_fields";
    private static final String FORMULA = "formula";
    private static final String TREE_NODE = "treenodes";
    private static final String TRANSFER = "ftranexpr";
    private static final String EXPRESS = "fexpression";
    private static final String DESC = "fdescription";
    private static final String TAXTYPEMAPPING = "taxTypeMapping";
    private static final String PREFIX = "taxType_";
    private static final String AP_SEARCH_AP_SIGN = "searchap";
    private static final String CACHE_PARAM_TREE_NODE_JSON_KEY = "treeNode";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{OK, CANCEL});
        this.addClickListeners(new String[]{TAX_TYPE, CLEAR, BACKSPACE});
        this.addClickListeners(new String[]{ADD, SUBTRACTION, MULTIPLICATION, DIVISON, EQUAL, NOT_EQUAL, LESS_THAN, MORE_THAN, LESS_EQUAL, MORE_EQUAL, AND, OR, LEFT, RIGHT});
        TreeView tv = (TreeView)this.getView().getControl(TREE_FIELD);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getView().getControl(AP_SEARCH_AP_SIGN);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.setFormulaObj(formulaObj);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(TREE_NODE);
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
            this.getPageCache().put(CACHE_PARAM_TREE_NODE_JSON_KEY, json);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (OK.equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
            CRFormula formulaObj = this.deserialize(conditonJson);
            this.getFormulaObj(formulaObj);
            try {
                String tranExpr = this.tranFormula(formulaObj);
                formulaObj.setExprTran(tranExpr);
            }
            catch (FormulaException var6) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaSetPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), var6.getCause() != null ? var6.getCause().getMessage() : var6.getMessage()));
                return;
            }
            catch (Throwable var7) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FormulaSetPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), var7.getMessage()));
                return;
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        } else if (CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)TAX_TYPE)) {
            this.showTaxTypeSetting();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)CLEAR)) {
            this.getModel().setValue(EXPRESS, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)EXPRESS, (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)BACKSPACE)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)BACKSPACE, (String)EXPRESS);
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)TREE_FIELD, (String)EXPRESS, (String)e.getNodeId().toString());
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(EXPRESS)) {
            String expression = (String)this.getModel().getValue(EXPRESS);
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException var5) {
                LOGGER.error((Throwable)var5);
                tranExpr = var5.getCause() != null ? var5.getCause().getMessage() : var5.getMessage();
            }
            catch (Throwable var6) {
                LOGGER.error(var6);
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25", (String)"FormulaSetPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(TRANSFER, (Object)tranExpr);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)TAX_TYPE) && !StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
            this.receiveTaxType((ListSelectedRowCollection)closedCallBackEvent.getReturnData());
        }
    }

    protected CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue(EXPRESS, (Object)formulaObj.getExpression());
        this.getModel().setValue(DESC, (Object)formulaObj.getDescription().toString());
        this.getModel().setValue(TRANSFER, (Object)formulaObj.getExprTran());
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue(EXPRESS);
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(DESC);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(TREE_FIELD);
        tree.addNode(node);
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"FormulaSetPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(TREE_FIELD);
        tree.addNode(root);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        int var4 = -1;
        switch (compareKey.hashCode()) {
            case -1378808635: {
                if (!compareKey.equals(ADD)) break;
                var4 = 0;
                break;
            }
            case -1378808325: {
                if (!compareKey.equals(AND)) break;
                var4 = 10;
                break;
            }
            case -1179832642: {
                if (!compareKey.equals(DIVISON)) break;
                var4 = 3;
                break;
            }
            case -997791075: {
                if (!compareKey.equals(NOT_EQUAL)) break;
                var4 = 5;
                break;
            }
            case -845487581: {
                if (!compareKey.equals(MORE_EQUAL)) break;
                var4 = 9;
                break;
            }
            case -616237854: {
                if (!compareKey.equals(MULTIPLICATION)) break;
                var4 = 2;
                break;
            }
            case -489169518: {
                if (!compareKey.equals(LESS_THAN)) break;
                var4 = 6;
                break;
            }
            case 94070079: {
                if (!compareKey.equals(OR)) break;
                var4 = 11;
                break;
            }
            case 206934115: {
                if (!compareKey.equals(LEFT)) break;
                var4 = 12;
                break;
            }
            case 1497184590: {
                if (!compareKey.equals(MORE_THAN)) break;
                var4 = 7;
                break;
            }
            case 1859708056: {
                if (!compareKey.equals(SUBTRACTION)) break;
                var4 = 1;
                break;
            }
            case 2002044511: {
                if (!compareKey.equals(LESS_EQUAL)) break;
                var4 = 8;
                break;
            }
            case 2113897048: {
                if (!compareKey.equals(EQUAL)) break;
                var4 = 4;
                break;
            }
            case 2125651264: {
                if (!compareKey.equals(RIGHT)) break;
                var4 = 13;
            }
        }
        switch (var4) {
            case 0: {
                compareValue = "+";
                break;
            }
            case 1: {
                compareValue = "-";
                break;
            }
            case 2: {
                compareValue = "*";
                break;
            }
            case 3: {
                compareValue = "/";
                break;
            }
            case 4: {
                compareValue = "=";
                break;
            }
            case 5: {
                compareValue = "<>";
                break;
            }
            case 6: {
                compareValue = "<";
                break;
            }
            case 7: {
                compareValue = ">";
                break;
            }
            case 8: {
                compareValue = "<=";
                break;
            }
            case 9: {
                compareValue = ">=";
                break;
            }
            case 10: {
                compareValue = "and";
                break;
            }
            case 11: {
                compareValue = "or";
                break;
            }
            case 12: {
                compareValue = "(";
                break;
            }
            case 13: {
                compareValue = ")";
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)EXPRESS, (String)compareValue);
        }
    }

    protected String tranFormula(CRFormula formulaObj) {
        return this.tranExpression(formulaObj.getExpression());
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = this.translateTaxType(expression);
        String[] vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length != 0 && !StringUtils.isBlank((CharSequence)vars[0])) {
            String json = (String)this.getView().getFormShowParameter().getCustomParam(TREE_NODE);
            TreeNode rootNode = new TreeNode();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            }
            ArrayList<String> orderVars = new ArrayList<String>(10);
            String[] var7 = vars;
            int i = vars.length;
            for (int var9 = 0; var9 < i; ++var9) {
                String var = var7[var9];
                orderVars.add(var);
            }
            orderVars.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.length() > o2.length()) {
                        return -1;
                    }
                    return o1.length() < o2.length() ? 1 : o2.compareTo(o1);
                }
            });
            HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
            i = 1;
            for (String var : orderVars) {
                String string = String.format("###%s###", String.valueOf(i));
                String varCaption = var;
                TreeNode node = rootNode.getTreeNode(var, 5);
                if (node != null) {
                    varCaption = node.getText();
                }
                tmpVariables.put(string, varCaption);
                expressionDesc = expressionDesc.replace(var, string);
                ++i;
            }
            for (Map.Entry entry : tmpVariables.entrySet()) {
                expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            return expressionDesc;
        }
        return expression;
    }

    private String translateTaxType(String expression) {
        String[] parts = expression.split(PREFIX);
        HashSet<String> taxTypeIds = new HashSet<String>(parts.length);
        if (parts.length == 1) {
            return expression;
        }
        for (int i = 1; i < parts.length; ++i) {
            int index;
            for (index = 0; index < parts[i].length() && Character.isDigit(parts[i].charAt(index)); ++index) {
            }
            taxTypeIds.add(parts[i].substring(0, index));
        }
        Set taxTypeId = taxTypeIds.stream().map(o -> Long.valueOf(o)).collect(Collectors.toSet());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_taxcategory", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", taxTypeId)});
        HashMap<String, String> id2Name = new HashMap<String, String>();
        for (DynamicObject taxType : collection) {
            id2Name.put(taxType.getString("id"), taxType.getString("name"));
        }
        ArrayList entries = new ArrayList(id2Name.entrySet());
        entries.sort((e1, e2) -> ((String)e2.getKey()).length() - ((String)e1.getKey()).length());
        for (Map.Entry entry : entries) {
            expression = expression.replaceAll(PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
        return expression;
    }

    private void showTaxTypeSetting() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_taxcategory", (boolean)true, (int)2);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TAX_TYPE));
        parameter.setMultiSelect(false);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        parameter.getListFilterParameter().setFilter(enable);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void receiveTaxType(ListSelectedRowCollection listSelectedRows) {
        if (null == listSelectedRows || listSelectedRows.size() == 0) {
            return;
        }
        String taxTypeExpress = PREFIX + listSelectedRows.get(0).getPrimaryKeyValue();
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)TAX_TYPE, (String)EXPRESS, (String)taxTypeExpress);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String treeNodeJson = this.getPageCache().get(CACHE_PARAM_TREE_NODE_JSON_KEY);
        if (AP_SEARCH_AP_SIGN.equals(search.getKey()) && StringUtils.isNotEmpty((CharSequence)treeNodeJson)) {
            TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeJson, TreeNode.class);
            List<TreeNode> treeNodes = this.searchTree(treeNode, evt.getText());
            TreeView treeView = (TreeView)this.getControl(TREE_FIELD);
            treeView.updateNodes(treeNodes);
        }
    }

    private List<TreeNode> searchTree(TreeNode rootNode, String searchValue) {
        if (StringUtils.isEmpty((CharSequence)searchValue)) {
            return Collections.singletonList(rootNode);
        }
        if (rootNode.getText().contains(searchValue)) {
            return Collections.singletonList(rootNode);
        }
        this.filterTreeBySearchValue(rootNode.getChildren(), searchValue);
        return Collections.singletonList(rootNode);
    }

    private void filterTreeBySearchValue(List<TreeNode> treeNodes, String searchValue) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return;
        }
        Iterator<TreeNode> iterator = treeNodes.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (treeNode.getText().contains(searchValue)) continue;
            this.filterTreeBySearchValue(treeNode.getChildren(), searchValue);
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) continue;
            iterator.remove();
        }
    }
}

