/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.declaration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bamp.bastax.business.hscode.TaxcHscodeBusiness;
import kd.bamp.bastax.common.constant.HscodeConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class HscodeOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong(HscodeConstant.ID)).collect(Collectors.toList());
                DynamicObject[] objs = TaxcHscodeBusiness.queryTaxcHscodeByIds(ids);
                Map<Long, DynamicObject> collect = Arrays.stream(objs).collect(Collectors.toMap(d -> d.getLong(HscodeConstant.ID), v -> v));
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dynamicObject = collect.get(dataEntity.getDataEntity().getLong(HscodeConstant.ID));
                    if (dynamicObject != null && "1".equals(dynamicObject.getString("issystem"))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9884\u8bbe\u7684\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u3002", (String)"HscodeOp_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    if (!"1".equalsIgnoreCase(currentObj.getString("enable")) || !TaxcHscodeBusiness.checkGroupFieldUnique((DynamicObject)currentObj)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5728\u76f8\u540c\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u5df2\u5b58\u5728\u53ef\u7528\u72b6\u6001\u7684\u6d77\u5173\u7f16\u7801\u3002", (String)"HscodeOp_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

