/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.drcCountry;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DrcCountryEnableOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    Long id = obj.getLong("id");
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)obj.getDataEntityType().getName(), (String)"id,startdate,enddate,country.id,country.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                    Date start = dynamicObject.getDate("startdate");
                    Date end = dynamicObject.getDate("enddate");
                    Long country = dynamicObject.getLong("country.id");
                    boolean isEffective = false;
                    QFilter idQFilter = new QFilter("id", "!=", obj.get("id"));
                    QFilter countryQFilter = new QFilter("country", "=", (Object)country);
                    QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter[] qFilters = new QFilter[]{idQFilter, countryQFilter, enableQFilter};
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)obj.getDataEntityType().getName(), (String)"id,startdate,enddate", (QFilter[])qFilters);
                    for (DynamicObject exist : colls) {
                        Date existStart = exist.getDate("startdate");
                        Date existEnd = exist.getDate("enddate");
                        if (Objects.isNull(end) && Objects.isNull(existEnd)) {
                            isEffective = true;
                            break;
                        }
                        if (!DateUtils.isEffectiveDate((Date)start, (Date)existStart, (Date)existEnd) && !DateUtils.isEffectiveDate((Date)existStart, (Date)start, (Date)end)) continue;
                        isEffective = true;
                        break;
                    }
                    if (!isEffective) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u56fd\u5bb6\u6216\u5730\u533a\uff1a%s\u3002", (String)"DrcCountryEnableOp_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), dynamicObject.getString("country.name")));
                }
                Map map = DrcCountryEnableOp.this.checkDisableEntity(this.dataEntities);
                map.forEach((key, value) -> this.addErrorMessage((ExtendedDataEntity)key, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u56fd\u5bb6\u6216\u5730\u533a\uff1a%s\u3002", (String)"DrcCountryEnableOp_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), value)));
            }
        });
    }

    private Map<ExtendedDataEntity, String> checkDisableEntity(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, String> collectMap = new HashMap<Long, String>();
        HashMap<ExtendedDataEntity, String> returnMap = new HashMap<ExtendedDataEntity, String>(16);
        Map<Long, ExtendedDataEntity> map = Arrays.stream(dataEntities).collect(Collectors.toMap(o -> o.getDataEntity().getLong("id"), object -> object));
        QFilter qFilter = new QFilter("id", "in", (Object)map.keySet().toArray());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)dataEntities[0].getDataEntity().getDataEntityType().getName(), (String)"id,startdate,enddate,country.id,country.name", (QFilter[])new QFilter[]{qFilter});
        collection.stream().forEach(o -> this.compareCountryDate((Map<Long, String>)collectMap, (DynamicObject)o, collection));
        collectMap.forEach((k, v) -> returnMap.put((ExtendedDataEntity)map.get(k), (String)v));
        return returnMap;
    }

    private void compareCountryDate(Map<Long, String> collectMap, DynamicObject object, DynamicObjectCollection collection) {
        for (DynamicObject o : collection) {
            Long id = object.getLong("id");
            Date start = object.getDate("startdate");
            Date end = object.getDate("enddate");
            Long country = object.getLong("country.id");
            String countryName = object.getString("country.name");
            Long existId = o.getLong("id");
            Date existStart = o.getDate("startdate");
            Date existEnd = o.getDate("enddate");
            Long existCountry = o.getLong("country.id");
            if (id.equals(existId) || !country.equals(existCountry)) continue;
            if (Objects.isNull(end) && Objects.isNull(existEnd)) {
                collectMap.put(id, countryName);
                break;
            }
            if (!DateUtils.isEffectiveDate((Date)start, (Date)existStart, (Date)existEnd) && !DateUtils.isEffectiveDate((Date)existStart, (Date)start, (Date)end)) continue;
            collectMap.put(id, countryName);
            break;
        }
    }
}

