/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.event;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bamp.bastax.business.taxcorg.TaxcOrgBusiness;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.JSONUtils;

public class BosOrgSaveEventServicePlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(BosOrgSaveEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("BosOrgSaveEventServicePlugin,event id:{},number:{}", (Object)evt.getEventNumber(), (Object)evt.getEventId());
        try {
            List<String> newOrgIds;
            EntityEvent event;
            List ids;
            if (evt instanceof EntityEvent && (ids = (event = (EntityEvent)evt).getBusinesskeys()).size() > 0 && (newOrgIds = this.filterOrg(ids)).size() > 0) {
                HashMap<String, List<String>> params = new HashMap<String, List<String>>();
                params.put("ids", newOrgIds);
                EventServiceHelper.triggerEventSubscribe((String)"bastax_bos_org.save", (String)JSONUtils.toString(params));
            }
        }
        catch (Exception ex) {
            logger.error("BosOrgSaveEventServicePlugin error." + ex.getMessage(), (Throwable)ex);
        }
        return evt.getEventId();
    }

    protected List<String> filterOrg(List<String> ids) {
        List orgIds = ids.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList());
        DynamicObject[] basOrgs = TaxcOrgBusiness.queryTaxcOrgByOrgId(orgIds, null, (boolean)true);
        Map<String, DynamicObject> basOrgMap = Stream.of(basOrgs).collect(Collectors.toMap(k -> String.valueOf(k.getLong("id")), v -> v));
        List<String> newOrgIds = ids.stream().filter(v -> !basOrgMap.containsKey(v)).collect(Collectors.toList());
        return newOrgIds;
    }
}

