/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxarea;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bamp.bastax.common.enums.AddressTermsEnum;
import kd.bamp.bastax.formplugin.common.AbstractTaxPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AddresstermsEdit
extends AbstractTaxPlugin
implements RowClickEventListener,
ClickListener {
    private static final String ADMINISTRATIVELEVEL = "administrativelevel";
    private static final String VALUE = "value";
    private static final String VALUEID = "valueid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{VALUE});
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)VALUE, (CharSequence)source.getKey()) && ObjectUtils.isEmpty((Object)this.getModel().getValue(ADMINISTRATIVELEVEL))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u653f\u7ea7\u6b21\u3002", (String)"AddresstermsEdit_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)VALUE, (CharSequence)source.getKey())) {
            Object level = this.getModel().getValue(ADMINISTRATIVELEVEL);
            this.openBillListF7(this.getModel().getValue(VALUEID), AddressTermsEnum.getEnumByKey((String)String.valueOf(level)));
        }
    }

    private void openBillListF7(Object pkId, AddressTermsEnum addressTermsEnum) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(addressTermsEnum.getBillFormId());
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)addressTermsEnum.getBillFormId());
        listShowParameter.setFormId(formConfig.getF7ListFormId());
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(css);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setShowTitle(true);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setLookUp(true);
        if (!ObjectUtils.isEmpty((Object)pkId)) {
            listShowParameter.setSelectedRow(pkId);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)AddressTermsEnum.PROVINCE.getBillFormId(), (CharSequence)addressTermsEnum.getBillFormId())) {
            QFilter qFilter = new QFilter("level", "=", (Object)Long.valueOf(addressTermsEnum.getLevel()));
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, addressTermsEnum.getBillFormId());
        listShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (!ObjectUtils.isEmpty((Object)listDatas)) {
            for (ListSelectedRow row : listDatas) {
                this.getModel().setValue(VALUE, (Object)row.getName());
                this.getModel().setValue("valuenumber", (Object)row.getNumber());
                this.getModel().setValue(VALUEID, row.getPrimaryKeyValue());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)ADMINISTRATIVELEVEL, (CharSequence)fieldKey)) {
            this.getModel().setValue(VALUE, (Object)"");
            this.getModel().setValue("valuenumber", (Object)"");
            this.getModel().setValue(VALUEID, (Object)"");
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if (!ObjectUtils.isEmpty((Object)e.getSourceData()) && e.getSourceData() instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)e.getSourceData();
            JSONArray conditions = jsonObject.getJSONArray("entryentity");
            for (Object object : conditions) {
                JSONObject row = (JSONObject)object;
                String administrativelevel = row.getString(ADMINISTRATIVELEVEL);
                String value = row.getString(VALUE);
                String valuenumber = row.getString("valuenumber");
                QFilter valueQFilter = new QFilter("name", "=", (Object)value);
                QFilter valuenumberQFilter = new QFilter("number", "=", (Object)valuenumber);
                DynamicObjectCollection baseDataTpyes = QueryServiceHelper.query((String)AddressTermsEnum.getEnumByKey((String)administrativelevel).getBillFormId(), (String)"id", (QFilter[])new QFilter[]{valueQFilter, valuenumberQFilter});
                if (!ObjectUtils.isEmpty((Object)baseDataTpyes) && baseDataTpyes.size() > 0) {
                    DynamicObject dynamicObject = (DynamicObject)baseDataTpyes.get(0);
                    row.put(VALUEID, (Object)dynamicObject.getLong("id"));
                    continue;
                }
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u503c\u7f16\u7801\uff1a%1$s,\u503c:%2$s\u67e5\u4e0d\u5230\u6570\u636e\u3002", (String)"AddresstermsEdit_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), valuenumber, value));
            }
        }
    }
}

