/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxorg;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bamp.bastax.business.taxarea.TaxcAreaBusiness;
import kd.bamp.bastax.common.constant.OrgConstant;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bamp.bastax.common.util.EmptyCheckUtils;
import kd.bamp.bastax.common.util.PermissionUtils;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bamp.bastax.common.util.param.SystemParamUtil;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class TaxorgPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY_TAXATIONSYS = "entry_taxationsys";
    private static final String ENTRY_APPLYTAXTYPE = "entry_applytaxtype";
    private static final String ENTRY_TAXAREA = "entry_taxarea";
    private static final String ENTRY_ISTAXPAYER = "entry_istaxpayer";
    private static final String ENTRY_TAXPAYER = "entry_taxpayer";
    private static final String ENTRY_TAXPAYERDETAIL = "entry_taxpayerdetail";
    private static final String ENTRY_UNIFIEDSOCIALCODE = "entry_unifiedsocialcode";
    private static final String ENTRY_STATUS = "entry_status";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxationsysEdit = (BasedataEdit)this.getView().getControl(ENTRY_TAXATIONSYS);
        taxationsysEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        taxationsysEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getView().getControl(ENTRY_APPLYTAXTYPE);
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaEdit = (BasedataEdit)this.getView().getControl(ENTRY_TAXAREA);
        taxAreaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.NonModal);
        ((FormShowParameter)e.getSource()).setOpenStyle(openStyle);
        Boolean isOverseasTaxOrg = SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId());
        StyleCss css = new StyleCss();
        if (isOverseasTaxOrg.booleanValue()) {
            css.setWidth("850px");
            css.setHeight("460px");
        } else {
            css.setWidth("650px");
            css.setHeight("300px");
        }
        openStyle.setInlineStyleCss(css);
    }

    public void afterLoadData(EventObject e) {
        ((BasedataPropEdit)this.getControl("name")).setMustInput(true);
        ((BasedataPropEdit)this.getControl("number")).setMustInput(true);
    }

    public void beforeBindData(EventObject e) {
        long orgId;
        DynamicObject[] load;
        super.beforeBindData(e);
        String listOrgId = (String)this.getView().getFormShowParameter().getCustomParam("listOrgId");
        String cmborgtypeId = (String)this.getView().getFormShowParameter().getCustomParam("cmborttypeId");
        if (StringUtils.isNotBlank((CharSequence)listOrgId) && (load = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,number,uniformsocialcreditcode,orgpattern,patterntype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(orgId = Long.parseLong(listOrgId)))})) != null && load.length > 0) {
            DynamicObject[] cmborgtypeObjs;
            DynamicObject org = load[0];
            this.getModel().setValue("id", (Object)orgId);
            this.getModel().setValue("org", (Object)org);
            boolean istaxpayer = this.isEntityByOrg(org);
            if (istaxpayer) {
                this.getModel().setValue("taxpayer", (Object)org.getString("name"));
            }
            this.getModel().setValue("unifiedsocialcode", (Object)org.getString("uniformsocialcreditcode"));
            this.getModel().setValue("istaxpayer", (Object)istaxpayer);
            if (StringUtils.isNotBlank((CharSequence)cmborgtypeId) && (cmborgtypeObjs = BusinessDataServiceHelper.load((String)"bos_org_biz", (String)"id,fname,fnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(cmborgtypeId))})) != null && cmborgtypeObjs.length > 0) {
                DynamicObject cmborgtypeObj = cmborgtypeObjs[0];
                this.getModel().setValue("cmborgtype", (Object)cmborgtypeObj);
            }
        }
        this.visibleFlex();
        this.disableTaxationSys();
    }

    public void afterBindData(EventObject e) {
        boolean hasSpecificPerm;
        Object pk;
        String unifiedsocialcode;
        super.afterBindData(e);
        Boolean newValue = (Boolean)this.getModel().getValue("istaxpayer");
        TextEdit taxpayer = (TextEdit)this.getControl("taxpayer");
        TextEdit unifiedsocialcodeEdit = (TextEdit)this.getControl("unifiedsocialcode");
        if (newValue != null && newValue.booleanValue()) {
            taxpayer.setMustInput(true);
            unifiedsocialcodeEdit.setMustInput(true);
        }
        if (StringUtils.isNotBlank((CharSequence)(unifiedsocialcode = (String)this.getModel().getValue("unifiedsocialcode")))) {
            this.getPageCache().put("unifiedsocialcode", StringUtil.trim((String)unifiedsocialcode));
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(pk = this.getModel().getDataEntity().getPkValue())) && !StringUtils.equals((CharSequence)"0", (CharSequence)String.valueOf(pk)) && !(hasSpecificPerm = PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4715a0df000000ac"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"taxpayer", "istaxpayer", "isvirtual", "unifiedsocialcode", "cmborgtype", "buttonap1"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        ((BasedataPropEdit)this.getControl("name")).setMustInput(true);
        ((BasedataPropEdit)this.getControl("number")).setMustInput(true);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("istaxpayer".equals(propertyName)) {
            Boolean newValue = (Boolean)args.getChangeSet()[0].getNewValue();
            TextEdit taxpayer = (TextEdit)this.getControl("taxpayer");
            TextEdit unifiedsocialcode = (TextEdit)this.getControl("unifiedsocialcode");
            if (newValue != null && newValue.booleanValue()) {
                taxpayer.setMustInput(true);
                unifiedsocialcode.setMustInput(true);
            } else {
                taxpayer.setMustInput(false);
                unifiedsocialcode.setMustInput(false);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)ENTRY_TAXATIONSYS)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            IntStream.range(0, collection.size()).forEach(focusRow -> {
                DynamicObject focusRowObject = (DynamicObject)collection.get(focusRow);
                String entryTaxpayer = focusRowObject.getString(ENTRY_TAXPAYER);
                if (StringUtil.isEmpty((CharSequence)entryTaxpayer)) {
                    this.getModel().setValue(ENTRY_TAXPAYER, this.getModel().getValue("taxpayer"), focusRow);
                }
            });
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow2 = entryentity.getEntryState().getFocusRow();
            this.getModel().setValue(ENTRY_APPLYTAXTYPE, null, focusRow2);
            this.getModel().setValue(ENTRY_TAXAREA, null, focusRow2);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObjectCollection collection;
            this.getModel().setValue("unifiedsocialcode", (Object)StringUtil.trim((String)((String)this.getModel().getValue("unifiedsocialcode"))));
            this.getModel().setValue("taxpayer", (Object)StringUtil.trim((String)((String)this.getModel().getValue("taxpayer"))));
            DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
            IntStream.range(0, coll.size()).forEach(focusRow -> {
                DynamicObject focusRowObject = (DynamicObject)coll.get(focusRow);
                this.getModel().setValue(ENTRY_UNIFIEDSOCIALCODE, (Object)StringUtil.trim((String)focusRowObject.getString(ENTRY_UNIFIEDSOCIALCODE)), focusRow);
                this.getModel().setValue(ENTRY_TAXPAYER, (Object)StringUtil.trim((String)focusRowObject.getString(ENTRY_TAXPAYER)), focusRow);
            });
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("org"))) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxorgPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            String licensestatus = (String)this.getModel().getValue("licensestatus");
            String old = this.getPageCache().get("unifiedsocialcode");
            if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
                String entryUnifiedsocialcode = null;
                DynamicObjectCollection collection2 = this.getModel().getEntryEntity(ENTRYENTITY);
                for (int focusRow2 = 0; focusRow2 < collection2.size(); ++focusRow2) {
                    DynamicObject row2 = (DynamicObject)collection2.get(focusRow2);
                    if (!OrgConstant.CHN_TAXATIONSYS.equals(row2.getLong("entry_taxationsys.id"))) continue;
                    entryUnifiedsocialcode = row2.getString(ENTRY_UNIFIEDSOCIALCODE);
                    break;
                }
                if (null != entryUnifiedsocialcode && (StringUtils.equals((CharSequence)"B", (CharSequence)licensestatus) || StringUtils.equals((CharSequence)"C", (CharSequence)licensestatus)) && !StringUtils.equals((CharSequence)old, entryUnifiedsocialcode)) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6388\u6743\u7684\u7a0e\u52a1\u7ec4\u7ec7\u624d\u53ef\u4ee5\u4fee\u6539\u7a0e\u53f7\u3002", (String)"TaxorgPlugin_26", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                String unifiedsocialcode = (String)this.getModel().getValue("unifiedsocialcode");
                if ((StringUtils.equals((CharSequence)"B", (CharSequence)licensestatus) || StringUtils.equals((CharSequence)"C", (CharSequence)licensestatus)) && !StringUtils.equals((CharSequence)old, (CharSequence)unifiedsocialcode)) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6388\u6743\u7684\u7a0e\u52a1\u7ec4\u7ec7\u624d\u53ef\u4ee5\u4fee\u6539\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (String)"TaxorgPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (this.validateFail()) {
                args.setCancel(true);
                return;
            }
            if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
                collection = this.getModel().getEntryEntity(ENTRYENTITY);
                if (ObjectUtils.isEmpty((Object)collection)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1a\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxorgPlugin_27", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Map<String, String> entryTaxpayerDetailMap = collection.stream().filter(row -> StringUtil.equalsIgnoreCase((CharSequence)"1", (CharSequence)row.getString(ENTRY_TAXPAYERDETAIL))).collect(Collectors.toMap(o -> o.getString("entry_taxationsys.id"), o -> "1", (k1, k2) -> k1));
                IntStream.range(0, collection.size()).forEach(focusRow -> {
                    DynamicObject focusRowObject = (DynamicObject)collection.get(focusRow);
                    this.getModel().setValue(ENTRY_TAXPAYERDETAIL, (Object)(ObjectUtils.isEmpty(entryTaxpayerDetailMap.get(focusRowObject.getString("entry_taxationsys.id"))) ? "" : "1"), focusRow);
                });
                boolean isCHN = false;
                for (DynamicObject row3 : collection) {
                    if (!OrgConstant.CHN_TAXATIONSYS.equals(row3.getLong("entry_taxationsys.id"))) continue;
                    isCHN = true;
                    this.getModel().setValue("taxpayer", row3.get(ENTRY_TAXPAYER));
                    this.getModel().setValue("istaxpayer", row3.get(ENTRY_ISTAXPAYER));
                    this.getModel().setValue("unifiedsocialcode", (Object)row3.getString(ENTRY_UNIFIEDSOCIALCODE));
                    this.getModel().setValue("isvirtual", (Object)(row3.getBoolean(ENTRY_ISTAXPAYER) ? Boolean.FALSE : Boolean.TRUE));
                }
                if (!isCHN) {
                    TextEdit taxpayer1 = (TextEdit)this.getControl("taxpayer");
                    TextEdit unifiedsocialcode1 = (TextEdit)this.getControl("unifiedsocialcode");
                    taxpayer1.setMustInput(false);
                    unifiedsocialcode1.setMustInput(false);
                }
            } else {
                collection = this.getModel().getEntryEntity(ENTRYENTITY);
                for (int focusRow3 = 0; focusRow3 < collection.size(); ++focusRow3) {
                    DynamicObject row4 = (DynamicObject)collection.get(focusRow3);
                    if (!OrgConstant.CHN_TAXATIONSYS.equals(row4.getLong("entry_taxationsys.id"))) continue;
                    this.getModel().setValue(ENTRY_TAXPAYER, this.getModel().getValue("taxpayer"), focusRow3);
                    this.getModel().setValue(ENTRY_ISTAXPAYER, this.getModel().getValue("istaxpayer"), focusRow3);
                    this.getModel().setValue(ENTRY_UNIFIEDSOCIALCODE, this.getModel().getValue("unifiedsocialcode"), focusRow3);
                    this.getModel().setValue(ENTRY_STATUS, this.getModel().getValue("status"), focusRow3);
                }
            }
            Boolean istaxpayer = (Boolean)this.getModel().getValue("istaxpayer");
            Boolean isvirtual = (Boolean)this.getModel().getValue("isvirtual");
            if (istaxpayer.booleanValue() && isvirtual.booleanValue()) {
                args.setCancel(true);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7eb3\u7a0e\u4e3b\u4f53\u4e0d\u80fd\u662f\u865a\u4f53\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"TaxorgPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), org.getString("number")));
                return;
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deleteentry")) {
            int[] selectRows;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)"1", (CharSequence)this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getString(ENTRY_TAXPAYERDETAIL))) continue;
                args.setCancel(true);
                String info = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5df2\u7ef4\u62a4\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxorgPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[]{selectRow + 1});
                this.getView().showErrorNotification(info);
                return;
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"entry_enable")) {
            this.disAndEnableStatus(args, "1");
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"entry_disable")) {
            this.disAndEnableStatus(args, "0");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"entry_enable") || StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"entry_disable")) {
            String extendParam = ((Donothing)afterDoOperationEventArgs.getSource()).getOption().getVariableValue("extendParam");
            JSONObject jsonObject = JSONObject.parseObject((String)extendParam);
            String status = jsonObject.getString("status");
            Integer selectRows = jsonObject.getInteger("selectRows");
            JSONArray successEntryPkIdList = jsonObject.getJSONArray("entryId");
            if (selectRows.intValue() == successEntryPkIdList.size() && selectRows != 0) {
                this.getView().showSuccessNotification(StringUtil.equalsIgnoreCase((CharSequence)status, (CharSequence)"1") ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"TaxorgPlugin_29", (String)"bamp-bastax-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TaxorgPlugin_30", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            }
            this.disableTaxationSys();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"newentry")) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            IntStream.range(0, collection.size()).forEach(focusRow -> {
                DynamicObject org;
                DynamicObject focusRowObject = (DynamicObject)collection.get(focusRow);
                boolean istaxpayer = focusRowObject.getBoolean(ENTRY_ISTAXPAYER);
                if (istaxpayer && StringUtil.isEmpty((CharSequence)focusRowObject.getString(ENTRY_TAXPAYER)) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
                    this.getModel().setValue(ENTRY_TAXPAYER, (Object)org.getString("name"), focusRow);
                }
            });
        }
    }

    private void disAndEnableStatus(BeforeDoOperationEventArgs args, String status) {
        FormOperate source = (FormOperate)args.getSource();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (ObjectUtils.isEmpty((Object)selectRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaxorgPlugin_15", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        ArrayList<Integer> failList = new ArrayList<Integer>();
        ArrayList<Long> successEntryPkIdList = new ArrayList<Long>();
        for (int selectRow : selectRows) {
            if (StringUtil.equalsIgnoreCase((CharSequence)status, (CharSequence)"1") && this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getBoolean(ENTRY_STATUS)) {
                failList.add(selectRow + 1);
                continue;
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)status, (CharSequence)"0") && !this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getBoolean(ENTRY_STATUS)) {
                failList.add(selectRow + 1);
                continue;
            }
            this.getModel().setValue(ENTRY_STATUS, (Object)status, selectRow);
            successEntryPkIdList.add(this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow).getLong("id"));
        }
        if (!ObjectUtils.isEmpty(failList)) {
            if ("1".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\u3002", (String)"TaxorgPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[]{StringUtil.join(failList, (String)",")}));
            } else if ("0".equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"TaxorgPlugin_7", (String)"bamp-bastax-formplugin", (Object[])new Object[]{StringUtil.join(failList, (String)",")}));
            }
        }
        if (ObjectUtils.isEmpty(successEntryPkIdList)) {
            args.setCancel(true);
            return;
        }
        JSONObject extendJsonObject = new JSONObject();
        extendJsonObject.put("status", (Object)status);
        extendJsonObject.put("entryId", successEntryPkIdList);
        extendJsonObject.put("selectRows", (Object)selectRows.length);
        source.getOption().setVariableValue("extendParam", JSONObject.toJSONString((Object)extendJsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
    }

    public void beforeImportData(BeforeImportDataEventArgs args) {
        Map sourceData = args.getSourceData();
        JSONObject org = (JSONObject)sourceData.get("org");
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId()) && !sourceData.containsKey(ENTRYENTITY)) {
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u6a21\u677f\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6a21\u677f\u201c\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5bfc\u5165\u6a21\u677f\uff08\u542f\u7528\u6d77\u5916\u7a0e\uff09\u201d\u3002", (String)"TaxorgPlugin_31", (String)"bamp-bastax-formplugin", (Object[])new Object[0])));
            args.setCancel(true);
            return;
        }
        if (!SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId()) && sourceData.containsKey(ENTRYENTITY)) {
            args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6a21\u677f\uff1a\u201c\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u5bfc\u5165\u6a21\u677f\u201d\u3002", (String)"TaxorgPlugin_9", (String)"bamp-bastax-formplugin", (Object[])new Object[0])));
            args.setCancel(true);
            return;
        }
        if (sourceData.containsKey(ENTRYENTITY)) {
            TextEdit unifiedsocialcode = (TextEdit)this.getControl("unifiedsocialcode");
            unifiedsocialcode.setMustInput(false);
            Object id = sourceData.get("id");
            sourceData.put("isvirtual", Boolean.FALSE);
            JSONArray entityArray = (JSONArray)sourceData.get(ENTRYENTITY);
            if (!ObjectUtils.isEmpty((Object)entityArray)) {
                DynamicObjectCollection collection;
                QFilter idQ = new QFilter("id", "=", id);
                QFilter numberQ = new QFilter("entry_taxationsys.number", "=", (Object)"001");
                DynamicObject object = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"entryentity,entryentity.id as pkid", (QFilter[])new QFilter[]{idQ, numberQ});
                String cnPkId = "";
                if (!ObjectUtils.isEmpty((Object)object)) {
                    cnPkId = object.getString("pkid");
                }
                ArrayList<String> taxationSysNumberList = new ArrayList<String>();
                ArrayList<String> taxationSysExpdateList = new ArrayList<String>();
                List<Object> taxationSysNoExistList = new ArrayList();
                ArrayList<String> taxationSysDisableList = new ArrayList<String>();
                ArrayList taxTypeNumberList = new ArrayList();
                ArrayList<String> taxTypeExpdateList = new ArrayList<String>();
                ArrayList<String> taxTypeDisableList = new ArrayList<String>();
                List<Object> taxTypeNoExistList = new ArrayList();
                HashMap<String, String> map = new HashMap<String, String>();
                for (int i = 0; i < entityArray.size(); ++i) {
                    JSONObject row2 = (JSONObject)entityArray.get(i);
                    JSONObject taxationSysObject = row2.getJSONObject(ENTRY_TAXATIONSYS);
                    JSONObject taxTypeObject = row2.getJSONObject(ENTRY_APPLYTAXTYPE);
                    if (null != taxationSysObject) {
                        taxationSysNumberList.add(taxationSysObject.getString("number"));
                    }
                    if (null == taxTypeObject) continue;
                    String numbers = taxTypeObject.getString("number");
                    String[] num = numbers.split(",");
                    Arrays.stream(num).forEach(value -> taxTypeNumberList.add(value));
                }
                if (!ObjectUtils.isEmpty(taxationSysNumberList)) {
                    QFilter taxNumberQ = new QFilter("number", "in", taxationSysNumberList);
                    collection = QueryServiceHelper.query((String)"bd_taxationsys", (String)"number,expdate,activedate,enable", (QFilter[])new QFilter[]{taxNumberQ});
                    for (JSONObject row3 : collection) {
                        if (!StringUtil.equalsIgnoreCase((CharSequence)row3.getString("enable"), (CharSequence)"1")) {
                            taxationSysDisableList.add(row3.getString("number"));
                            continue;
                        }
                        if (DateUtils.isEffectiveDate((Date)new Date(), (Date)row3.getDate("activedate"), (Date)row3.getDate("expdate"))) continue;
                        taxationSysExpdateList.add(row3.getString("number"));
                    }
                    taxationSysNoExistList = collection.stream().filter(row -> !taxationSysNumberList.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
                }
                if (!ObjectUtils.isEmpty(taxTypeNumberList)) {
                    QFilter taxNumberQ = new QFilter("number", "in", taxTypeNumberList);
                    collection = QueryServiceHelper.query((String)"bd_taxcategory", (String)"number,taxationsysid.number,activedate,expdate,enable", (QFilter[])new QFilter[]{taxNumberQ});
                    for (JSONObject row3 : collection) {
                        if (!StringUtil.equalsIgnoreCase((CharSequence)row3.getString("enable"), (CharSequence)"1")) {
                            taxTypeDisableList.add(row3.getString("number"));
                            continue;
                        }
                        if (!DateUtils.isEffectiveDate((Date)new Date(), (Date)row3.getDate("activedate"), (Date)row3.getDate("expdate"))) {
                            taxTypeExpdateList.add(row3.getString("number"));
                            continue;
                        }
                        map.put(row3.getString("number"), row3.getString("taxationsysid.number"));
                    }
                    taxTypeNoExistList = collection.stream().filter(row -> !taxTypeNumberList.contains(row.getString("number"))).map(o -> o.getString("number")).collect(Collectors.toList());
                }
                int chnTotal = 0;
                for (int i = 0; i < entityArray.size(); ++i) {
                    JSONObject row3;
                    ArrayList<String> errorMsg = new ArrayList<String>();
                    row3 = (JSONObject)entityArray.get(i);
                    JSONObject taxationSysObject = row3.getJSONObject(ENTRY_TAXATIONSYS);
                    JSONObject taxTypeObject = row3.getJSONObject(ENTRY_APPLYTAXTYPE);
                    if (row3.getBoolean(ENTRY_ISTAXPAYER).booleanValue()) {
                        if (StringUtil.isEmpty((CharSequence)row3.getString(ENTRY_TAXPAYER))) {
                            errorMsg.add(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxorgPlugin_16", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                        }
                        if (StringUtil.isEmpty((CharSequence)row3.getString(ENTRY_UNIFIEDSOCIALCODE))) {
                            errorMsg.add(ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxorgPlugin_17", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                        }
                    }
                    String taxationSys = null;
                    if (null != taxationSysObject) {
                        taxationSys = taxationSysObject.getString("number");
                        if (StringUtil.equalsIgnoreCase((CharSequence)taxationSys, (CharSequence)"001")) {
                            ++chnTotal;
                            if (StringUtil.isNotEmpty((CharSequence)cnPkId) && StringUtil.isEmpty((CharSequence)row3.getString("id"))) {
                                ++chnTotal;
                            }
                            sourceData.put("isvirtual", row3.getBoolean(ENTRY_ISTAXPAYER) != false ? Boolean.FALSE : Boolean.TRUE);
                            sourceData.put("istaxpayer", row3.get((Object)ENTRY_ISTAXPAYER));
                            sourceData.put("taxpayer", row3.get((Object)ENTRY_TAXPAYER));
                            sourceData.put("unifiedsocialcode", row3.get((Object)ENTRY_UNIFIEDSOCIALCODE));
                            TextEdit taxpayer1 = (TextEdit)this.getControl("taxpayer");
                            TextEdit unifiedsocialcode1 = (TextEdit)this.getControl("unifiedsocialcode");
                            taxpayer1.setMustInput(false);
                            unifiedsocialcode1.setMustInput(false);
                            if (chnTotal > 1) {
                                errorMsg.add(ResManager.loadKDString((String)"\u53ea\u80fd\u5b58\u5728\u4e00\u6761\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u7684\u7a0e\u53f7\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u3002", (String)"TaxorgPlugin_10", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                            }
                        }
                        if (taxationSysExpdateList.contains(taxationSysObject.getString("number"))) {
                            errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u201c%1$s\u201d\u5df2\u5931\u6548\u3002", (String)"TaxorgPlugin_18", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxationSysObject.getString("number")));
                        }
                        if (taxationSysDisableList.contains(taxationSysObject.getString("number"))) {
                            errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u201c%1$s\u201d\u672a\u542f\u7528\u3002", (String)"TaxorgPlugin_24", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxationSysObject.getString("number")));
                        }
                        if (taxationSysNoExistList.contains(taxationSysObject.getString("number"))) {
                            errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"TaxorgPlugin_25", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxationSysObject.getString("number")));
                        }
                    }
                    if (null != taxTypeObject) {
                        String[] num;
                        String numbers = taxTypeObject.getString("number");
                        for (String value2 : num = numbers.split(",")) {
                            if (taxTypeExpdateList.contains(value2)) {
                                errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u201c%1$s\u201d\u5df2\u5931\u6548\u3002", (String)"TaxorgPlugin_19", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxTypeObject.getString("number")));
                                continue;
                            }
                            if (taxTypeDisableList.contains(value2)) {
                                errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u201c%1$s\u201d\u672a\u542f\u7528\u3002", (String)"TaxorgPlugin_22", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxTypeObject.getString("number")));
                                continue;
                            }
                            if (taxTypeNoExistList.contains(value2)) {
                                errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxorgPlugin_23", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxTypeObject.getString("number")));
                                continue;
                            }
                            if (!StringUtil.isNotEmpty((CharSequence)taxationSys) || ObjectUtils.isEmpty(map) || StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)map.get(value2)), (CharSequence)taxationSys)) continue;
                            errorMsg.add(String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u7a0e\u79cd\u201c%2$s\u201d\u3002", (String)"TaxorgPlugin_20", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), taxationSys, value2));
                        }
                    }
                    if (ObjectUtils.isEmpty(errorMsg)) continue;
                    args.setCancelMessages(Integer.valueOf(i), Integer.valueOf(0), errorMsg);
                    args.setCancel(true);
                }
            } else {
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u7a0e\u53f7\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxorgPlugin_21", (String)"bamp-bastax-formplugin", (Object[])new Object[0])));
                args.setCancel(true);
            }
        } else {
            Boolean istaxpayer = (Boolean)sourceData.get("istaxpayer");
            Boolean isvirtual = (Boolean)sourceData.get("isvirtual");
            if (istaxpayer.booleanValue() && isvirtual != null && isvirtual.booleanValue()) {
                args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7eb3\u7a0e\u4e3b\u4f53\u4e0d\u80fd\u662f\u865a\u4f53\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"TaxorgPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), org.getString("number"))));
                args.setCancel(true);
            }
            String orgNum = org.getString("number");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"unifiedsocialcode,licensestatus,cmborgtype.fnumber", (QFilter[])new QFilter[]{new QFilter("org.number", "=", (Object)orgNum)});
            JSONObject cmborgtype = (JSONObject)sourceData.get("cmborgtype");
            if (load != null && load.length > 0) {
                DynamicObject taxorg = load[0];
                if (cmborgtype != null) {
                    String cmborgtypeNumber = taxorg.getString("cmborgtype.fnumber");
                    String cmborgtypeNum = cmborgtype.getString("fnumber");
                    if (cmborgtypeNum != null && !cmborgtypeNum.equals(cmborgtypeNumber)) {
                        args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6765\u6e90\u804c\u80fd\u7c7b\u578b\u4e0d\u53ef\u4fee\u6539", (String)"TaxorgPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), org.getString("number"))));
                        args.setCancel(true);
                    }
                }
                String licensestatus = taxorg.getString("licensestatus");
                String inDb = taxorg.getString("unifiedsocialcode");
                String unifiedsocialcode = (String)sourceData.get("unifiedsocialcode");
                if ((StringUtils.equals((CharSequence)"B", (CharSequence)licensestatus) || StringUtils.equals((CharSequence)"C", (CharSequence)licensestatus)) && !StringUtils.equals((CharSequence)inDb, (CharSequence)unifiedsocialcode)) {
                    args.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), Collections.singletonList(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6388\u6743\u7684\u7a0e\u52a1\u7ec4\u7ec7\u624d\u53ef\u4ee5\u4fee\u6539\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (String)"TaxorgPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0])));
                    args.setCancel(true);
                }
            }
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int focusRow = 0; focusRow < collection.size(); ++focusRow) {
                DynamicObject row4 = (DynamicObject)collection.get(focusRow);
                if (!OrgConstant.CHN_TAXATIONSYS.equals(row4.getLong("entry_taxationsys.id"))) continue;
                this.getModel().setValue(ENTRY_TAXPAYER, sourceData.get("taxpayer"), focusRow);
                this.getModel().setValue(ENTRY_ISTAXPAYER, sourceData.get("istaxpayer"), focusRow);
                this.getModel().setValue(ENTRY_UNIFIEDSOCIALCODE, sourceData.get("unifiedsocialcode"), focusRow);
            }
        }
    }

    private boolean isEntityByOrg(DynamicObject orgObj) {
        if (null == orgObj) {
            return false;
        }
        DynamicObject pattern = orgObj.getDynamicObject("orgpattern");
        if (null != pattern) {
            String name = pattern.getString("patterntype");
            return name.equals("1") || name.equals("2");
        }
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ENTRY_TAXATIONSYS)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            List existsIds = collection.stream().filter(o -> null != o.get(ENTRY_TAXATIONSYS)).map(o -> o.getDynamicObject(ENTRY_TAXATIONSYS).getLong("id")).collect(Collectors.toList());
            if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId()) && existsIds.contains(OrgConstant.CHN_TAXATIONSYS)) {
                QFilter numberQ = new QFilter("id", "!=", (Object)OrgConstant.CHN_TAXATIONSYS);
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                Date currentDate = new Date();
                QFilter nullQ = QFilter.isNull((String)"expdate").and("activedate", "<=", (Object)currentDate);
                QFilter dateQ = new QFilter("expdate", ">=", (Object)currentDate).and(new QFilter("activedate", "<=", (Object)currentDate));
                QFilter notNullQ = QFilter.isNotNull((String)"expdate").and(dateQ);
                QFilter lastDateQ = nullQ.or(notNullQ);
                listShowParameter.getListFilterParameter().setFilter(numberQ);
                listShowParameter.getListFilterParameter().setFilter(lastDateQ);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ENTRY_APPLYTAXTYPE)) {
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            Object taxationSys = this.getModel().getValue(ENTRY_TAXATIONSYS, focusRow);
            if (null == taxationSys) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxorgPlugin_11", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Date currentDate = new Date();
            QFilter nullQ = QFilter.isNull((String)"expdate").and("activedate", "<=", (Object)currentDate);
            QFilter dateQ = new QFilter("expdate", ">=", (Object)currentDate).and(new QFilter("activedate", "<=", (Object)currentDate));
            QFilter notNullQ = QFilter.isNotNull((String)"expdate").and(dateQ);
            QFilter lastDateQ = nullQ.or(notNullQ);
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("taxationsysid", "=", ((DynamicObject)taxationSys).getPkValue()));
            beforeF7SelectEvent.getCustomQFilters().add(lastDateQ);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ENTRY_TAXAREA)) {
            DynamicObject[] colls;
            Long countryId;
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            Object taxationSys = this.getModel().getValue(ENTRY_TAXATIONSYS, focusRow);
            if (null == taxationSys) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxorgPlugin_11", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List areaGroupIds = null;
            if (taxationSys != null && ((DynamicObject)taxationSys).getDynamicObject("countryid") != null && (countryId = Long.valueOf(((DynamicObject)taxationSys).getDynamicObject("countryid").getLong("id"))) != null && countryId != 0L && (colls = TaxcAreaBusiness.loadTaxcAreaByCountryId((Long)countryId)) != null) {
                areaGroupIds = Stream.of(colls).map(o -> o.getLong("group.id")).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(areaGroupIds)) {
                QFilter idQFilter = new QFilter("id", "in", areaGroupIds);
                beforeF7SelectEvent.getCustomQFilters().add(idQFilter);
            } else {
                beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "=", (Object)-1));
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        if (afterF7SelectEvent.getSource() instanceof BasedataEdit && StringUtil.equalsIgnoreCase((CharSequence)((BasedataEdit)afterF7SelectEvent.getSource()).getFieldKey(), (CharSequence)ENTRY_TAXATIONSYS)) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < collection.size(); ++i) {
                QFilter orgIdFilter;
                DynamicObject dynamicObject;
                DynamicObject object = (DynamicObject)collection.get(i);
                if (!OrgConstant.CHN_TAXATIONSYS.equals(object.getLong("entry_taxationsys.id")) || !StringUtil.isEmpty((CharSequence)object.getString(ENTRY_UNIFIEDSOCIALCODE)) || null == (dynamicObject = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,uniformsocialcreditcode", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("org.id"))}))) continue;
                this.getModel().setValue(ENTRY_UNIFIEDSOCIALCODE, (Object)dynamicObject.getString("uniformsocialcreditcode"), i);
            }
        }
    }

    private void visibleFlex() {
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexinfo", "flexinfo1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexinfo", "flexinfo1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
        }
    }

    private void disableTaxationSys() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
        IntStream.range(0, collection.size()).forEach(focusRow -> {
            DynamicObject focusRowObject = (DynamicObject)collection.get(focusRow);
            if (StringUtil.equalsIgnoreCase((CharSequence)"1", (CharSequence)focusRowObject.getString(ENTRY_TAXPAYERDETAIL))) {
                this.getView().setEnable(Boolean.valueOf(false), focusRow, new String[]{ENTRY_TAXATIONSYS});
            }
        });
    }

    private boolean validateFail() {
        boolean isFail = false;
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int num = 0; num < collection.size(); ++num) {
                DynamicObject row = (DynamicObject)collection.get(num);
                boolean entryIstaxpayer = row.getBoolean(ENTRY_ISTAXPAYER);
                String entryTaxpayer = row.getString(ENTRY_TAXPAYER);
                if (entryIstaxpayer && StringUtil.isEmpty((CharSequence)entryTaxpayer)) {
                    String info = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7eb3\u7a0e\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxorgPlugin_12", (String)"bamp-bastax-formplugin", (Object[])new Object[]{num + 1});
                    this.getView().showErrorNotification(info);
                    return true;
                }
                String entryUnifiedsocialcode = row.getString(ENTRY_UNIFIEDSOCIALCODE);
                if (!entryIstaxpayer || !StringUtil.isEmpty((CharSequence)entryUnifiedsocialcode)) continue;
                String info = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxorgPlugin_13", (String)"bamp-bastax-formplugin", (Object[])new Object[]{num + 1});
                this.getView().showErrorNotification(info);
                return true;
            }
        } else {
            ((EntryGrid)this.getControl(ENTRYENTITY)).setMustInput("ENTRYENTITY", false);
            ((BasedataEdit)this.getControl(ENTRY_TAXATIONSYS)).setMustInput(false);
        }
        return isFail;
    }
}

