/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bamp.bastax.formplugin.common.AbstractTreePlugin;
import kd.bamp.bastax.formplugin.taxview.OrgViewCustomPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.org.model.OrgApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class OrgViewMainPlugin
extends AbstractTreePlugin {
    public static final String SYSCDATA = "syscdata";
    private static Log logger = LogFactory.getLog(OrgViewMainPlugin.class);
    private static final String TREE_NAME = "left_treeviewap";
    private static final String BUTTON_NEW = "button_new";
    private static final String BUTTON_SAVE = "button_save";
    private static final String BUTTON_DELETE = "button_delete";
    private static final String TARGETKEY = "viewpanel";
    private static final String BUTTON_REFRESH = "button_refresh";
    public static final String PARAM_VIEWID = "viewid";
    private static final String CALLBACK_CLOSE4DATACHANGE = "close4datachange";
    private static final String CALLBACK_TREENODECLICK4DATACHANGE = "treenodeclick4datachange";
    public static final String TCTB_ORG_DEFAULT_VIEW = "tctb_org_default_view";
    public static final String TCTB_ORG_VIEW_CUSTOM = "tctb_org_view_custom";
    public static final String ISDEFAULT = "isdefault";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    private static final String OP_MUTEX = "manual_mutex";
    private static final String PARAM_LOCK = "lockflag";
    private static final String CACHE_MUTEXID = "mutex_id";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        TreeView rightTreeView = (TreeView)this.getView().getControl(TREE_NAME);
        rightTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadTree();
        this.requirNetLock(this.getCurrentNodeId());
    }

    public void itemClick(ItemClickEvent evt) {
    }

    private void newClick() {
        BillShowParameter billShowParameter = new BillShowParameter();
        HashMap<String, Boolean> customParams = new HashMap<String, Boolean>(8);
        customParams.put("isAdd", Boolean.TRUE);
        billShowParameter.setCustomParams(customParams);
        billShowParameter.setFormId(TCTB_ORG_VIEW_CUSTOM);
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.getOpenStyle().setTargetKey(TARGETKEY);
        this.getPageCache().put(BUTTON_SAVE, billShowParameter.getPageId());
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private boolean hasNewPerm() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"basedata", (String)"tctb_org_view_main", (String)"47156aff000000ac");
    }

    private boolean hasUpdatePerm() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"basedata", (String)"tctb_org_view_main", (String)"4715a0df000000ac");
    }

    private boolean isNewView() {
        String pageId = this.getPageCache().get(BUTTON_SAVE);
        IFormView childView = this.getView().getView(pageId);
        if (childView == null) {
            return false;
        }
        Object o = childView.getFormShowParameter().getCustomParam("isAdd");
        if (o == null) {
            return false;
        }
        return (Boolean)o;
    }

    private void saveClick() {
        if (this.isNewView()) {
            this.newSave();
        } else {
            this.updateSave();
        }
    }

    private void newSave() {
        if (!this.hasNewPerm()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgViewMainPlugin_15", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        this.saveData();
    }

    private void updateSave() {
        if (!this.hasUpdatePerm()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"OrgViewMainPlugin_16", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.requirNetLock(this.getCurrentNodeId())) {
            return;
        }
        this.saveData();
    }

    private void saveData() {
        String viewId;
        String pageId = this.getPageCache().get(BUTTON_SAVE);
        IFormView childView = this.getView().getView(pageId);
        if (childView == null) {
            return;
        }
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        List pluginList = pluginProxy.getPlugIns();
        OrgViewCustomPlugin orgViewCustomPlugin = null;
        for (IFormPlugin plugin : pluginList) {
            if (!(plugin instanceof OrgViewCustomPlugin)) continue;
            orgViewCustomPlugin = (OrgViewCustomPlugin)plugin;
            break;
        }
        if (orgViewCustomPlugin != null) {
            orgViewCustomPlugin.save(this.getView());
        }
        if (!StringUtils.isEmpty((CharSequence)(viewId = this.getPageCache().get(PARAM_VIEWID)))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OrgViewMainPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.loadTree(this.getCurrentNodeId());
            this.getPageCache().remove(PARAM_VIEWID);
        }
    }

    private void delClick() {
        if (!this.requirNetLock(this.getCurrentNodeId())) {
            return;
        }
        logger.info("\u3010OrgViewMainPlugin\u3011\u5f00\u59cb\u6267\u884c\u5220\u9664\u3002\u3002\u3002");
        long start = System.currentTimeMillis();
        String viewId = this.getPageCache().get(BUTTON_DELETE);
        boolean isDefault = Boolean.parseBoolean(this.getPageCache().get(ISDEFAULT));
        if (isDefault) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u9ed8\u8ba4\u65b9\u6848\u4e0d\u80fd\u5220\u9664\u3002", (String)"OrgViewMainPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        this.comfirmDeleteTips(BUTTON_DELETE, viewId);
        logger.info("\u3010OrgViewMainPlugin\u3011\u7ed3\u675f\u6267\u884c\u5220\u9664\uff0c\u603b\u8017\u65f6:" + (System.currentTimeMillis() - start));
    }

    private void comfirmDeleteTips(String buttonDelete, String viewId) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(buttonDelete, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"OrgViewMainPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u5b9a", (String)"OrgViewMainPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"OrgViewMainPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps, viewId);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (BUTTON_DELETE.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) return;
            ArrayList<Long> ids = new ArrayList<Long>();
            String viewId = messageBoxClosedEvent.getCustomVaule();
            ids.add(Long.parseLong(viewId));
            OrgApiResult result = OrgUnitServiceHelper.deleteOrgViewSchema(ids);
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OrgViewMainPlugin_17", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)TCTB_ORG_VIEW_CUSTOM);
                DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])new String[]{viewId});
                this.loadTree();
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)result.getErrorMsg(), (String)"OrgViewMainPlugin_12", (String)"OrgViewMainPlugin_5", (Object[])new Object[0]));
            return;
        }
        if (CALLBACK_TREENODECLICK4DATACHANGE.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) return;
            String pageId = this.getPageCache().get(BUTTON_SAVE);
            IFormView childView = this.getView().getView(pageId);
            if (childView == null) {
                return;
            }
            childView.getModel().setDataChanged(false);
            childView.getPageCache().remove("dataChange");
            TreeView treeView = (TreeView)this.getControl(TREE_NAME);
            treeView.treeNodeClick("-1", treeView.getTreeState().getFocusNodeId());
            return;
        }
        if (!CALLBACK_CLOSE4DATACHANGE.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) return;
        if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) return;
        String pageId = this.getPageCache().get(BUTTON_SAVE);
        IFormView childView = this.getView().getView(pageId);
        if (childView == null) {
            return;
        }
        childView.getModel().setDataChanged(false);
        childView.getPageCache().remove("dataChange");
        this.getView().close();
    }

    private void loadTree() {
        this.loadTree(null);
    }

    private void loadTree(String selectNodeId) {
        logger.info("\u3010OrgViewMainPlugin\u3011\u5f00\u59cb\u52a0\u8f7d\u6811\u3002\u3002\u3002");
        long start = System.currentTimeMillis();
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        treeView.deleteAllNodes();
        String fields = "id,number,name,isdefault";
        QFilter filter = new QFilter(ISDEFAULT, "=", (Object)"0");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TCTB_ORG_VIEW_CUSTOM, (String)fields, (QFilter[])filters, (String)"isdefault desc");
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        TreeNode rootNode = new TreeNode();
        rootNode.setParentid("");
        rootNode.setId("-1");
        rootNode.setText(ResManager.loadKDString((String)"\u89c6\u56fe\u65b9\u6848", (String)"OrgViewMainPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        rootNode.setType("");
        rootNode.setIsOpened(true);
        nodeList.add(rootNode);
        TreeNode selectNode = null;
        if (!CollectionUtils.isEmpty((Collection)collection)) {
            for (DynamicObject obj : collection) {
                TreeNode leftRoot = new TreeNode();
                String id = obj.getString("id");
                String name = obj.getString("name");
                String number = obj.getString("number");
                leftRoot.setParentid(rootNode.getId());
                leftRoot.setId(id);
                leftRoot.setText(name);
                leftRoot.setType(number);
                nodeList.add(leftRoot);
                if (!id.equals(selectNodeId)) continue;
                selectNode = leftRoot;
            }
        }
        if (selectNode == null && nodeList.size() > 1) {
            selectNode = (TreeNode)nodeList.get(1);
        }
        if (selectNode == null) {
            selectNode = rootNode;
        }
        treeView.addNodes(nodeList);
        treeView.checkNode(selectNode);
        treeView.focusNode(selectNode);
        treeView.treeNodeClick("-1", selectNode.getId());
        logger.info("\u3010OrgViewMainPlugin\u3011\u7ed3\u675f\u52a0\u8f7d\u6811\uff0c\u603b\u8017\u65f6:" + (System.currentTimeMillis() - start));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isDataChange()) {
            this.confirmDataChange(CALLBACK_CLOSE4DATACHANGE);
            e.setCancel(true);
        }
    }

    private boolean isDataChange() {
        String pageId = this.getPageCache().get(BUTTON_SAVE);
        if (pageId == null) {
            return false;
        }
        IFormView childView = this.getView().getView(pageId);
        if (null == childView) {
            return false;
        }
        boolean change = childView.getModel().getDataChanged();
        String dataChange = childView.getPageCache().get("dataChange");
        return change || !StringUtils.isEmpty((CharSequence)dataChange);
    }

    private void confirmDataChange(String callBackId) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"OrgViewMainPlugin_10", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"OrgViewMainPlugin_11", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"OrgViewMainPlugin_13", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    @Override
    public void treeNodeClick(TreeNodeEvent event) {
        String lastLockNodeId;
        String cureentNodeId;
        super.treeNodeClick(event);
        if (this.isDataChange()) {
            this.confirmDataChange(CALLBACK_TREENODECLICK4DATACHANGE);
            event.setCancel(true);
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        String formId = null;
        this.getPageCache().put(BUTTON_DELETE, event.getNodeId().toString());
        if (!"-1".equalsIgnoreCase(event.getNodeId().toString())) {
            formId = TCTB_ORG_VIEW_CUSTOM;
            customParams.put(PARAM_VIEWID, event.getNodeId());
            customParams.put(ISDEFAULT, Boolean.FALSE);
            this.getPageCache().put(ISDEFAULT, String.valueOf(Boolean.FALSE));
        }
        if (!(cureentNodeId = this.getCurrentNodeId()).equals(lastLockNodeId = this.getPageCache().get(CACHE_MUTEXID))) {
            this.releaseNetLock(lastLockNodeId);
        }
        if (!this.hasUpdatePerm() || !this.requirNetLock(cureentNodeId)) {
            customParams.put(PARAM_LOCK, "1");
        } else {
            this.getPageCache().put(CACHE_MUTEXID, cureentNodeId);
        }
        if (formId != null) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setCustomParams(customParams);
            billShowParameter.setFormId(formId);
            billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            billShowParameter.getOpenStyle().setTargetKey(TARGETKEY);
            billShowParameter.setPkId(event.getNodeId());
            this.getPageCache().put(BUTTON_SAVE, billShowParameter.getPageId());
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void updateStatus(boolean enable) {
        boolean isDefault;
        ArrayList<Long> viewIds = new ArrayList<Long>();
        String viewId = this.getPageCache().get(BUTTON_DELETE);
        if (!enable && (isDefault = Boolean.parseBoolean(this.getPageCache().get(ISDEFAULT)))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u9ed8\u8ba4\u65b9\u6848\u4e0d\u80fd\u7981\u7528\u3002", (String)"OrgViewMainPlugin_7", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        viewIds.add(Long.parseLong(viewId));
        String status = enable ? "1" : "0";
        OrgApiResult result = OrgUnitServiceHelper.enableOrgViewSchema(viewIds, (boolean)enable);
        if (!result.isSuccess()) {
            this.getView().showTipNotification(result.getErrorMsg());
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)TCTB_ORG_DEFAULT_VIEW);
        dynamicObject.set(ENABLE, (Object)status);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        String msg = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"OrgViewMainPlugin_8", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        if (!enable) {
            msg = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"OrgViewMainPlugin_9", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
        }
        this.getView().showSuccessNotification(msg, Integer.valueOf(2000));
        this.getPageCache().put(PARAM_VIEWID, viewId);
        this.loadTree(this.getCurrentNodeId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (BUTTON_NEW.equals(key)) {
            this.newClick();
        } else if (BUTTON_SAVE.equals(key)) {
            this.saveClick();
        } else if (BUTTON_DELETE.equals(key)) {
            this.delClick();
        } else if (ENABLE.equalsIgnoreCase(key)) {
            this.updateStatus(true);
        } else if (DISABLE.equalsIgnoreCase(key)) {
            this.updateStatus(false);
        } else if (BUTTON_REFRESH.equalsIgnoreCase(key)) {
            this.loadTree();
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseNetLock(this.getCurrentNodeId());
    }

    private String getCurrentNodeId() {
        TreeView treeView = (TreeView)this.getControl(TREE_NAME);
        return treeView.getTreeState().getFocusNodeId();
    }

    protected boolean requirNetLock(String objectId) {
        if (StringUtil.isEmpty((CharSequence)objectId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(objectId, "default_netctrl", TCTB_ORG_VIEW_CUSTOM);
        if (lockInfo != null) {
            if (!((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
                String username = this.getUserName(Long.valueOf((String)lockInfo.get("userid")));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"OrgViewMainPlugin_14", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), username));
                return false;
            }
            return true;
        }
        boolean newMutexLocked = MutexHelper.require((String)TCTB_ORG_VIEW_CUSTOM, (Object)objectId, (String)"netlock", (boolean)Boolean.FALSE, null);
        return newMutexLocked;
    }

    protected void releaseNetLock(String lockId) {
        DataMutexImpl dataMutex;
        Map lockInfo;
        if (StringUtil.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, "default_netctrl", TCTB_ORG_VIEW_CUSTOM)) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)TCTB_ORG_VIEW_CUSTOM, (String)"netlock", (String)lockId);
        }
    }

    private String getUserName(Long userId) {
        ArrayList<Long> ids = new ArrayList<Long>(2);
        ids.add(userId);
        List list = UserServiceHelper.getUserInfoByID(ids);
        if (list.size() > 0) {
            return (String)((Map)list.get(0)).get("name");
        }
        return null;
    }
}

