/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.roombase;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bamp.bastax.business.roombase.BuildingDao;
import kd.bamp.bastax.business.roombase.StageBusiness;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;

public class BuildingBusiness {
    public static TreeNode queryBuildTree(Long stageId) {
        DynamicObject stage = StageBusiness.queryStageById(stageId);
        TreeNode root = new TreeNode();
        root.setId("stage_" + stage.getString("id"));
        root.setText(stage.getString("name"));
        root.setChildren(new ArrayList());
        DynamicObject[] buildColl = BuildingBusiness.queryBuildByStageId(stageId);
        Map<Long, List<DynamicObject>> buildMap = Stream.of(buildColl).collect(Collectors.groupingBy(v -> v.getLong("stage.id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : buildMap.entrySet()) {
            List<DynamicObject> buildList = entry.getValue();
            if (buildList == null || buildList.size() <= 0) continue;
            for (DynamicObject build : buildList) {
                TreeNode buildNode = new TreeNode();
                buildNode.setId("building_" + build.getString("id"));
                buildNode.setText(build.getString("name"));
                buildNode.setData((Object)build);
                buildNode.setParentid(root.getId());
                root.getChildren().add(buildNode);
            }
        }
        return root;
    }

    public static DynamicObject queryBulidByNodeId(String nodeId) {
        if (StringUtil.isNotEmpty((CharSequence)nodeId) && !"-1".equals(nodeId)) {
            String[] params = nodeId.split("_");
            String flag = params[0];
            String billId = params[1];
            if ("build".equalsIgnoreCase(flag)) {
                DynamicObject build = BuildingBusiness.queryBuildById(Long.valueOf(billId));
                return build;
            }
        }
        return null;
    }

    public static DynamicObject[] queryBuildByIds(List<Long> ids) {
        return BuildingDao.loadBuildByIds(ids, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,stage,taxproject,taxorg");
    }

    public static DynamicObject[] queryBuildByStageId(Long stageId) {
        return BuildingDao.loadBuildByStageId(stageId, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,stage,taxproject,taxorg");
    }

    public static DynamicObject queryBuildById(Long id) {
        return BuildingDao.loadBuildById(id, "id,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,stage,taxproject,taxorg");
    }
}

