/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.taxarea;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bamp.bastax.business.taxarea.TaxcAreaDao;
import kd.bamp.bastax.business.taxarea.TaxcAreaService;
import kd.bamp.bastax.common.constant.HscodeConstant;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.StringUtils;

public class TaxcAreaBusiness {
    public static DynamicObject[] loadTaxcAreaByCountryId(Long countryId) {
        DynamicObject[] docs = TaxcAreaDao.loadTaxcAreaFromDbByCountryId(countryId);
        return TaxcAreaService.isEnableAndEffective(docs);
    }

    public static DynamicObject[] loadTaxcAreaByIds(List<Long> ids) {
        DynamicObject[] docs = TaxcAreaDao.loadTaxcAreaFromDbByIds(ids);
        return docs;
    }

    public static boolean checkGroupFieldUnique(DynamicObject obj) {
        QFilter filter = new QFilter("country.id", "=", (Object)obj.getLong("country.id")).and("group.id", "=", (Object)obj.getLong("group.id")).and("enable", "=", (Object)"1");
        filter.and(HscodeConstant.ID, "!=", (Object)obj.getLong(HscodeConstant.ID));
        DynamicObject[] objs = TaxcAreaDao.queryTaxcAreaByQfilter(filter);
        boolean isRepeat = false;
        if (objs != null && objs.length > 0) {
            for (DynamicObject o : objs) {
                if (!TaxcAreaBusiness.checkGroupFieldUnique(obj, o)) continue;
                isRepeat = true;
                break;
            }
        }
        return isRepeat;
    }

    public static boolean checkGroupFieldUnique(DynamicObject obj, DynamicObject targetObj) {
        boolean isDuplicateCountry = StringUtils.equals((CharSequence)obj.getString("country.id"), (CharSequence)targetObj.getString("country.id"));
        boolean isDuplicateGroup = StringUtils.equals((CharSequence)obj.getString("group.id"), (CharSequence)targetObj.getString("group.id"));
        boolean isOverlapTime = TaxcAreaBusiness.validationRepDate(obj, targetObj);
        return isDuplicateCountry && isDuplicateGroup && isOverlapTime;
    }

    private static boolean validationRepDate(DynamicObject obj, DynamicObject targetObj) {
        boolean isEffective = false;
        if (Objects.isNull(obj.getDate("enddate")) && Objects.isNull("enddate")) {
            isEffective = true;
        } else if (DateUtils.isEffectiveDate((Date)obj.getDate("startdate"), (Date)targetObj.getDate("startdate"), (Date)targetObj.getDate("enddate")) || DateUtils.isEffectiveDate((Date)targetObj.getDate("startdate"), (Date)obj.getDate("startdate"), (Date)obj.getDate("enddate"))) {
            isEffective = true;
        }
        return isEffective;
    }

    public static DynamicObject[] loadTaxcAreaAvailable() {
        DynamicObject[] docs = TaxcAreaDao.queryTaxcAreaByQfilter(null);
        return TaxcAreaService.isEnableAndEffective(docs);
    }
}

