/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.opplugin.taxarea;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class TaxareaImportPlugin
extends BatchImportPlugin {
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String ADMINDIVISION = "admindivision";
    private static final String FULLNAME = "fullname";

    protected void beforeSave(List<ImportBillData> datas, ImportLogger logger) {
        super.beforeSave(datas, logger);
        List admindivisionFullNames = datas.stream().filter(Objects::nonNull).map(o -> this.changeFullName(o.getData().getJSONObject(ADMINDIVISION) == null ? null : o.getData().getJSONObject(ADMINDIVISION).getString(FULLNAME))).collect(Collectors.toList());
        QFilter filter = new QFilter(FULLNAME, "in", admindivisionFullNames);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BD_ADMINDIVISION, (String)FULLNAME, (QFilter[])new QFilter[]{filter});
        List fullName = dynamicObjects.stream().map(o -> o.getString(FULLNAME)).collect(Collectors.toList());
        Iterator<ImportBillData> partList = datas.iterator();
        Type type = new TypeReference<HashMap<String, Object>>(){}.getType();
        while (partList.hasNext()) {
            ImportBillData data = partList.next();
            String admindivisionFullName = "";
            if (data.getData().getJSONObject(ADMINDIVISION) != null) {
                admindivisionFullName = data.getData().getJSONObject(ADMINDIVISION).getString(FULLNAME);
            }
            Integer index = data.getStartIndex();
            if (admindivisionFullName == null || admindivisionFullName.equalsIgnoreCase("")) continue;
            String result = this.changeFullName(admindivisionFullName);
            if (!fullName.contains(result)) {
                logger.log(index, String.format(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212%1$s\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"TaxareaImportPlugin_0", (String)"bamp-bastax-opplugin", (Object[])new Object[0]), admindivisionFullName)).fail();
                this.remove(datas, partList);
                continue;
            }
            HashMap dataMap = (HashMap)JSON.parseObject((String)JSON.toJSONString((Object)data.getData()), (Type)type, (Feature[])new Feature[0]);
            HashMap admindivisionMap = (HashMap)JSON.parseObject((String)JSON.toJSONString((Object)data.getData().getJSONObject(ADMINDIVISION)), (Type)type, (Feature[])new Feature[0]);
            admindivisionMap.put(FULLNAME, result);
            dataMap.put(ADMINDIVISION, JSON.parseObject((String)JSON.toJSONString((Object)admindivisionMap)));
            data.setData(JSON.parseObject((String)JSON.toJSONString((Object)dataMap)));
        }
    }

    private void remove(List<ImportBillData> data, Iterator<ImportBillData> partList) {
        if (ObjectUtils.isNotEmpty(data)) {
            partList.remove();
        }
    }

    private String changeFullName(String admindivisionFullName) {
        if (admindivisionFullName == null) {
            return "";
        }
        admindivisionFullName = admindivisionFullName.replace("/", "_");
        int index = admindivisionFullName.indexOf("_");
        return admindivisionFullName.substring(index + 1);
    }

    protected boolean isForceBatch() {
        return true;
    }
}

