/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.mservice.taxorg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bamp.bastax.business.taxcorg.TaxcOrgBusiness;
import kd.bamp.bastax.business.taxcorg.TaxcOrgService;
import kd.bamp.bastax.common.util.OrgUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;

public class TaxOrgLoadTaxviewService {
    private static Log logger = LogFactory.getLog(TaxOrgLoadTaxviewService.class);
    private static final String ENTRY_TAXATIONSYS = "entry_taxationsys";
    private static final String ENTRY_ISTAXPAYER = "entry_istaxpayer";
    private static final String ENTRY_TAXPAYER = "entry_taxpayer";
    private static final String ENTRY_UNIFIEDSOCIALCODE = "entry_unifiedsocialcode";
    private static final String ENTRY_STATUS = "entry_status";

    public void syncTaxOrgData() {
        ThreadPools.executeOnce((String)"syncTaxOrgData", this::saveData);
    }

    public void saveData() {
        Long orgDefaultViewSchemaId = OrgUtils.getDefaultViewSchemaInfoId();
        Map allViewOrg = OrgUtils.getAllOrgMapByView((Long)orgDefaultViewSchemaId, (QFilter)new QFilter("org.enable", "=", (Object)"1"));
        Set allViewOrgIds = allViewOrg.keySet().stream().map(Long::valueOf).collect(Collectors.toSet());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id", null);
        Stream.of(load).map(DataEntityBase::getPkValue).map(o -> (Long)o).forEach(allViewOrgIds::remove);
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(allViewOrgIds.size());
        for (Long orgId : allViewOrgIds) {
            boolean exists;
            String uniformsocialcreditcode;
            Map map = (Map)allViewOrg.get(String.valueOf(orgId));
            DynamicObject value = (DynamicObject)map.get("org");
            Long cmborgtypeId = (Long)map.get("cmborgtype");
            DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"bastax_taxorg");
            saveObj.set("id", (Object)value.getLong("masterid"));
            saveObj.set("org", (Object)value);
            saveObj.set("status", (Object)"1");
            saveObj.set("creator", (Object)RequestContext.get().getUserId());
            boolean istaxpayer = this.isEntityByOrg(value);
            if (istaxpayer) {
                saveObj.set("taxpayer", (Object)value.getString("name"));
            }
            if (StringUtils.isNotBlank((CharSequence)(uniformsocialcreditcode = (String)value.get("uniformsocialcreditcode"))) && !(exists = QueryServiceHelper.exists((String)"bastax_taxorg", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)uniformsocialcreditcode)}))) {
                saveObj.set("unifiedsocialcode", (Object)uniformsocialcreditcode);
            }
            saveObj.set("istaxpayer", (Object)istaxpayer);
            DynamicObject[] cmborgtypeObjs = BusinessDataServiceHelper.load((String)"bos_org_biz", (String)"id,fname,fnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)cmborgtypeId)});
            if (cmborgtypeObjs != null && cmborgtypeObjs.length > 0) {
                DynamicObject cmborgtypeObj = cmborgtypeObjs[0];
                saveObj.set("cmborgtype", (Object)cmborgtypeObj);
                saveObj.set("cmborgtype.fname", cmborgtypeObj.get("fname"));
            }
            DynamicObjectCollection collection = saveObj.getDynamicObjectCollection("entryentity");
            DynamicObject newRow = collection.addNew();
            newRow.set(ENTRY_TAXATIONSYS, (Object)1L);
            newRow.set(ENTRY_TAXPAYER, saveObj.get("taxpayer"));
            newRow.set(ENTRY_ISTAXPAYER, saveObj.get("istaxpayer"));
            newRow.set(ENTRY_UNIFIEDSOCIALCODE, saveObj.get("unifiedsocialcode"));
            newRow.set(ENTRY_STATUS, (Object)"1");
            DynamicObjectCollection areaDyns = newRow.getDynamicObjectCollection("entry_taxarea");
            DynamicObject area = areaDyns.addNew();
            area.set("fbasedataid_id", (Object)1708040530098667520L);
            saveDatas.add(saveObj);
        }
        if (TaxcOrgBusiness.saveData(saveDatas, allViewOrgIds)) {
            TaxcOrgService.removeTaxOrgEntryCache((DynamicObject[])saveDatas.toArray(new DynamicObject[saveDatas.size()]));
        }
    }

    private void fireTaxOrgSyncEvent(Set<Long> orgIds) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ids", orgIds);
            params.put("appId", "bastax");
            EventServiceHelper.triggerEventSubscribe((String)"bastax_taxorg.sync", (String)JSONUtils.toString(params));
        }
        catch (Exception e) {
            logger.error("\u3010TaxOrgLoadTaxviewService\u3011bastax_taxorg.sync\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isEntityByOrg(DynamicObject orgObj) {
        if (null == orgObj) {
            return false;
        }
        DynamicObject pattern = orgObj.getDynamicObject("orgpattern");
        if (null != pattern) {
            String name = pattern.getString("patterntype");
            return name.equals("1") || name.equals("2");
        }
        return false;
    }
}

