/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.mservice.taxorg;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.util.DBUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class TaxOrgSyncUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxOrgSyncUpgradeService.class);
    private static int ERROR = 1;
    private static int INFO = 2;
    private String currentData = "";
    private StringBuilder logs = new StringBuilder();
    private boolean isUpdate;

    public TaxOrgSyncUpgradeService() {
        this.isUpdate = true;
    }

    public TaxOrgSyncUpgradeService(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"TaxOrgSyncUpgradeService_0", (String)"bamp-bastax-mservice", (Object[])new Object[0]);
        this.addLog(INFO, ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5f00\u59cb", (String)"TaxOrgSyncUpgradeService_1", (String)"bamp-bastax-mservice", (Object[])new Object[0]));
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = String.format(ResManager.loadKDString((String)"%1$s\n\u540c\u6b65\u5931\u8d25\n", (String)"TaxOrgSyncUpgradeService_2", (String)"bamp-bastax-mservice", (Object[])new Object[0]), this.currentData);
            info = this.currentData + "\n" + this.getStackTraceMessage(t);
            LOGGER.error(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"TaxOrgSyncUpgradeService_3", (String)"bamp-bastax-mservice", (Object[])new Object[0]), t);
        }
        this.addLog(INFO, String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u7ed3\u675f\uff0c\u8017\u65f6\uff08ms\uff09\uff1a%s", (String)"TaxOrgSyncUpgradeService_4", (String)"bamp-bastax-mservice", (Object[])new Object[0]), System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List viewOrgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
        String tctbTaxMainQuerySql = "select forgid,ftaxpayer,funifiedsocialcode,fisentity,fstatus from t_tctb_tax_main";
        List mainList = DBUtils.query((String)tctbTaxMainQuerySql);
        String taxorgQuerySql = "select fid from t_bastax_taxorg";
        Set taxorgIds = (Set)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)taxorgQuerySql, resultSet -> {
            HashSet<Long> ids = new HashSet<Long>(1024);
            while (resultSet.next()) {
                ids.add(resultSet.getLong("fid"));
            }
            return ids;
        });
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(mainList.size());
        HashSet<Long> taxMainOrgIds = new HashSet<Long>();
        if (mainList != null && mainList.size() > 0) {
            for (Map mainMap : mainList) {
                String fisvirtual;
                Object forgidObj = mainMap.get("FORGID");
                Long forgid = null;
                if (forgidObj instanceof Long) {
                    forgid = (Long)forgidObj;
                } else if (forgidObj instanceof BigDecimal) {
                    forgid = ((BigDecimal)forgidObj).longValue();
                }
                taxMainOrgIds.add(forgid);
                if (forgid == null) continue;
                String ftaxpayer = mainMap.getOrDefault("FTAXPAYER", "");
                String funifiedsocialcode = mainMap.getOrDefault("FUNIFIEDSOCIALCODE", "");
                String fisentity = mainMap.getOrDefault("FISENTITY", "1");
                fisentity = StringUtils.isBlank((CharSequence)fisentity) ? "1" : fisentity;
                String fstatus = mainMap.getOrDefault("FSTATUS", "2");
                fstatus = "2".equalsIgnoreCase(fstatus) ? "1" : "0";
                String string = fisvirtual = "0".equalsIgnoreCase(fisentity) ? "1" : "0";
                if (!taxorgIds.add(forgid)) continue;
                insertList.add(new Object[]{forgid, forgid, ftaxpayer, fisentity, funifiedsocialcode, 40L, fstatus, fisvirtual, "1"});
            }
        }
        this.dealNoInTaxMainOrgAndUpdateAllOrg(viewOrgIds, taxMainOrgIds, taxorgIds, insertList);
        this.updateLicenseStatus();
    }

    private void dealNoInTaxMainOrgAndUpdateAllOrg(List<Long> viewOrgIds, Set<Long> taxMainOrgIds, Set<Long> taxorgIds, List<Object[]> insertList) {
        List noInMainOrgIds;
        List lastNoInMainOrgIds;
        DynamicObject[] orgObj;
        if (null != viewOrgIds && null != (orgObj = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,name,orgpattern,uniformsocialcreditcode", (QFilter[])new QFilter[]{new QFilter("id", "in", lastNoInMainOrgIds = (noInMainOrgIds = viewOrgIds.stream().filter(o -> !taxMainOrgIds.contains(o)).collect(Collectors.toList())).stream().filter(o -> !taxorgIds.contains(o)).collect(Collectors.toList()))})) && orgObj.length > 0) {
            Arrays.stream(orgObj).forEach(o -> {
                String name;
                Long forgid = o.getLong("id");
                DynamicObject pattern = o.getDynamicObject("orgpattern");
                String fstatus = "1";
                String ftaxpayer = "";
                String fisentity = "0";
                String fisvirtual = "1";
                String funifiedsocialcode = "";
                if (null != pattern && ((name = pattern.getString("patterntype")).equals("1") || name.equals("2"))) {
                    ftaxpayer = o.getString("name");
                    fisentity = "1";
                    fisvirtual = "0";
                    funifiedsocialcode = o.getString("uniformsocialcreditcode");
                }
                insertList.add(new Object[]{forgid, forgid, ftaxpayer, fisentity, funifiedsocialcode, 40L, fstatus, fisvirtual, "1"});
            });
        }
        if (insertList.size() > 0) {
            String taxorgInsertSql = "INSERT INTO t_bastax_taxorg( fid, forgid, ftaxpayer, fistaxpayer, funifiedsocialcode, fcmborgtype, fstatus, fisvirtual, ftaxpayerdetail) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            DBUtils.executeBatch((String)"sys", (String)taxorgInsertSql, insertList);
        }
    }

    /*
     * Exception decompiling
     */
    private void updateLicenseStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addLog(int level, String info) {
        if (ERROR == level) {
            LOGGER.error("TaxOrgSyncUpgradeService addLog", (Object)info);
        } else {
            LOGGER.info("TaxOrgSyncUpgradeService addLog", (Object)info);
        }
        this.logs.append(info);
        this.logs.append('\n');
    }

    private String getStackTraceMessage(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

