/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class TaxProjectUpgradeService
implements IUpgradeService {
    private Log LOGGER = LogFactory.getLog(TaxProjectUpgradeService.class);
    private static final String SQL_QUERY_ALL = "select fid,fsyjhjsff from t_bastax_taxproject where fyzjsqdff not in('1','2')";
    private static final String SQL_UPDATA = "update t_bastax_taxproject set fyzjsqdff = ? where fid = ?";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Map<Long, Boolean> allData = this.getAllData();
        List<Object[]> paramList = this.buildParams(allData);
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)SQL_UPDATA, paramList);
        }
        return new UpgradeResult();
    }

    private Map<Long, Boolean> getAllData() {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(64);
        try (DataSet ds = DB.queryDataSet((String)"TaxProjectUpgradeService", (DBRoute)DBRoute.basedata, (String)SQL_QUERY_ALL);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("fid");
                Boolean b = row.getBoolean("fsyjhjsff");
                map.put(id, b);
            }
        }
        catch (Exception e) {
            this.LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return map;
    }

    private List<Object[]> buildParams(Map<Long, Boolean> paramMap) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(50);
        for (Map.Entry<Long, Boolean> entry : paramMap.entrySet()) {
            Long id = entry.getKey();
            Boolean b = entry.getValue();
            Object[] params = new Object[2];
            params[1] = id;
            params[0] = b != null && b != false ? "1" : "2";
            list.add(params);
        }
        return list;
    }
}

