/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bamp.bastax.common.enums.DateFormatEnum;
import kd.bamp.bastax.common.util.EmptyCheckUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class DateUtils {
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMM_CHINESE = DateUtils.getYyyymmChinese();
    public static final String YYYYMMDD_CHINESE = DateUtils.getYyyymmddChinese();
    public static final String MMDD_CHINESE = DateUtils.getMmddChinese();
    public static final String DD_CHINESE = DateUtils.getDdChinese();
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSSSS = "yyyyMMddHHmmssSS";
    public static final List<String> seasonStartMonth = Collections.unmodifiableList(Arrays.asList("1", "4", "7", "10"));
    public static final List<String> seasonEndMonth = Collections.unmodifiableList(Arrays.asList("3", "6", "9", "12"));
    public static final List<String> halfyearStartMonth = Collections.unmodifiableList(Arrays.asList("1", "7"));
    public static final List<String> halfyearEndMonth = Collections.unmodifiableList(Arrays.asList("6", "12"));
    public static final List<String> dataFormatList = Collections.unmodifiableList(Arrays.asList("yyyy-MM-dd", "yyyy", "yyyy-MM", "yyyyMM", YYYYMM_CHINESE, YYYYMMDD_CHINESE, "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyyMMddHHmmssSS"));

    public static int getMonthDiff(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return monthsDiff;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String formatHMS(Date date) {
        return DateUtils.format(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String format(Date date) {
        return DateUtils.format(date, YYYY_MM_DD);
    }

    public static String formatMonth(Date date) {
        return DateUtils.format(date, YYYY_MM);
    }

    public static Date getLastMaxMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        String strTime = DateUtils.format(calendar.getTime());
        try {
            return new SimpleDateFormat(YYYY_MM_DD).parse(strTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"DateUtils_0", (String)"bamp-bastax-common", (Object[])new Object[0]), e);
        }
    }

    public static Date stringToDateInAnyFormat(String datestr) {
        if (EmptyCheckUtils.isEmpty(datestr)) {
            return null;
        }
        Date date = null;
        for (DateFormatEnum dateFormatEnum : DateFormatEnum.values()) {
            try {
                SimpleDateFormat df;
                if (!datestr.matches(dateFormatEnum.getZhengze()) || null == (date = (df = new SimpleDateFormat(dateFormatEnum.getFormat())).parse(datestr))) continue;
                return date;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (null == date) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef datestr = %1$s", (String)"DateUtils_10", (String)"bamp-bastax-common", (Object[])new Object[0]), datestr));
        }
        return date;
    }

    public static Date stringToDate(String datestr) {
        Date date;
        if (EmptyCheckUtils.isEmpty(datestr)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%1$s", (String)"DateUtils_11", (String)"bamp-bastax-common", (Object[])new Object[0]), YYYY_MM_DD), e);
        }
        return date;
    }

    public static Date stringToDate(String datestr, String dateformat) {
        Date date;
        SimpleDateFormat df = new SimpleDateFormat(dateformat);
        try {
            date = df.parse(datestr);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_9", (String)"bamp-bastax-common", (Object[])new Object[0]), datestr, dateformat), e);
        }
        return date;
    }

    public static String getLastMonthFirstDateStr(String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getFirstDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(cal.getTime());
    }

    public static String getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        return sdf.format(cal.getTime());
    }

    public static String getFirstDateOfMonthStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date getLastDateOfMonth(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date trunc(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayFirst(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayLast(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth2(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String getLastDateOfMonthStr(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(calendar.getTime());
    }

    public static Date addDay(Date date, int iday) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, iday);
        return cd.getTime();
    }

    public static Date addMonth(Date date, int imonth) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(2, imonth);
        return cd.getTime();
    }

    public static Date addYear(Date date, int iyear) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(1, iyear);
        return cd.getTime();
    }

    public static int getYearOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(1);
        return y;
    }

    public static int getMonthOfDate(Date date) {
        int m = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        m = cd.get(2);
        return m + 1;
    }

    public static int getDayOfDate(Date date) {
        int y = 0;
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        y = cd.get(5);
        return y;
    }

    public static Date trunc(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s = sdf.format(date);
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:%2$s", (String)"DateUtils_12", (String)"bamp-bastax-common", (Object[])new Object[0]), format), e);
        }
    }

    public static Date getFirstDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfSeason(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        int month = cd.get(2);
        if (month < 3) {
            cd.set(2, 0);
        } else if (month >= 3 && month < 6) {
            cd.set(2, 3);
            cd.get(2);
            cd.set(2, 3);
        } else if (month >= 6 && month < 9) {
            cd.set(2, 6);
        } else {
            cd.set(2, 9);
        }
        cd.add(2, 2);
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfHalfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 6) {
            cd.set(2, 0);
        } else {
            cd.set(2, 6);
        }
        return DateUtils.getFirstDateOfMonth(cd.getTime());
    }

    public static Date getLastDateOfHalfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(DateUtils.getFirstDateOfMonth(date));
        int month = cd.get(2);
        if (month < 6) {
            cd.set(2, 5);
        } else {
            cd.set(2, 11);
        }
        return DateUtils.getLastDateOfMonth(cd.getTime());
    }

    public static Date getFirstDateOfYear(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getLastDateOfYear(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-31 00:00:00";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getLastDateOfYear1(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-12-31 23:59:59";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getLastDateOfDay(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY_MM_DD).format(cd.getTime()) + " 23:59:59";
        return DateUtils.stringToDate(str, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date getOne(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getTwo(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-04-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getSeven(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-07-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getFour(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-10-01 00:00:00";
        return DateUtils.stringToDate(str);
    }

    public static Date getDateBySeasonal(Date date, String number) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        String str = null;
        switch (number) {
            case "1": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-01-01 00:00:00";
                break;
            }
            case "2": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-04-01 00:00:00";
                break;
            }
            case "3": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-07-01 00:00:00";
                break;
            }
            case "4": {
                str = new SimpleDateFormat(YYYY).format(cd.getTime()) + "-10-01 00:00:00";
                break;
            }
        }
        return DateUtils.stringToDate(str);
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, calendar.getActualMinimum(2));
        calendar.set(5, calendar.getActualMinimum(5));
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static Date getLastDateOfMonth1(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        Calendar nowDate = Calendar.getInstance();
        nowDate.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        if (endTime == null) {
            return nowDate.after(begin);
        }
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return nowDate.after(begin) && nowDate.before(end);
    }

    public static List<Date> getPreDate(Date startData, Date endDate) {
        int diff = DateUtils.getMonthDiff(endDate, startData);
        Date date1 = DateUtils.addMonth(startData, -(diff + 1));
        Date date2 = DateUtils.getLastDateOfMonth(DateUtils.addMonth(endDate, -(diff + 1)));
        return Arrays.asList(date1, date2);
    }

    public static boolean checkTimeRepeat(Date start1, Date end1, Date start2, Date end2) {
        if (end1 == null) {
            if (end2 == null) {
                return Boolean.FALSE;
            }
            return end2.before(start1);
        }
        if (end2 == null) {
            return end1.before(start2);
        }
        return start1.before(start2) && end1.before(start2) || start1.after(end2) && end1.after(end2);
    }

    public static List<String> getMonthBetween(Date minDate, Date maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        min.set(min.get(1), min.get(2), 1);
        max.setTime(maxDate);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static List<String> getMonthBetween(Date minDate, Date maxDate, String format) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        min.set(min.get(1), min.get(2), 1);
        max.setTime(maxDate);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    private static String getYyyymmChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"DateUtils_5", (String)"bamp-bastax-common", (Object[])new Object[0]);
    }

    private static String getYyyymmddChinese() {
        return ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"DateUtils_6", (String)"bamp-bastax-common", (Object[])new Object[0]);
    }

    private static String getMmddChinese() {
        return ResManager.loadKDString((String)"MM\u6708dd\u65e5", (String)"DateUtils_7", (String)"bamp-bastax-common", (Object[])new Object[0]);
    }

    private static String getDdChinese() {
        return ResManager.loadKDString((String)"dd\u65e5", (String)"DateUtils_8", (String)"bamp-bastax-common", (Object[])new Object[0]);
    }
}

