/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.business.pojo.Pair;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.MoveDirectEnum;
import kd.bd.sbd.utils.IDGenerator;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class LotProcessor {
    private static final char SPLIT = '.';
    private boolean isSecond;
    private String srcLotNum;

    public Object[] saveLotMaster(List<Map<String, Object>> mainFields, List<Map<String, Object>> moveFields, String entryKey, boolean isSecond, DynamicObject[] dataEntitys) {
        if (dataEntitys == null || dataEntitys.length < 1) {
            return null;
        }
        this.isSecond = isSecond;
        Map<String, String> mainPropMapping = this.buildPropMapping(mainFields);
        Map<String, String> movePropMapping = this.buildPropMapping(moveFields);
        String name = dataEntitys[0].getDataEntityType().getName();
        if ("im_adjustbill".equals(name) && "afterentity".equals(entryKey)) {
            String value;
            for (Map.Entry<String, String> entry : mainPropMapping.entrySet()) {
                value = entry.getValue();
                value = value.replace("billentry.", "");
                mainPropMapping.put(entry.getKey(), value);
            }
            for (Map.Entry<String, String> entry : movePropMapping.entrySet()) {
                value = entry.getValue();
                value = value.replace("billentry.", "");
                movePropMapping.put(entry.getKey(), value);
            }
        }
        ArrayList<DynamicObject> newLotArrays = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> updateLotArrays = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> lotMoveArrays = new ArrayList<DynamicObject>();
        List<Object> billPks = this.getBillPks(dataEntitys);
        String matProp = this.getRealProp(mainPropMapping, "material") + ".masterid.id";
        String lotProp = this.getRealProp(mainPropMapping, "number");
        HashSet<String> lotNums = new HashSet<String>();
        HashSet<Pair> MatLot = new HashSet<Pair>();
        for (DynamicObject dataEntity : dataEntitys) {
            if ("im_adjustbill".equals(name) && "afterentity".equals(entryKey)) {
                Iterator entrys = dataEntity.getDynamicObjectCollection("billentry");
                Iterator iterator = entrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject entry = (DynamicObject)iterator.next();
                    DynamicObjectCollection rows = entry.getDynamicObjectCollection(entryKey);
                    for (DynamicObject row : rows) {
                        MatLot.add(new Pair(row.getLong(matProp), row.getString(lotProp)));
                        String prop = row.getString(lotProp) == null ? "" : row.getString(lotProp).trim();
                        if (!StringUtils.isNotEmpty((CharSequence)prop)) continue;
                        lotNums.add(prop);
                    }
                }
            } else {
                for (DynamicObject row : dataEntity.getDynamicObjectCollection(entryKey)) {
                    MatLot.add(new Pair(row.getLong(matProp), row.getString(lotProp)));
                    String prop = row.getString(lotProp) == null ? "" : row.getString(lotProp).trim();
                    if (!StringUtils.isNotEmpty((CharSequence)prop)) continue;
                    lotNums.add(prop);
                }
            }
            billPks.add(dataEntity.getPkValue());
        }
        if (lotNums.size() < 1) {
            return null;
        }
        Map<String, List<Object>> result = this.deleteLotMaster(billPks, true);
        List<Object> toDelLotPks = result.get("bd_lot");
        Set<Object> lotPks = this.buildPks(lotNums, MatLot);
        Map<Object, DynamicObject> lotMap = this.buildLotMap(lotPks);
        toDelLotPks.removeAll(lotPks);
        Map<Pair, List<DynamicObject>> lotMovesMap = this.bulidLotMoveMap(dataEntitys, movePropMapping, lotPks);
        List<Object> moves = new ArrayList();
        String lotNumber = null;
        Long masterid = null;
        Object lotPk = 0;
        Pair key = null;
        IDGenerator idGenerator = new IDGenerator();
        for (DynamicObject dataEntity : dataEntitys) {
            long billId = dataEntity.getLong("id");
            String bizdirection = this.getDirection(dataEntity);
            if ("im_adjustbill".equals(name) && "afterentity".equals(entryKey)) {
                DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    DynamicObjectCollection rows = entry.getDynamicObjectCollection(entryKey);
                    for (DynamicObject row : rows) {
                        lotNumber = row.getString(lotProp);
                        if (lotNumber == null || StringUtils.isEmpty((CharSequence)lotNumber.trim())) continue;
                        masterid = row.getLong(matProp);
                        key = new Pair(masterid, lotNumber);
                        moves = lotMovesMap.get(key);
                        String lotNum = (String)this.getRealPropValue(mainPropMapping, "number", dataEntity, row);
                        if ("0".equals(bizdirection)) {
                            this.srcLotNum = lotNum;
                        }
                        DynamicObject moveTrack = this.buildmoveTrack(movePropMapping, dataEntity, row, lotNum);
                        if (moves == null || moves.size() < 1) {
                            lotPk = idGenerator.getGlobalId();
                            DynamicObject newLot = this.buildNewLot(lotPk, mainPropMapping, dataEntity, row);
                            newLotArrays.add(newLot);
                            moves = new ArrayList();
                            moves.add(moveTrack);
                            lotMovesMap.put(new Pair(newLot.getLong("material"), newLot.getString("number")), moves);
                            lotMap.put(lotPk, newLot);
                        } else {
                            Object object = lotPk = ((DynamicObject)moves.get(0)).getLong("lot_id") == 0L ? ((DynamicObject)moves.get(0)).get("lot") : ((DynamicObject)moves.get(0)).get("lot_id");
                            if (moves.size() == 1 && billId == ((DynamicObject)moves.get(0)).getLong("billid")) {
                                DynamicObject lot = lotMap.get(lotPk);
                                DynamicObject toLot = this.buildLot(mainPropMapping, dataEntity, row, lot);
                                updateLotArrays.add(toLot);
                            }
                        }
                        moveTrack.set("lot", lotPk);
                        this.dealMoveDirect(moveTrack, movePropMapping, dataEntity, row);
                        lotMoveArrays.add(moveTrack);
                        row.set("lot1", lotPk);
                    }
                }
                continue;
            }
            for (DynamicObject row : dataEntity.getDynamicObjectCollection(entryKey)) {
                lotNumber = row.getString(lotProp);
                if (lotNumber == null || StringUtils.isEmpty((CharSequence)lotNumber.trim())) continue;
                masterid = row.getLong(matProp);
                key = new Pair(masterid, lotNumber);
                moves = lotMovesMap.get(key);
                String lotNum = (String)this.getRealPropValue(mainPropMapping, "number", dataEntity, row);
                if ("0".equals(bizdirection)) {
                    this.srcLotNum = lotNum;
                }
                DynamicObject moveTrack = this.buildmoveTrack(movePropMapping, dataEntity, row, lotNum);
                if (moves == null || moves.size() < 1) {
                    lotPk = idGenerator.getGlobalId();
                    DynamicObject newLot = this.buildNewLot(lotPk, mainPropMapping, dataEntity, row);
                    newLotArrays.add(newLot);
                    moves = new ArrayList();
                    moves.add(moveTrack);
                    lotMovesMap.put(new Pair(newLot.getLong("material"), newLot.getString("number")), moves);
                    lotMap.put(lotPk, newLot);
                } else {
                    Object object = lotPk = ((DynamicObject)moves.get(0)).getLong("lot_id") == 0L ? ((DynamicObject)moves.get(0)).get("lot") : ((DynamicObject)moves.get(0)).get("lot_id");
                    if (moves.size() == 1 && billId == ((DynamicObject)moves.get(0)).getLong("billid")) {
                        DynamicObject lot = lotMap.get(lotPk);
                        DynamicObject toLot = this.buildLot(mainPropMapping, dataEntity, row, lot);
                        updateLotArrays.add(toLot);
                    }
                }
                moveTrack.set("lot", lotPk);
                this.dealMoveDirect(moveTrack, movePropMapping, dataEntity, row);
                lotMoveArrays.add(moveTrack);
                row.set("lot", lotPk);
            }
        }
        updateLotArrays.removeAll(newLotArrays);
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"sbd_saveLotMainFile");){
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_lot"), (Object[])result.get("bd_lot").toArray());
            if (!this.isSecond) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_lotmovetrack"), (Object[])result.get("bd_lotmovetrack").toArray());
            }
            SaveServiceHelper.save((DynamicObject[])newLotArrays.toArray(new DynamicObject[newLotArrays.size()]));
            SaveServiceHelper.save((DynamicObject[])updateLotArrays.toArray(new DynamicObject[updateLotArrays.size()]));
            SaveServiceHelper.save((DynamicObject[])lotMoveArrays.toArray(new DynamicObject[lotMoveArrays.size()]));
            Object[] objectArray = dataEntitys;
            return objectArray;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Map<Object, DynamicObject> buildLotMap(Set<Object> lotPks) {
        DynamicObject[] lots = BusinessDataServiceHelper.load((Object[])lotPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bd_lot"));
        HashMap<Object, DynamicObject> lotMap = new HashMap<Object, DynamicObject>(lots.length);
        for (DynamicObject lot : lots) {
            lotMap.put(lot.getPkValue(), lot);
        }
        return lotMap;
    }

    public Map<String, List<Object>> deleteLotMaster(List<Object> billPks, boolean isUpdate) {
        HashSet<Object> lotPks = new HashSet<Object>();
        ArrayList<Object> toDelMovePks = new ArrayList<Object>(16);
        this.buildPks(lotPks, toDelMovePks, billPks);
        ArrayList<Object> toDelLotPks = new ArrayList<Object>(16);
        if (!lotPks.isEmpty()) {
            QFilter filter = new QFilter("lot", "in", (Object)lotPks.toArray());
            filter.and(new QFilter("billid", "not in", (Object)billPks.toArray()));
            try (DataSet moves = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".deleteLotMaster"), (String)"bd_lotmovetrack", (String)"id,lot,billid", (QFilter[])filter.toArray(), null).groupBy(new String[]{"lot"}).finish();){
                moves.forEach(move -> lotPks.remove(move.getLong("lot")));
            }
            toDelLotPks.addAll(lotPks);
        }
        HashMap<String, List<Object>> result = new HashMap<String, List<Object>>();
        result.put("bd_lot", toDelLotPks);
        result.put("bd_lotmovetrack", toDelMovePks);
        if (!isUpdate) {
            this.deleteDatas(result);
        }
        return result;
    }

    private void deleteDatas(Map<String, List<Object>> result) {
        try (TXHandle tx = TX.requiresNew((String)"sbd_deleteLotMainFile");){
            try {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_lot"), (Object[])new HashSet(result.get("bd_lot")).toArray());
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bd_lotmovetrack"), (Object[])new HashSet(result.get("bd_lotmovetrack")).toArray());
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject buildmoveTrack(Map<String, String> movePropMapping, DynamicObject dataEntity, DynamicObject row, String lotNum) {
        DynamicObject moveTrack = BusinessDataServiceHelper.newDynamicObject((String)"bd_lotmovetrack");
        for (String key : movePropMapping.keySet()) {
            moveTrack.set(key, this.getRealPropValue(movePropMapping, key, dataEntity, row));
        }
        moveTrack.set("billentity", (Object)dataEntity.getDataEntityType().getName());
        moveTrack.set("billid", dataEntity.getPkValue());
        moveTrack.set("dseq", (Object)row.getInt("seq"));
        String bizdirection = this.getDirection(dataEntity);
        if (StringUtils.isNotEmpty((CharSequence)this.srcLotNum) && "1".equals(bizdirection) && !this.srcLotNum.equals(lotNum)) {
            moveTrack.set("srclotnum", (Object)this.srcLotNum);
        }
        return moveTrack;
    }

    private DynamicObject buildNewLot(Object lotPk, Map<String, String> mainPropMapping, DynamicObject dataEntity, DynamicObject row) {
        DynamicObject newLot = BusinessDataServiceHelper.newDynamicObject((String)"bd_lot");
        newLot.set("id", lotPk);
        return this.buildLot(mainPropMapping, dataEntity, row, newLot);
    }

    private DynamicObject buildLot(Map<String, String> mainPropMapping, DynamicObject dataEntity, DynamicObject row, DynamicObject lot) {
        for (String key : mainPropMapping.keySet()) {
            if ("material".equals(key)) {
                lot.set(key, row.get(this.getRealProp(mainPropMapping, key) + ".masterid.id"));
                continue;
            }
            lot.set(key, this.getRealPropValue(mainPropMapping, key, dataEntity, row));
        }
        lot.set("modifier", (Object)RequestContext.get().getUserId());
        lot.set("modifytime", (Object)TimeServiceHelper.now());
        lot.set("lotstatus", (Object)"A");
        lot.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
        lot.set("status", (Object)"C");
        return lot;
    }

    private void buildPks(Set<Object> lotPks, List<Object> toDelMovePks, List<Object> billPks) {
        DynamicObject[] docs;
        QFilter filter = new QFilter("billid", "in", (Object)billPks.toArray());
        for (DynamicObject move : docs = BusinessDataServiceHelper.load((String)"bd_lotmovetrack", (String)"id,lot", (QFilter[])new QFilter[]{filter})) {
            lotPks.add(move.get("lot.id"));
            toDelMovePks.add(move.getPkValue());
        }
    }

    private Set<Object> buildPks(Set<String> lotNums, Set<Pair> matLot) {
        HashSet<Object> lotPks = new HashSet<Object>();
        QFilter filter = new QFilter("lot.number", "in", (Object)lotNums.toArray());
        DynamicObjectCollection docs = QueryServiceHelper.query((String)"bd_lotmovetrack", (String)"id,lot,lot.number,lot.material", (QFilter[])new QFilter[]{filter});
        for (DynamicObject move : docs) {
            Pair value = new Pair(move.getLong("lot.material"), move.getString("lot.number"));
            if (!matLot.contains(value)) continue;
            lotPks.add(move.get("lot"));
        }
        return lotPks;
    }

    private List<Object> getBillPks(DynamicObject[] dataEntitys) {
        ArrayList<Object> billPks = new ArrayList<Object>(dataEntitys.length);
        for (DynamicObject dataEntity : dataEntitys) {
            billPks.add(dataEntity.getPkValue());
        }
        return billPks;
    }

    private void dealMoveDirect(DynamicObject moveTrack, Map<String, String> movePropMapping, DynamicObject dataEntity, DynamicObject row) {
        String bizdirection = this.getDirection(dataEntity);
        if ("0".equals(bizdirection)) {
            moveTrack.set("movedirect", (Object)MoveDirectEnum.SRC.getValue());
        } else {
            moveTrack.set("movedirect", (Object)MoveDirectEnum.DES.getValue());
        }
    }

    private boolean isException(DynamicObject entity) {
        return entity.getDataEntityType().getName().equals("im_transinbill") || entity.getDataEntityType().getName().equals("im_transoutbill");
    }

    private Map<Pair, List<DynamicObject>> bulidLotMoveMap(DynamicObject[] dataEntitys, Map<String, String> movePropMapping, Set<Object> lotPks) {
        HashMap<Pair, List<DynamicObject>> lotMovesMap = new HashMap<Pair, List<DynamicObject>>();
        if (lotPks.size() > 0) {
            DynamicObject[] moves;
            QFilter filter = new QFilter("lot", "in", (Object)lotPks.toArray());
            for (DynamicObject move : moves = BusinessDataServiceHelper.load((String)"bd_lotmovetrack", (String)"id,lot,billid", (QFilter[])new QFilter[]{filter})) {
                Pair key = new Pair(move.getLong("lot.material.id"), move.getString("lot.number"));
                ArrayList<DynamicObject> mlist = (ArrayList<DynamicObject>)lotMovesMap.get(key);
                if (mlist == null) {
                    mlist = new ArrayList<DynamicObject>();
                    mlist.add(move);
                    lotMovesMap.put(key, mlist);
                    continue;
                }
                mlist.add(move);
            }
        }
        return lotMovesMap;
    }

    private Map<String, String> buildPropMapping(List<Map<String, Object>> Fields) {
        HashMap<String, String> propMapping = new HashMap<String, String>(Fields.size());
        for (Map<String, Object> map : Fields) {
            propMapping.put((String)map.get("metadatakey"), (String)map.get("currentmetadatakey"));
        }
        return propMapping;
    }

    private String getRealProp(Map<String, String> propMapping, String key) {
        String prop = propMapping.get(key);
        if (prop.indexOf(46) == -1) {
            return prop;
        }
        return prop.substring(prop.indexOf(46) + 1);
    }

    private Object getRealPropValue(Map<String, String> propMapping, String key, DynamicObject entity, DynamicObject entryRow) {
        String prop = propMapping.get(key);
        if (prop.indexOf(46) == -1) {
            return entity.get(prop);
        }
        return entryRow.get(prop.substring(prop.indexOf(46) + 1));
    }

    private String getDirection(DynamicObject dataEntity) {
        String type = dataEntity.getDataEntityType().getName();
        if (type.equals("im_materialreqbill") || type.equals("im_initbill") || type.equals("im_transapply") || type.equals("im_adjustbill")) {
            return "0";
        }
        if (type.equals("im_assembbill")) {
            return "2";
        }
        DynamicObject invscheme = dataEntity.getDynamicObject("invscheme");
        if (invscheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u4e8b\u52a1", (String)"LotProcessor_0", (String)"bd-sbd-business", (Object[])new Object[0]));
        }
        invscheme = BusinessDataServiceHelper.loadSingle((Object)invscheme.getPkValue(), (String)"im_invscheme");
        DynamicObject transceiverType = invscheme.getDynamicObject("transceivertype");
        String bizdirection = transceiverType.getString("bizdirection");
        return bizdirection;
    }
}

