/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.bizrule.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.gbs.plugin.bizrule.op.BizCommonOp;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class BizRuleSaveOp
extends BizCommonOp {
    private static final String BOS_OPBIZRULESET = "bos_opbizruleset";
    private static final String SELECT_FIELD = "opbizrule,objecttype,enabled,entryentity, entryentity.operationkey, entryentity.seq";
    private static final Log LOGGER = LogFactory.getLog(BizRuleSaveOp.class);

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        Arrays.stream(dataEntities).filter(entity -> entity.get("validateindex") == null).forEach(entity -> entity.set("validateindex", (Object)9999));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        LOGGER.info("save.bos_opbizruleset.start");
        try {
            DynamicObject[] dataEntities = e.getDataEntities();
            ArrayList opBizRuleSetList = new ArrayList(dataEntities.length);
            HashMap<String, Object> entityOperationMap = new HashMap<String, Object>(dataEntities.length * 2);
            for (DynamicObject dataEntity : dataEntities) {
                String entityId2 = dataEntity.getDynamicObject("entity").getString("id");
                String applyoperation = dataEntity.getString("applyoperation");
                DynamicObject[] operationList = (DynamicObject[])entityOperationMap.getOrDefault(entityId2, new ArrayList());
                if (operationList.contains(applyoperation)) continue;
                operationList.add(applyoperation);
                entityOperationMap.put(entityId2, operationList);
            }
            LOGGER.info("save.bos_opbizruleset.entityOperationMap={}", entityOperationMap);
            QFilter filter = new QFilter("opbizrule", "=", (Object)"XHBizRuleValidateExt");
            filter.and(new QFilter("objecttype", "in", entityOperationMap.keySet()));
            DynamicObject[] opSetDyArray = BusinessDataServiceHelper.load((String)BOS_OPBIZRULESET, (String)SELECT_FIELD, (QFilter[])filter.toArray());
            Map entityMap = Arrays.stream(opSetDyArray).collect(Collectors.toMap(dy -> dy.getString("objecttype.id"), Function.identity(), (oldV, newV) -> newV));
            List operationList = entityOperationMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            filter.and(new QFilter("entryentity.operationkey", "in", operationList));
            DynamicObject[] oparateDyArray = BusinessDataServiceHelper.load((String)BOS_OPBIZRULESET, (String)SELECT_FIELD, (QFilter[])filter.toArray());
            HashMap<String, List<Object>> existEntityOperationMap = new HashMap<String, List<Object>>(16);
            for (DynamicObject oparateDy : oparateDyArray) {
                String entityId3 = oparateDy.getString("objecttype.id");
                List existOpList = oparateDy.getDynamicObjectCollection("entryentity").stream().map(entry -> entry.getString("operationkey")).collect(Collectors.toList());
                List defaultOpList = existEntityOperationMap.getOrDefault(entityId3, new ArrayList());
                defaultOpList.addAll(existOpList);
                existEntityOperationMap.put(entityId3, existOpList);
            }
            entityOperationMap.forEach((entityId, opList) -> {
                DynamicObject opBizRuleDy = (DynamicObject)entityMap.get(entityId);
                for (String op : opList) {
                    List existOpList = (List)existEntityOperationMap.get(entityId);
                    if (existOpList != null && !existOpList.isEmpty() && existOpList.contains(op)) continue;
                    if (opBizRuleDy == null) {
                        opBizRuleDy = BusinessDataServiceHelper.newDynamicObject((String)BOS_OPBIZRULESET);
                    }
                    opBizRuleDy.set("opbizrule", (Object)"XHBizRuleValidateExt");
                    opBizRuleDy.set("objecttype", entityId);
                    opBizRuleDy.set("enabled", (Object)"1");
                    DynamicObjectCollection entryentity = opBizRuleDy.getDynamicObjectCollection("entryentity");
                    DynamicObject entryDy = entryentity.addNew();
                    entryDy.set("operationkey", (Object)op);
                    entryDy.set("seq", (Object)entryentity.size());
                    opBizRuleSetList.add(opBizRuleDy);
                }
            });
            if (opBizRuleSetList.isEmpty()) {
                return;
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)BOS_OPBIZRULESET, (DynamicObject[])opBizRuleSetList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            LOGGER.info("save.bos_opbizruleset.result={}", (Object)SerializationUtils.toJsonString((Object)operationResult));
        }
        catch (Exception exception) {
            LOGGER.error("save.bos_opbizruleset.error", (Throwable)exception);
        }
    }
}

