/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.DeployService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptWriter;

public class FlowSchemeImportFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private long LIMITSIZ = 0x500000L;
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";
    public static final String HEAD_DELETE = "DELETE FROM ";
    public static final String HEAD_INSERT = "INSERT INTO ";
    public static final String INDEX_FID = "FID";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.confirm();
                break;
            }
        }
    }

    public void upload(UploadEvent arg0) {
        if (arg0 == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01", (String)"FlowSchemeImportFormPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
            return;
        }
        Object[] args = arg0.getUrls();
        if (args == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01", (String)"FlowSchemeImportFormPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
            return;
        }
        for (int n = 0; n < args.length; ++n) {
            Map urlMsg = (Map)args[n];
            String urlName = (String)urlMsg.get("name");
            String url = (String)urlMsg.get("url");
            JSONArray urlArr = new JSONArray();
            JSONObject urlObj = new JSONObject();
            urlObj.put(urlName, (Object)url);
            urlArr.add((Object)urlObj);
            JSONArray urlCaheArr = JSONArray.parseArray((String)this.getPageCache().get("urlarr"));
            if (urlCaheArr != null && urlCaheArr.size() > 0) {
                for (int i = 0; i < urlCaheArr.size(); ++i) {
                    JSONObject urlCatchObj = (JSONObject)urlCaheArr.get(i);
                    if (!urlCatchObj.containsKey((Object)urlName)) continue;
                    urlCaheArr.remove((Object)urlCatchObj);
                }
                urlCaheArr.addAll((Collection)urlArr);
                this.getPageCache().put("urlarr", urlCaheArr.toJSONString());
                continue;
            }
            this.getPageCache().put("urlarr", urlArr.toJSONString());
        }
    }

    public void remove(UploadEvent arg0) {
        Map urlMsg = (Map)arg0.getUrls()[0];
        String urlName = (String)urlMsg.get("name");
        String url = (String)urlMsg.get("url");
        JSONArray urlCacheArr = JSONArray.parseArray((String)this.getPageCache().get("urlarr"));
        if (urlCacheArr != null && urlCacheArr.size() > 0) {
            for (int i = 0; i < urlCacheArr.size(); ++i) {
                JSONObject urlCatchObj = (JSONObject)urlCacheArr.get(i);
                if (!urlCatchObj.containsKey((Object)urlName)) continue;
                urlCacheArr.remove((Object)urlCatchObj);
            }
            this.getPageCache().put("urlarr", urlCacheArr.toJSONString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirm() {
        JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get("urlarr"));
        JSONObject message = new JSONObject();
        if (urlArr != null && urlArr.size() > 0) {
            for (int i = 0; i < urlArr.size(); ++i) {
                JSONObject urlObj = (JSONObject)urlArr.get(i);
                for (String urlName : urlObj.keySet()) {
                    String url = urlObj.getString(urlName);
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    ZipEntry zipEntry = null;
                    try (InputStream inputStream = cache.getInputStream(url);
                         ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                        ZipEntry zEntry = zipInputStream.getNextEntry();
                        if (zEntry == null) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01", (String)"FlowSchemeImportFormPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    catch (NullPointerException nullPoint) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01", (String)"FlowSchemeImportFormPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                        return;
                    }
                    catch (IOException redisExcetion) {
                        this.getView().showErrorNotification(redisExcetion.getMessage());
                        return;
                    }
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("type", "KSQL");
                    params.put("dbkey", "sys");
                    params.put("ksqlname", "import_flowscheme");
                    params.put("version", "1.5");
                    params.put("appname", "gbs");
                    params.put("pkname", "bd-bd");
                    try (TXHandle tx = TX.required((String)"gbs_flow_import");){
                        InputStream inStream = cache.getInputStream(url);
                        ZipInputStream zipIn = new ZipInputStream(inStream);
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            if (zipEntry.isDirectory()) continue;
                            String fileName = zipEntry.getName();
                            fileName = fileName.replace(File.separator, "/");
                            int readLength = 0;
                            int len = 0;
                            byte[] buf = new byte[(int)this.LIMITSIZ];
                            String content = null;
                            if (!fileName.endsWith("sql") && !fileName.endsWith("SQL")) continue;
                            while ((readLength = zipIn.read()) != -1) {
                                buf[len] = (byte)readLength;
                                ++len;
                            }
                            content = new String(buf, 0, len);
                            String[] arraySQL = StringUtils.split((String)content, (String)System.getProperty("line.separator"));
                            String errorMsg = this.doValidateSql(arraySQL);
                            if (errorMsg != null) {
                                throw new Exception(errorMsg);
                            }
                            ArrayList<String> sqlList = new ArrayList<String>(16);
                            for (String sql : arraySQL) {
                                if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
                                sqlList.add(sql);
                            }
                            ((DeployService)ServiceFactory.getService(DeployService.class)).deploySql(params, sqlList);
                        }
                    }
                    try {
                        PreInsDataScriptWriter write = new PreInsDataScriptWriter();
                        InputStream inStream2 = cache.getInputStream(url);
                        ZipInputStream zipIn2 = new ZipInputStream(inStream2);
                        while ((zipEntry = zipIn2.getNextEntry()) != null) {
                            if (zipEntry.isDirectory()) {
                                String dirName = zipEntry.getName();
                                if (!dirName.equals("xml/")) continue;
                                while ((zipEntry = zipIn2.getNextEntry()) != null) {
                                    if (zipEntry.isDirectory()) continue;
                                    String fileName = zipEntry.getName();
                                    int readLength = 0;
                                    int len = 0;
                                    byte[] buf = new byte[(int)this.LIMITSIZ];
                                    String content = null;
                                    if (!fileName.endsWith("xml") && !fileName.endsWith("XML")) continue;
                                    while ((readLength = zipIn2.read()) != -1) {
                                        buf[len] = (byte)readLength;
                                        ++len;
                                    }
                                    content = new String(buf, 0, len);
                                    write.insertPreInsData(content);
                                }
                                continue;
                            }
                            String fileName = zipEntry.getName();
                            int readLength = 0;
                            int len = 0;
                            byte[] buf = new byte[(int)this.LIMITSIZ];
                            String content = null;
                            if (!fileName.endsWith("xml") && !fileName.endsWith("XML")) continue;
                            while ((readLength = zipIn2.read()) != -1) {
                                buf[len] = (byte)readLength;
                                ++len;
                            }
                            content = new String(buf, 0, len);
                            write.insertPreInsData(content);
                        }
                    }
                    catch (Exception e) {
                        this.getView().showErrorNotification(e.getMessage());
                    }
                    message.put(SUCCESS, (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"FlowSchemeImportFormPlugin_3", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                    this.getView().returnDataToParent((Object)message);
                    this.getView().close();
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6d41\u7a0b\u811a\u672c\u5305\u3002", (String)"FlowSchemeImportFormPlugin_4", (String)"bd-gbs-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
    }

    private Set<String> getLeagTableName() {
        HashSet<String> legalTableSet = new HashSet<String>(2);
        legalTableSet.add("T_GBS_FLOWSCHEME");
        legalTableSet.add("T_GBS_FLOWSCHEME_L");
        legalTableSet.add("T_GBS_FLOWNODE");
        legalTableSet.add("T_GBS_FLOWNODE_L");
        return legalTableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPreIds() {
        HashSet<String> preIds = new HashSet<String>(16);
        try (DataSet schemeDs = null;){
            schemeDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gbs_flowscheme", (String)"id", (QFilter[])new QFilter("ispreset", "=", (Object)Character.valueOf('1')).toArray(), null);
            for (Row row : schemeDs) {
                preIds.add(row.getString("id"));
            }
        }
        return preIds;
    }

    private String doValidateSql(String[] arraySQL) {
        Set<String> legalTableSet = this.getLeagTableName();
        Set<String> preIdSet = this.getPreIds();
        for (String sql : arraySQL) {
            if (!StringUtils.isNotBlank((CharSequence)sql)) continue;
            sql = sql.trim().toUpperCase();
            boolean isDeleteSql = sql.startsWith(HEAD_DELETE);
            boolean isInsertSql = sql.startsWith(HEAD_INSERT);
            if (isDeleteSql || isInsertSql) {
                sql = sql.replace(HEAD_DELETE, "");
                sql = sql.replace(HEAD_INSERT, "");
                boolean isCheckPreSet = false;
                String tableName = "";
                int index = sql.indexOf(40);
                if (index > 0) {
                    tableName = sql.substring(0, sql.indexOf(40));
                    tableName = tableName.replace(" ", "");
                } else {
                    tableName = sql.substring(0, sql.indexOf(32));
                }
                if (legalTableSet.contains(tableName)) {
                    if ("T_GBS_FLOWSCHEME".equals(tableName)) {
                        isCheckPreSet = true;
                    }
                } else {
                    return ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u6d41\u7a0b\u5bfc\u822a\u8fdb\u884c\u5bfc\u5165\uff0c\u8bf7\u68c0\u67e5sql\u3002", (String)"FlowSchemeImportFormPlugin_5", (String)"bd-gbs-plugin", (Object[])new Object[0]);
                }
                if (!isDeleteSql || preIdSet.isEmpty() || !isCheckPreSet) continue;
                sql = sql.substring(sql.indexOf(INDEX_FID, 0) + INDEX_FID.length());
                for (String sqlSpilt : sql.split(" ")) {
                    if (StringUtils.isEmpty((CharSequence)sqlSpilt) || "=".equals(sqlSpilt) || !preIdSet.contains(sqlSpilt = sqlSpilt.replace(";", ""))) continue;
                    return ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5bf9\u9884\u8bbe\u6570\u636e\u8fdb\u884c\u8986\u76d6\u5bfc\u5165\u3002", (String)"FlowSchemeImportFormPlugin_6", (String)"bd-gbs-plugin", (Object[])new Object[0]);
                }
                continue;
            }
            return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5sql\u683c\u5f0f\uff0c\u4e0e\u5bfc\u51fa\u811a\u672c\u4fdd\u6301\u4e00\u81f4\u3002", (String)"FlowSchemeImportFormPlugin_7", (String)"bd-gbs-plugin", (Object[])new Object[0]);
        }
        return null;
    }
}

