/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.plugin.flowcard.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class FlowSchemeDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("ispreset");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void validate() {
                ExtendedDataEntity[] billInfos = this.getDataEntities();
                QFilter cardQ = new QFilter("cardtype", "=", (Object)"bos_card_custom");
                if (billInfos.length > 1) {
                    cardQ.and("config", "like", (Object)"%gbs_flowcard%");
                } else {
                    String flowId = billInfos[0].getBillPkId().toString();
                    cardQ.and("config", "like", (Object)("%" + flowId + "%"));
                }
                HashSet<String> flowIds = new HashSet<String>(16);
                try (DataSet cardDs = null;){
                    cardDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_mainpagecardconfig", (String)"config", (QFilter[])cardQ.toArray(), null);
                    for (Row cardInfo : cardDs) {
                        JSONObject configJson = (JSONObject)SerializationUtils.fromJsonString((String)cardInfo.getString("config"), JSONObject.class);
                        String flowIdStr = configJson.getString("flowids");
                        if (StringUtils.isEmpty((CharSequence)flowIdStr)) continue;
                        for (String flowId : flowIdStr.split(",")) {
                            flowIds.add(flowId);
                        }
                    }
                }
                for (ExtendedDataEntity billInfo : this.getDataEntities()) {
                    String flowId;
                    DynamicObject bill = billInfo.getDataEntity();
                    if (bill.getBoolean("ispreset")) {
                        this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u6570\u636e\u4e0d\u80fd\u5220\u9664\u3002", (String)"FlowSchemeDeleteOpPlugin_0", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                    }
                    if (!flowIds.contains(flowId = bill.getPkValue().toString())) continue;
                    this.addErrorMessage(billInfo, ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u88ab\u5361\u7247\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FlowSchemeDeleteOpPlugin_1", (String)"bd-gbs-plugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>(bills.length);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject info = bills[i];
            Object fid = info.getPkValue();
            ids.add(fid);
        }
        QFilter filter = new QFilter("flowscheme", "in", ids);
        DeleteServiceHelper.delete((String)"gbs_flownode", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"gbs_flowscheme", (QFilter[])new QFilter("id", "in", ids).toArray());
    }
}

