/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.update;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;

public class CustomerDataUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(CustomerDataUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Object params2;
        Throwable throwable;
        UpgradeResult result = new UpgradeResult();
        String sql = "select aa.fid ,aa.fpkid ,aa.flocaleid,bb.faddress,bb.flinkman,bb.fartificialperson,bb.fregcapital,bb.fbusinessterm,bb.fbusinessscope from ( select a.fid,a.fbizpartnerid,b.fpkid,b.flocaleid from t_bd_customer a inner join t_bd_customer_l b on a.fid =b.fid where (select count(1) as num from t_bd_customer_b b where b.fid = a.fid) = 0 ) aa inner join t_bd_bizpartner_l bb on aa.fbizpartnerid=bb.fid and aa.flocaleid =bb.flocaleid ";
        ArrayList<SqlObject> sqlObjs = new ArrayList<SqlObject>();
        DBRoute dbRoute = new DBRoute(dbKey);
        this.updateType(dbRoute);
        try {
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)"CustomerDataUpgradeService.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, null);){
                params2 = null;
                for (Row row : ds) {
                    params2 = new SqlParameter[]{new SqlParameter("faddress", -9, (Object)(row.getString("faddress") == null ? " " : row.getString("faddress"))), new SqlParameter("flinkman", -9, (Object)(row.getString("flinkman") == null ? " " : row.getString("flinkman"))), new SqlParameter("fartificialperson", -9, (Object)(row.getString("fartificialperson") == null ? " " : row.getString("fartificialperson"))), new SqlParameter("fregcapital", -9, (Object)(row.getString("fregcapital") == null ? " " : row.getString("fregcapital"))), new SqlParameter("fbusinessterm", -9, (Object)(row.getString("fbusinessterm") == null ? " " : row.getString("fbusinessterm"))), new SqlParameter("fbusinessscope", -9, (Object)(row.getString("fbusinessscope") == null ? " " : row.getString("fbusinessscope"))), new SqlParameter("fid", -5, (Object)row.getLong("fid")), new SqlParameter("fpkid", -9, (Object)row.getString("fpkid")), new SqlParameter("flocaleid", -9, (Object)row.getString("flocaleid"))};
                    sqlObjs.add(new SqlObject("update t_bd_customer_l set faddress=?,flinkman=?,fartificialperson=?,fregcapital=?,fbusinessterm=?,fbusinessscope=? where fid=? and fpkid=? and flocaleid =?", (SqlParameter[])params2));
                }
            }
            catch (Throwable params2) {
                throwable = params2;
                throw params2;
            }
        }
        catch (Throwable e) {
            result.setSuccess(false);
            String err = "query data field failed,errorMsgInfo\uff1a" + e.getMessage();
            result.setErrorInfo(err);
            result.setLog(err);
            return result;
        }
        log.info("customer data updated before.");
        throwable = null;
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                if (sqlObjs.size() > 0) {
                    params2 = new ArrayList(sqlObjs.size());
                    for (SqlObject sqlObject : sqlObjs) {
                        params2.add(sqlObject.getParams());
                    }
                    DB.executeBatch((DBRoute)dbRoute, (String)((SqlObject)sqlObjs.get(0)).getSql(), (List)params2);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                result.setErrorInfo("database execution failed,errorInfo" + e.getMessage());
                result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        log.info("after customer data updated.");
        this.insetCustomerBusData(dbKey);
        result.setSuccess(true);
        result.setLog("data update successful.");
        return result;
    }

    private void updateType(DBRoute dbRoute) {
        SqlParameter[] params2;
        Throwable throwable;
        String sql = " select t1.fid,t2.ftype from t_bd_customer t1  left join t_bd_bizpartner t2 on t1.fbizpartnerid=t2.fid  where t1.ftype=' '";
        ArrayList<SqlObject> sqlObjs = new ArrayList<SqlObject>();
        try {
            throwable = null;
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql, null);){
                params2 = null;
                for (Row row : ds) {
                    if (row.getString("fid") == null || StringUtils.isEmpty((String)String.valueOf(row.getString("fid")))) continue;
                    params2 = new SqlParameter[]{new SqlParameter("ftype", -9, (Object)row.getString("ftype")), new SqlParameter("fid", -5, (Object)row.getLong("fid"))};
                    sqlObjs.add(new SqlObject("update t_bd_customer set ftype = ? where Fid= ?", params2));
                }
            }
            catch (Throwable params2) {
                throwable = params2;
                throw params2;
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage());
        }
        throwable = null;
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                if (sqlObjs.size() > 0) {
                    params2 = new ArrayList(sqlObjs.size());
                    for (SqlObject sqlObject : sqlObjs) {
                        params2.add(sqlObject.getParams());
                    }
                    DB.executeBatch((DBRoute)dbRoute, (String)((SqlObject)sqlObjs.get(0)).getSql(), (List)params2);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                log.error(e.getMessage());
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void insetCustomerBusData(String dbKey) {
        String sql = "select aa.fid,bb.fcountryid,bb.fpostalcode,bb.fphone,bb.ffax,bb.furl,bb.fsocietycreditcode,bb.forgcode,bb.fbizregisterno, bb.ftxregisterno,bb.finternalcompanyid,bb.festablishdate,bb.fadmindivision from ( select a.fid,a.fbizpartnerid from t_bd_customer a where (select count(1) as num from t_bd_customer_b b where b.fid = a.fid) = 0) aa left join t_bd_bizpartner bb on aa.fbizpartnerid=bb.fid ";
        DBRoute dbRoute = new DBRoute(dbKey);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        try (DataSet ds = DB.queryDataSet((String)"CustomerDataUpgradeService.insetCustomerBusData", (DBRoute)dbRoute, (String)sql, null);){
            Object[] insertParam = null;
            for (Row row : ds) {
                if (row.getString("fid") == null || StringUtils.isEmpty((String)String.valueOf(row.getString("fid")))) continue;
                insertParam = new Object[]{row.getString("fid"), StringUtils.isEmpty((String)row.getString("fcountryid")) ? Integer.valueOf(0) : row.getString("fcountryid"), StringUtils.isEmpty((String)row.getString("fpostalcode")) ? " " : row.getString("fpostalcode"), StringUtils.isEmpty((String)row.getString("fphone")) ? " " : row.getString("fphone"), StringUtils.isEmpty((String)row.getString("ffax")) ? " " : row.getString("ffax"), StringUtils.isEmpty((String)row.getString("furl")) ? " " : row.getString("furl"), StringUtils.isEmpty((String)row.getString("fsocietycreditcode")) ? " " : row.getString("fsocietycreditcode"), StringUtils.isEmpty((String)row.getString("forgcode")) ? " " : row.getString("forgcode"), StringUtils.isEmpty((String)row.getString("fbizregisterno")) ? " " : row.getString("fbizregisterno"), StringUtils.isEmpty((String)row.getString("ftxregisterno")) ? " " : row.getString("ftxregisterno"), StringUtils.isEmpty((String)row.getString("finternalcompanyid")) ? Integer.valueOf(0) : row.getString("finternalcompanyid"), row.getString("festablishdate"), StringUtils.isEmpty((String)row.getString("fadmindivision")) ? " " : row.getString("fadmindivision")};
                insertParams.add(insertParam);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage());
        }
        if (insertParams.size() > 0) {
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)this.getCustomerBusSQlString(), insertParams);
            }
            catch (Exception e) {
                log.error("insert data fail.errorMsgInfo:" + e.getMessage());
            }
        }
    }

    private String getCustomerBusSQlString() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_CUSTOMER_B(FID,FCOUNTRYID,FPOSTALCODE,FPHONE,FFAX,FURL,FSOCIETYCREDITCODE,FORGCODE,FBIZREGISTERNO,FTXREGISTERNO,FINTERNALCOMPANYID,FESTABLISHDATE,FADMINDIVISION)  values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sql.toString();
    }
}

