/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.upgrade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamOperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterCache;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class InternalAccountSourceParamUpService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(InternalAccountSourceParamUpService.class);
    private static final String PARAM_KEY = "internalaccsource";
    private static final String CLOUD_ID = "0QLCSO6KKZC9";
    private static final String APP_ID = "0efa1992000000ac";
    private static final String ENTITY_NAME = "bd_basedata_parameter";
    private static final String CAS_APP_ID = "d2bb1733000000ac";
    private static final String FR_APP_ID = "0XINV40+SS9N";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            AppParam appParam;
            ParamOperationResult res;
            Row row;
            result.setLog("InternalAccountSourceParamUpService upgrade - start");
            DBRoute dbRoute = new DBRoute("sys");
            DataSet paramConsole = this.getSystemConsole(APP_ID);
            String paramId = null;
            Iterator iterator = paramConsole.iterator();
            while (iterator.hasNext() && (paramId = (row = (Row)iterator.next()).getString("fid")) == null) {
            }
            if (StringUtils.isEmpty(paramId)) {
                result.setSuccess(false);
                result.setLog("InternalAccountSourceParamUpService upgrade error, not publish param entity!");
                return result;
            }
            List<String> internalAccountSourceList = Arrays.asList("1", "2", "3");
            Map<Long, String> bdSystemParamMap = this.getSystemParams(APP_ID);
            Map<Long, String> casSystemParamMap = this.getSystemParams(CAS_APP_ID);
            Map<Long, String> frSystemParamMap = this.getSystemParams(FR_APP_ID);
            DynamicObject initSysData = null;
            long bdNotExistOrgId = casSystemParamMap.keySet().stream().filter(orgId -> !bdSystemParamMap.containsKey(orgId)).findAny().orElseGet(() -> 0L);
            if (bdNotExistOrgId == 0L) {
                bdNotExistOrgId = frSystemParamMap.keySet().stream().filter(orgId -> !bdSystemParamMap.containsKey(orgId)).findAny().orElseGet(() -> 0L);
            }
            if (bdNotExistOrgId != 0L && (res = SystemParamServiceHelper.saveAppParameter((AppParam)(appParam = new AppParam(APP_ID, "15", Long.valueOf(bdNotExistOrgId), Long.valueOf(0L))), new HashMap(8))).isSuccess()) {
                QFilter qFilter = new QFilter("forgid", "=", (Object)bdNotExistOrgId);
                qFilter.and(new QFilter("fparamid", "=", (Object)paramId));
                qFilter.and(new QFilter("fviewtypeid", "=", (Object)"15"));
                initSysData = BusinessDataServiceHelper.loadSingle((String)"bos_svc_sysparameter", (QFilter[])qFilter.toArray());
            }
            ArrayList<Object[]> batchAddParam = new ArrayList<Object[]>(10);
            ArrayList<Object[]> batchUpdateParam = new ArrayList<Object[]>(10);
            Map<Long, String> orgIdAndInternalAccSourceMap = this.getOrgInternalAccSourceValue(casSystemParamMap, frSystemParamMap);
            if (orgIdAndInternalAccSourceMap.size() > 0) {
                for (Map.Entry<Long, String> entry : orgIdAndInternalAccSourceMap.entrySet()) {
                    JSONObject dataJsonObj;
                    long orgId2 = entry.getKey();
                    String internalAccSource = entry.getValue();
                    String bdData = bdSystemParamMap.get(orgId2);
                    boolean isNew = StringUtils.isEmpty((CharSequence)bdData);
                    if (isNew) {
                        if (initSysData == null) continue;
                        String paramData = initSysData.getString("fdata");
                        JSONObject jSONObject = dataJsonObj = StringUtils.isNotEmpty((CharSequence)paramData) ? JSON.parseObject((String)paramData) : null;
                        if (dataJsonObj != null && initSysData.getLong("forgid") == orgId2) {
                            dataJsonObj.put(PARAM_KEY, (Object)internalAccSource);
                            batchUpdateParam.add(new Object[]{JSON.toJSONString((Object)dataJsonObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), paramId, orgId2, "15"});
                            continue;
                        }
                    } else {
                        dataJsonObj = JSON.parseObject((String)bdData);
                    }
                    if (dataJsonObj == null) continue;
                    String paramVal = dataJsonObj.getString(PARAM_KEY);
                    if (!isNew && StringUtils.isNotEmpty((CharSequence)paramVal) && internalAccountSourceList.contains(paramVal)) continue;
                    dataJsonObj.put(PARAM_KEY, (Object)internalAccSource);
                    String newParamJsonStr = JSON.toJSONString((Object)dataJsonObj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                    if (isNew) {
                        batchAddParam.add(new Object[]{Uuid16.create().toString(), paramId, orgId2, "15", initSysData.get("facctbookid"), initSysData.get("facctingbookid"), newParamJsonStr});
                        continue;
                    }
                    batchUpdateParam.add(new Object[]{newParamJsonStr, paramId, orgId2, "15"});
                }
            }
            logger.info(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u5386\u53f2\u6570\u636e\u5347\u7ea7\u8bb0\u5f55\u6570\uff1a\u51fa\u7eb3\uff1a%1$s\uff0c\u8d22\u52a1\u62a5\u8d26\uff1a%2$s\u3002", (String)"InternalAccountSourceParamUpService_0", (String)"bd-master-mservice", (Object[])new Object[]{batchAddParam.size(), batchUpdateParam.size()}));
            if (batchAddParam.size() > 0) {
                String addSql = "INSERT INTO T_BAS_SYSPARAMETER (FID, FPARAMID, FORGID, FVIEWTYPEID, FACCTBOOKID, FACCTINGBOOKID, FDATA) VALUES (?, ?, ?, ?, ?, ?, ?)";
                DB.executeBatch((DBRoute)dbRoute, (String)addSql, batchAddParam);
            }
            if (batchUpdateParam.size() > 0) {
                String updateSql = "UPDATE T_BAS_SYSPARAMETER SET FDATA = ? WHERE FPARAMID = ? AND FORGID = ? AND FVIEWTYPEID = ?";
                DB.executeBatch((DBRoute)dbRoute, (String)updateSql, batchUpdateParam);
            }
            ParameterCache.removeParameter((String)CLOUD_ID, (String)APP_ID);
            ParameterCache.removeBatchParameter((String)CLOUD_ID, (String)APP_ID);
            result.setLog("InternalAccountSourceParamUpService upgrade - end");
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.info("InternalAccountSourceParamUpService upgrade error!", (Object)e);
        }
        return result;
    }

    private Map<Long, String> getSystemParams(String appId) {
        long start = System.currentTimeMillis();
        DBRoute dbRoute = new DBRoute("sys");
        String selectSql = "select forgid, fdata from t_bas_sysparameter a inner join t_bas_sysparaconsole b on a.fparamid = b.fid where b.fappid = ? and b.fenabled = ?";
        Object[] params = new Object[]{appId, "1"};
        HashMap<Long, String> dataMap = new HashMap<Long, String>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"InternalAccountSourceParamUpService_QuerySysParameter", (DBRoute)dbRoute, (String)selectSql, (Object[])params);){
            for (Row row : queryDataSet) {
                String data = row.getString("fdata");
                Long orgId = row.getLong("forgid");
                if (!StringUtils.isNotEmpty((CharSequence)data) || orgId == null || orgId == 0L) continue;
                dataMap.put(orgId, data);
            }
        }
        long end = System.currentTimeMillis();
        logger.info("---\u8bb0\u5f55\u672c\u6b21\u83b7\u53d6\u5168\u90e8\u53c2\u6570\u7684\u65f6\u95f4\uff0c\u7ec4\u7ec7\u6570\u91cf\uff1a{},\u65f6\u95f4\uff1a{}" + dataMap.size(), (Object)(end - start));
        return dataMap;
    }

    private DataSet getSystemConsole(String appId) {
        DBRoute dbRoute = new DBRoute("sys");
        String selectSql = "select fid from t_bas_sysparaconsole where fappid = ? and fenabled = ?";
        Object[] params = new Object[]{appId, "1"};
        return DB.queryDataSet((String)"InternalAccountSourceParamUpService_GetSystemConsole", (DBRoute)dbRoute, (String)selectSql, (Object[])params);
    }

    private Map<Long, String> getOrgInternalAccSourceValue(Map<Long, String> casSystemParamMap, Map<Long, String> frSystemParamMap) {
        HashMap<Long, String> orgIdAndInternalAccSourceMap = new HashMap<Long, String>(64);
        Set allOrgIdSet = Stream.concat(casSystemParamMap.keySet().stream(), frSystemParamMap.keySet().stream()).collect(Collectors.toSet());
        for (Long orgId : allOrgIdSet) {
            String casParamData = casSystemParamMap.get(orgId);
            String frParamData = frSystemParamMap.get(orgId);
            String paramVal = "2";
            if (StringUtils.isNotEmpty((CharSequence)casParamData)) {
                JSONObject casDataJsonObj = JSON.parseObject((String)casParamData);
                if (casDataJsonObj != null) {
                    if (StringUtils.equals((CharSequence)casDataJsonObj.getString("cs126"), (CharSequence)"3")) {
                        paramVal = "3";
                    } else if (StringUtils.equals((CharSequence)casDataJsonObj.getString("cs126"), (CharSequence)"1")) {
                        JSONObject frDataJsonObj;
                        JSONObject jSONObject = frDataJsonObj = StringUtils.isNotEmpty((CharSequence)frParamData) ? JSON.parseObject((String)frParamData) : null;
                        if (frDataJsonObj == null || !frDataJsonObj.containsKey((Object)"bankaccountsource") || StringUtils.equals((CharSequence)frDataJsonObj.getString("bankaccountsource"), (CharSequence)"bankaccount")) {
                            paramVal = "1";
                        }
                    }
                }
            } else if (StringUtils.isNotEmpty((CharSequence)frParamData)) {
                JSONObject frDataJsonObj;
                JSONObject jSONObject = frDataJsonObj = StringUtils.isNotEmpty((CharSequence)frParamData) ? JSON.parseObject((String)frParamData) : null;
                if (frDataJsonObj != null && StringUtils.equals((CharSequence)frDataJsonObj.getString("bankaccountsource"), (CharSequence)"bankaccount")) {
                    paramVal = "1";
                }
            }
            orgIdAndInternalAccSourceMap.put(orgId, paramVal);
        }
        return orgIdAndInternalAccSourceMap;
    }
}

