/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.formplugin.er.daily;

import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.assistant.er.util.ErReimburseSettingUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ErReimburseSettingListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ErReimburseSettingListPlugin.class);
    private static final String USEORG_FILEDNAME = "useorg.id";
    private static final String USEORG_FILEDNUMBER = "useorg.number";
    private static final String ER_REIMBURSESETTING = "er_reimbursesetting";
    private static final String DPT_ID = "dpt_id";
    private static final String ALGO_KEY = ErReimburseSettingListPlugin.class.getName();
    private Map<Long, Map<Long, Object>> reimburseLevel;
    private Map<Long, Map<String, Object>> companyMap;
    private Set<Object> permReimburseLevelSet = new HashSet<Object>(16);
    private long milliseconds = 0L;
    private long milliseconds_begin = 0L;
    private boolean analyzebtn = false;
    private List<String> logLst = new ArrayList<String>();

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("analyzebtn".equals(itemKey)) {
            OperateOption p1 = OperateOption.create();
            p1.setVariableValue("analyzebtn", "true");
            this.milliseconds_begin = this.milliseconds = System.currentTimeMillis();
            this.getView().invokeOperation("refresh", p1);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Refresh refresh;
        OperateOption option;
        Map variables;
        String variableValue;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Refresh && (variableValue = (String)(variables = (option = (refresh = (Refresh)source).getOption()).getVariables()).get("analyzebtn")) != null) {
            this.analyzebtn = true;
        }
    }

    private void addLog(String msg) {
        if (this.analyzebtn) {
            long currentTimeMillis = System.currentTimeMillis();
            this.logLst.add(msg + ": " + (currentTimeMillis - this.milliseconds) + "ms");
            this.milliseconds = currentTimeMillis;
        }
    }

    private void addLog2(String msg) {
        if (this.analyzebtn) {
            this.logLst.add(msg);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (this.analyzebtn) {
            try {
                this.addLog("END");
                this.addLog2("TOTAL COST: " + (System.currentTimeMillis() - this.milliseconds_begin) + "ms");
                String content = this.logLst.stream().collect(Collectors.joining("\r\n"));
                String appNumberFile = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("logfile.log", content.getBytes("utf-8"), 5000);
                this.getView().openUrl(appNumberFile);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                ErReimburseSettingListPlugin.this.addLog("getData - begin");
                DynamicObjectCollection collection = super.getData(arg0, arg1);
                ErReimburseSettingListPlugin.this.addLog("getData - step1");
                ArrayList users = new ArrayList();
                collection.forEach(v -> users.add((Long)v.getPkValue()));
                if (!users.isEmpty()) {
                    ErReimburseSettingListPlugin.this.reimburseLevel = ErReimburseSettingUtil.getReimburseLevel(users, v -> v.getDynamicObject("reimburselevel").get("name"));
                }
                ErReimburseSettingListPlugin.this.addLog("getData - step2");
                HashSet<Long> dptIds = new HashSet<Long>();
                for (DynamicObject coll : collection) {
                    if (coll.getDynamicObjectType().getProperty(ErReimburseSettingListPlugin.DPT_ID) == null) continue;
                    long dptId = coll.getLong(ErReimburseSettingListPlugin.DPT_ID);
                    dptIds.add(dptId);
                }
                Map companyOfOrg = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getCompanyOfOrg((Object)1L, dptIds);
                ErReimburseSettingListPlugin.this.addLog("getData - step3");
                ErReimburseSettingListPlugin.this.companyMap = new HashMap(collection.size());
                for (Map.Entry mapEntry : companyOfOrg.entrySet()) {
                    long dptId = (Long)mapEntry.getKey();
                    Map companyfromOrg = (Map)mapEntry.getValue();
                    ErReimburseSettingListPlugin.this.companyMap.put(dptId, companyfromOrg);
                }
                ErReimburseSettingListPlugin.this.addLog("getData - step4");
                return collection;
            }
        });
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (e.getSource() instanceof ColumnDesc) {
            Map<String, Object> companyfromOrg;
            ColumnDesc columnDesc = (ColumnDesc)e.getSource();
            if (e.getRowData().getDynamicObjectType().getProperty(DPT_ID) == null) {
                return;
            }
            Object deptId = e.getRowData().get(DPT_ID);
            if (deptId != null && (Long)deptId != 0L && this.companyMap != null && (companyfromOrg = this.companyMap.get(deptId)) != null) {
                Map<Long, Object> map;
                if ("companytmp.name".equals(columnDesc.getKey()) && e.getRowData().getDynamicObjectType().getProperty(DPT_ID) != null) {
                    e.setFormatValue(companyfromOrg.getOrDefault("name", ""));
                } else if ("reimburseleveltmp.name".equals(columnDesc.getKey()) && e.getRowData().getDynamicObjectType().getProperty(DPT_ID) != null && this.reimburseLevel != null && (map = this.reimburseLevel.get(e.getRowData().getPkValue())) != null) {
                    e.setFormatValue(map.get(companyfromOrg.getOrDefault("id", "")));
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String isUpdateKey = "updateFromT_sec_user";
        String isUpdate = this.getPageCache().get(isUpdateKey);
        if ("true".equals(isUpdate)) {
            return;
        }
        List idList = (List)DB.query((DBRoute)DBRoute.base, (String)"select fid from t_sec_user where fid not in (select fid from t_sec_user_e)", (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> list = new ArrayList<Object[]>(2);
                while (rs.next()) {
                    list.add(new Object[]{rs.getLong("fid")});
                }
                return list;
            }
        });
        if (idList != null && !idList.isEmpty()) {
            String insertSql = "insert into t_sec_user_e (fid, fauditstatus) values (?, 'A')";
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, (List)idList);
        }
        log.info("\u4ecet_sec_user\u8868\u540c\u6b65\u5230t_sec_user_e\u8868\u4e2d\u7684\u4eba\u5458\u6570\u91cf\u6709:" + (idList == null ? 0 : idList.size()));
        this.getPageCache().put(isUpdateKey, "true");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Object dynamicObject;
        this.addLog("filterContainerInit begin");
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u516c\u53f8", (String)"ErReimburseSettingListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0])));
        orgColumn.setFieldName(USEORG_FILEDNAME);
        orgColumn.setParentViewKey("filtergridview");
        orgColumn.setView(this.getView());
        orgColumn.setEntityType(MetadataServiceHelper.getDataEntityType((String)ER_REIMBURSESETTING));
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        orgColumn.setContext(filterContainer.getContext());
        this.addLog("filterContainerInit - before getCompanyDOsWithQueryPerm");
        List<DynamicObject> col = this.getCompanyDOsWithQueryPerm();
        this.addLog("filterContainerInit - after getCompanyDOsWithQueryPerm");
        this.addLog2("col.size: " + col.size());
        if (filterColumnList.contains(orgColumn)) {
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(col.size() + 1);
        ComboItem notLimit = new ComboItem();
        notLimit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ErReimburseSettingListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0])));
        notLimit.setValue("");
        combos.add(notLimit);
        String chooseValue = "";
        if (RequestContext.get().getOrgId() != 0L && ((Optional)(dynamicObject = col.stream().filter(Objects::nonNull).filter(it -> String.valueOf(RequestContext.get().getOrgId()).equals(String.valueOf(it.getPkValue()))).findFirst())).isPresent()) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(((DynamicObject)((Optional)dynamicObject).get()).getString("name")));
            item.setValue(String.valueOf(((DynamicObject)((Optional)dynamicObject).get()).getPkValue()));
            chooseValue = String.valueOf(((DynamicObject)((Optional)dynamicObject).get()).getPkValue());
            combos.add(item);
        }
        for (DynamicObject org : col) {
            if (org == null || chooseValue.equals(String.valueOf(org.getPkValue()))) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            item.setValue(String.valueOf(org.getPkValue()));
            combos.add(item);
        }
        orgColumn.setType("text");
        filterColumnList.add(0, orgColumn);
        String defaultCompanyId = "";
        if (!combos.isEmpty() && combos.size() > 1) {
            defaultCompanyId = ((ComboItem)combos.get(1)).getValue();
        }
        orgColumn.addSetFilterListeners(listener -> listener.addCustomQFilter(new QFilter("id", "in", col.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()))));
        orgColumn.initProperties();
        orgColumn.setDefaultValue(defaultCompanyId);
        this.addLog("filterContainerInit end");
    }

    public void filterColumnSetFilter(SetFilterEvent event) {
        String fieldName = event.getFieldName();
        if ("reimburselevel.name".equals(fieldName)) {
            String companyIdStr;
            FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
            ControlFilter controlFilter = (ControlFilter)filterContainer.getContext().getControlFiltersMap().get(USEORG_FILEDNAME);
            List value = null;
            if (controlFilter != null && (value = controlFilter.getValue()) != null && !value.isEmpty() && StringUtils.isNotBlank((CharSequence)(companyIdStr = value.get(0).toString()))) {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", (Long)Long.valueOf(companyIdStr));
                event.getQFilters().add(baseDataFilter);
                List queryPrimaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"er_reimburselevel", (QFilter[])new QFilter[]{baseDataFilter}, (String)"id", (int)10000);
                this.permReimburseLevelSet.addAll(queryPrimaryKeys);
                return;
            }
            List<DynamicObject> col = this.getCompanyDOsWithQueryPerm();
            List preOrgIds = col.stream().filter(Objects::nonNull).map(org -> org.getLong("id")).collect(Collectors.toList());
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", preOrgIds, (boolean)true);
            if (baseDataFilter != null) {
                event.getQFilters().add(baseDataFilter);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7528\u6237\u6388\u6743\u7ec4\u7ec7\u7684\u7ec4\u7ec7\u5f62\u6001\u4e0d\u662f\u6cd5\u4eba\u673a\u6784\uff0c\u62a5\u9500\u7ea7\u522b\u8bbe\u7f6e\u529f\u80fd\u65e0\u6cd5\u4f7f\u7528\u3002", (String)"ErReimburseSettingListPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageTypes.Default, new ConfirmCallBackListener("ok", (IFormPlugin)this));
            }
            this.addLog(baseDataFilter != null ? baseDataFilter.toString() : "null");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("ok".equals(callBackId)) {
            this.getView().close();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object reimburseLevelVal = args.getFilterValue("reimburselevel.id");
        Object useorgVal = args.getFilterValue(USEORG_FILEDNAME);
        args.getFilterParameter().getSelectFields();
        if (reimburseLevelVal != null && useorgVal != null && !this.permReimburseLevelSet.contains(reimburseLevelVal)) {
            ((List)args.getFilterValues().get("customfilter")).removeIf(t -> ((List)t.get("FieldName")).get(0).equals("reimburselevel.id"));
        }
        super.filterContainerSearchClick(args);
    }

    public void setFilter(SetFilterEvent e) {
        this.addLog("setFilter begin");
        QFilter qFilter = QFilter.of((String)" enable = '1' ", (Object[])new Object[0]);
        e.getQFilters().add(qFilter);
        ArrayList<Object> reimburseLevelId = new ArrayList<Object>();
        Optional<QFilter> reimburselevelFilter = e.getQFilters().stream().filter(f -> f != null).filter(f -> "reimburselevel.id".equals(f.getProperty())).findFirst();
        if (reimburselevelFilter.isPresent()) {
            Object value = reimburselevelFilter.get().getValue();
            if (value instanceof Long) {
                reimburseLevelId.add(value);
            }
            if (value instanceof List) {
                reimburseLevelId.addAll((Collection)value);
            }
        }
        Iterator iterator = e.getQFilters().iterator();
        boolean flag = false;
        boolean notin = false;
        boolean notEmpty = false;
        boolean empty = false;
        while (iterator.hasNext()) {
            List<Long> allOrgList;
            QFilter filter = (QFilter)iterator.next();
            String property = filter.getProperty();
            if ("number".equals(property)) {
                this.getPageCache().put("useorg", null);
                continue;
            }
            ArrayList add = new ArrayList(){
                {
                    this.add("not in");
                    this.add("<>");
                }
            };
            if ("reimburselevel.name".equals(property) && "is not null".equals(filter.getCP())) {
                notEmpty = true;
            }
            if (property.equals("reimburselevel.id") && add.contains(filter.getCP())) {
                notin = true;
            }
            if ("reimburselevel.name".equals(property) && filter.getValue() != null && filter.getValue().toString().equalsIgnoreCase("EMPTY")) {
                empty = true;
            }
            String cp = filter.getCP();
            String value = "";
            if (filter.getValue() != null) {
                value = filter.getValue().toString();
            }
            DynamicObject orgObject = null;
            if (StringUtils.equalsAny((CharSequence)property, (CharSequence[])new CharSequence[]{USEORG_FILEDNAME, "useorg", USEORG_FILEDNUMBER, "useorg.name"})) {
                iterator.remove();
                String queryProp = property.replace("useorg", "org");
                if ("org".equals(queryProp)) {
                    queryProp = "org.id";
                }
                QFilter qFitler = new QFilter(queryProp, filter.getCP(), filter.getValue());
                orgObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber,org", (QFilter[])new QFilter[]{qFitler});
            } else if ("reimburselevel.id".equals(property)) {
                iterator.remove();
            } else if ("reimburselevel.name".equals(property)) {
                iterator.remove();
            }
            if (null == orgObject) continue;
            long rootOrgId = orgObject.getLong("org.id");
            String rootOrgIdKey = "rootOrgId:" + rootOrgId;
            String allOrgStr = this.getPageCache().get(rootOrgIdKey);
            if (StringUtils.isNotBlank((CharSequence)allOrgStr)) {
                allOrgList = JSONArray.parseArray((String)allOrgStr, Long.class);
            } else {
                ArrayList<Long> selectOrgList = new ArrayList<Long>();
                selectOrgList.add(orgObject.getLong("org.id"));
                allOrgList = this.getAllSubOrgsNotSubCompany(selectOrgList);
                this.getPageCache().put(rootOrgIdKey, JSONArray.toJSONString(allOrgList));
            }
            if (allOrgList.isEmpty()) continue;
            QFilter q1 = new QFilter("entryentity.dpt.id", "in", (Object)allOrgList);
            DynamicObjectCollection userDOs = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{q1});
            Set userSet = userDOs.stream().map(userDO -> userDO.getLong("id")).collect(Collectors.toSet());
            log.info("unresolve UserSet>>>>" + userSet.toString());
            DynamicObjectCollection userCollection = null;
            if (reimburselevelFilter.isPresent()) {
                userCollection = QueryServiceHelper.query((String)"er_reimbursesetting_rel", (String)"user,company", (QFilter[])new QFilter[]{new QFilter("company", "in", allOrgList), new QFilter("user", "in", userSet), notin ? new QFilter("reimburselevel", "not in", reimburseLevelId) : new QFilter("reimburselevel", "in", reimburseLevelId)});
            }
            if (notEmpty || empty) {
                userCollection = QueryServiceHelper.query((String)"er_reimbursesetting_rel", (String)"user,company", (QFilter[])new QFilter[0]);
            }
            if (!userSet.isEmpty()) {
                QFilter userFilter = null;
                userFilter = userCollection == null ? new QFilter("id", "in", userSet) : (empty ? new QFilter("id", "not in", this.removeNotInOffice(userCollection)) : new QFilter("id", "in", this.removeNotInOffice(userCollection)));
                e.getQFilters().add(userFilter);
                flag = true;
                break;
            }
            QFilter userFilter = QFilter.of((String)"1!=?", (Object[])new Object[]{1});
            e.getQFilters().add(userFilter);
            flag = true;
            break;
        }
        this.addLog("setFilter step1");
        if (!flag) {
            DynamicObjectCollection userCollection;
            if (reimburseLevelId.size() > 0) {
                userCollection = QueryServiceHelper.query((String)"er_reimbursesetting_rel", (String)"user,company", (QFilter[])new QFilter[]{new QFilter("reimburselevel", "in", reimburseLevelId)});
                if (notin) {
                    e.getQFilters().add(new QFilter("id", "not in", this.removeNotInOffice(userCollection)));
                } else {
                    e.getQFilters().add(new QFilter("id", "in", this.removeNotInOffice(userCollection)));
                }
            }
            if (notEmpty) {
                userCollection = QueryServiceHelper.query((String)"er_reimbursesetting_rel", (String)"user,company", (QFilter[])new QFilter[0]);
                e.getQFilters().add(new QFilter("id", "in", this.removeNotInOffice(userCollection)));
            }
            if (empty) {
                userCollection = QueryServiceHelper.query((String)"er_reimbursesetting_rel", (String)"user,company", (QFilter[])new QFilter[0]);
                e.getQFilters().add(new QFilter("id", "not in", this.removeNotInOffice(userCollection)));
            }
        }
        e.setOrderBy("id");
        log.info("Final Filter>>>>" + e.getQFilters().toString());
        this.addLog2(e.getQFilters().toString());
        this.addLog("setFilter end");
    }

    private Set<Long> removeNotInOffice(DynamicObjectCollection collection) {
        HashMap<Long, ArrayList<Long>> employeeWithDpt = new HashMap<Long, ArrayList<Long>>(collection.size());
        for (int startIdx = 0; startIdx < collection.size(); ++startIdx) {
            DynamicObject row = (DynamicObject)collection.get(startIdx);
            Long user2 = row.getLong("user");
            Long company = row.getLong("company");
            ArrayList<Long> dpts = (ArrayList<Long>)employeeWithDpt.get(user2);
            if (dpts == null) {
                dpts = new ArrayList<Long>(Collections.singletonList(company));
            } else {
                dpts.add(company);
            }
            employeeWithDpt.put(user2, dpts);
        }
        DynamicObject[] userDOs = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,entryentity.dpt", (QFilter[])new QFilter[]{new QFilter("id", "in", employeeWithDpt.keySet())});
        return Arrays.stream(userDOs).filter(user -> {
            List dptsInOffice;
            List dpts = (List)employeeWithDpt.get(user.getLong("id"));
            return CollectionUtils.intersection((Iterable)dpts, dptsInOffice = user.getDynamicObjectCollection("entryentity").stream().map(e -> OrgUnitServiceHelper.getCompanyfromOrg((Long)((Long)e.getDynamicObject("dpt").getPkValue())).getOrDefault("id", 0L)).collect(Collectors.toList())).size() > 0;
        }).map(user -> (Long)user.getPkValue()).collect(Collectors.toSet());
    }

    private List<Long> getAllSubOrgsNotSubCompany(List<Long> orgs) {
        Long orgViewType = 1L;
        List allSubOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)orgViewType, orgs, (boolean)true);
        allSubOrgs.removeAll(orgs);
        QFilter idQFilter = new QFilter("id", "in", (Object)allSubOrgs);
        QFilter companyQFilter = new QFilter("orgpattern.patterntype", "in", Arrays.asList("1", "2"));
        DynamicObject[] companyDOs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{idQFilter, companyQFilter});
        List companySubOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)orgViewType, Arrays.stream(companyDOs).map(company -> (Long)company.getPkValue()).collect(Collectors.toList()), (boolean)true);
        allSubOrgs.removeAll(companySubOrgs);
        allSubOrgs.addAll(orgs);
        return allSubOrgs;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)USEORG_FILEDNAME)) {
            List qfilters = args.getQfilters();
            qfilters.add(new QFilter("orgpattern.patterntype", "in", Arrays.asList("1", "2")));
            List<DynamicObject> col = this.getCompanyDOsWithQueryPerm();
            qfilters.add(new QFilter("id", "in", col.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList())));
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"reimburselevel.name")) {
            String companyIdStr;
            FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
            ControlFilter controlFilter = (ControlFilter)filterContainer.getContext().getControlFiltersMap().get(USEORG_FILEDNAME);
            List value = null;
            if (controlFilter != null && (value = controlFilter.getValue()) != null && !value.isEmpty() && StringUtils.isNotBlank((CharSequence)(companyIdStr = value.get(0).toString()))) {
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_reimburselevel", (Long)Long.valueOf(companyIdStr));
                args.getQfilters().add(baseDataFilter);
            }
        }
    }

    private List<DynamicObject> getCompanyDOsWithQueryPerm() {
        return this.getCompanysWithQueryPerm(this.getView().getFormShowParameter().getAppId());
    }

    private List<Long> getCompanyIdsWithQueryPerm(HasPermOrgResult allPermResult) {
        List orgsList = allPermResult.getHasPermOrgs();
        QFilter patterntypeFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bos_org", (String)"id", (QFilter[])new QFilter[]{patterntypeFilter}, null);){
            for (Row row : ds) {
                Long orgId = row.getLong("id");
                if (!orgsList.contains(orgId)) continue;
                result.add(orgId);
            }
        }
        return result;
    }

    private List<DynamicObject> getCompanysWithQueryPerm(String appId) {
        ArrayList<DynamicObject> companyDOs = new ArrayList<DynamicObject>();
        List<Long> orgs = this.getOrgsWithQueryPerm(appId);
        if (orgs.isEmpty()) {
            log.warn("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7528\u6237\u6709\u67e5\u8be2\u6743\u9650\u7684\u516c\u53f8");
            return companyDOs;
        }
        QFilter patterntypeFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
        Map companyDOArrays = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{patterntypeFilter});
        if (companyDOArrays == null || companyDOArrays.isEmpty()) {
            log.warn("\u672a\u67e5\u8be2\u5f53\u524d\u7528\u6237\u6709\u67e5\u8be2\u6743\u9650\u7684\u516c\u53f8");
            return companyDOs;
        }
        for (Map.Entry mapEntry : companyDOArrays.entrySet()) {
            if (!orgs.contains(mapEntry.getKey())) continue;
            companyDOs.add((DynamicObject)mapEntry.getValue());
        }
        return companyDOs;
    }

    private List<Long> getOrgsWithQueryPerm(String appId) {
        String permItemId = "47150e89000000ac";
        String userId = RequestContext.getOrCreate().getUserId();
        HasPermOrgResult allPermResult = PermissionServiceHelper.getAllPermOrgs((Long)Long.parseLong(userId), (String)appId, (String)ER_REIMBURSESETTING, (String)permItemId);
        List<Long> orgsList = Collections.emptyList();
        if (allPermResult.hasAllOrgPerm()) {
            orgsList = OrgUnitServiceHelper.getAllOrgByViewId((long)1L, (boolean)false);
        } else {
            orgsList = allPermResult.getHasPermOrgs();
            HasPermOrgResult adminorgsResult = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(userId), (String)"01", (String)appId, (String)ER_REIMBURSESETTING, (String)permItemId);
            if (!adminorgsResult.hasAllOrgPerm()) {
                List adminorgsList = adminorgsResult.getHasPermOrgs();
                if (orgsList != null) {
                    if (adminorgsList != null) {
                        orgsList.addAll(adminorgsList);
                    }
                } else {
                    orgsList = adminorgsList;
                }
            }
        }
        if (orgsList == null || orgsList.isEmpty()) {
            orgsList = new ArrayList<Long>();
            log.info(String.format("\u7528\u6237(%s)\u6709\u67e5\u8be2\u6743\u9650(%s)\u7684\u7ec4\u7ec7\u7ed3\u679c\u4e3a\u7a7a", userId, permItemId));
        }
        return orgsList;
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        this.queryReimburseLevelData(e);
    }

    protected void queryReimburseLevelData(AfterQueryOfExportEvent e) {
        DynamicObject[] queryValues = e.getQueryValues();
        List users = Stream.of(queryValues).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)ER_REIMBURSESETTING, (String)"entryentity.dpt,entryentity.ispartjob", (QFilter[])new QFilter[]{new QFilter("id", "in", users)});
        Map reimburseLevel = ErReimburseSettingUtil.getReimburseLevel(users, v -> v.getDynamicObject("reimburselevel"));
        HashMap exportData = new HashMap();
        HashMap companyMap = new HashMap();
        EntryProp reimlevelentryProp = (EntryProp)Arrays.stream(queryValues).findFirst().get().getDynamicObjectType().getProperties().get((Object)"reimlevelentry");
        OrgProp companyProp = (OrgProp)reimlevelentryProp.getDynamicCollectionItemPropertyType().getProperties().get((Object)"company");
        loadFromCache.values().stream().forEach(v -> {
            LinkedList valLst = new LinkedList();
            Map level = (Map)reimburseLevel.get((Long)v.getPkValue());
            exportData.put((Long)v.getPkValue(), valLst);
            DynamicObjectCollection deptEntries = v.getDynamicObjectCollection("entryentity");
            for (DynamicObject deptEntry : deptEntries) {
                Object companyId;
                Long dptId = deptEntry.getLong(DPT_ID);
                if (companyMap.get(dptId) == null) {
                    Map companyfromOrg = OrgUnitServiceHelper.getCompanyfromOrg((Long)dptId);
                    companyMap.put(dptId, companyfromOrg);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                Map companyValue = (Map)companyMap.get(dptId);
                if (companyValue != null && (companyId = companyValue.get("id")) != null) {
                    map.put("company", BusinessDataServiceHelper.loadSingle(companyId, (DynamicObjectType)companyProp.getDynamicComplexPropertyType()));
                    if (level != null) {
                        map.put("reimburselevel", level.get(companyId));
                    }
                }
                if (!deptEntry.getBoolean("ispartjob")) {
                    valLst.addFirst(map);
                    continue;
                }
                valLst.add(map);
            }
        });
        for (DynamicObject reimbursesetting : queryValues) {
            LinkedList linkedList = (LinkedList)exportData.get(reimbursesetting.getPkValue());
            DynamicObjectCollection reimlevelentry = reimbursesetting.getDynamicObjectCollection("reimlevelentry");
            DynamicObjectType type = reimlevelentry.getDynamicObjectType();
            HashMap<Object, DynamicObject> filterDuplicate = new HashMap<Object, DynamicObject>(linkedList.size());
            for (Map map : linkedList) {
                Object pk;
                DynamicObject company = (DynamicObject)map.get("company");
                if (company == null || (pk = filterDuplicate.get(company.getPkValue())) != null) continue;
                DynamicObject entry = (DynamicObject)type.createInstance();
                entry.set("company", (Object)company);
                entry.set("entryreimburselevel", map.get("reimburselevel"));
                reimlevelentry.add((Object)entry);
                filterDuplicate.put(company.getPkValue(), company);
            }
        }
    }
}

