/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BankAccountEditPlugin
extends AbstractBasePlugIn {
    private static final String BANKINTERFACE = "bankinterface";

    public void initialize() {
        super.initialize();
        this.initF7();
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        if (status == OperationStatus.ADDNEW) {
            model.setValue("opendate", (Object)new Date());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject bankAcct = model.getDataEntity();
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = parameter.getStatus();
        DynamicObjectCollection currency = bankAcct.getDynamicObjectCollection("currency");
        if (null != currency && currency.size() > 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultcurrency"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultcurrency"});
        }
        if (bankAcct.getBoolean("issetbankinterface") && this.getModel().getValue(BANKINTERFACE) != null) {
            ArrayList<ComboItem> bankVersionItems = new ArrayList<ComboItem>();
            String bankinterface = (String)this.getModel().getValue(BANKINTERFACE);
            String[] bankinterfaces = bankinterface.trim().split("#");
            if (bankinterfaces.length == 2) {
                bankinterface = bankinterfaces[0] + "  " + bankinterfaces[1];
            }
            ComboItem item = new ComboItem(new LocaleString(bankinterface), (String)this.getModel().getValue(BANKINTERFACE));
            bankVersionItems.add(item);
            ComboEdit bankVersion = (ComboEdit)this.getControl(BANKINTERFACE);
            bankVersion.setComboItems(bankVersionItems);
        }
        if (OperationStatus.VIEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "openorg": {
                this.companyChange(propValue);
                break;
            }
            case "bank": {
                this.bankChange(propValue);
                break;
            }
            case "currency": {
                this.currencyChange(propValue);
                break;
            }
            case "finorgtype": {
                this.finorgTypeChange(propValue);
                this.virtualEntryValueChanged(propValue);
                break;
            }
            case "defaultcurrency": {
                this.defCurrencyChange(propValue);
                break;
            }
        }
    }

    private void virtualEntryValueChanged(Object propValue) {
        if (StringUtils.isNotEmpty((String)propValue.toString()) && !"3".equals(propValue)) {
            this.getModel().deleteEntryData("virtualentity");
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("virtual_attachmentap");
            List attdata = attachmentPanel.getAttachmentData();
            attdata.forEach(map -> {
                String formId = map.get("entityNum").toString();
                Object pkId = map.get("billPkId");
                Object fileUid = map.get("uid");
                AttachmentServiceHelper.remove((String)formId, pkId, fileUid);
                attachmentPanel.remove(map);
            });
        }
    }

    private void finorgTypeChange(Object propValue) {
        this.getModel().setValue("bank", null);
        IDataModel model = this.getModel();
        String prop = propValue.toString();
        if (prop.equals("3") || prop.equals("1")) {
            model.setValue("acctstyle", (Object)"normal");
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate operate;
        String currencyIsReduce;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.equals("save") && StringUtils.isEmpty((String)(currencyIsReduce = (String)(operate = (FormOperate)args.getSource()).getOption().getVariables().getOrDefault("currencyIsReduce", null)))) {
            this.getView().updateView("defaultcurrency");
            this.getView().updateView("currency");
        }
    }

    private void currencyChange(Object propValue) {
        DynamicObjectCollection currencys = (DynamicObjectCollection)propValue;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int len = currencys.size();
        if (len != 0) {
            DynamicObject currency = (DynamicObject)currencys.get(0);
            model.setValue("defaultcurrency", (Object)((Long)((DataEntityBase)currency.get("fbasedataid")).getPkValue()));
        }
        if (len <= 1) {
            view.setVisible(Boolean.FALSE, new String[]{"defaultcurrency"});
            model.setValue("ismulcurrency", (Object)Boolean.FALSE);
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"defaultcurrency"});
            model.setValue("ismulcurrency", (Object)Boolean.TRUE);
        }
    }

    private void defCurrencyChange(Object propValue) {
        IDataModel model = this.getModel();
        if (!Objects.isNull(propValue)) {
            DynamicObject defCurrency = (DynamicObject)propValue;
            model.setValue("managecurrency", defCurrency.getPkValue());
        }
    }

    private void companyChange(Object propValue) {
    }

    private void bankChange(Object propValue) {
        if (!Objects.isNull(propValue)) {
            DynamicObject bancAcct = (DynamicObject)propValue;
            DynamicObject finOrgType = bancAcct.getDynamicObject("finorgtype");
            finOrgType = QueryServiceHelper.queryOne((String)"bd_finorgtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "in", finOrgType.getPkValue())});
            this.getModel().setValue("finorgtype", finOrgType.get("type"));
        }
    }

    private void initF7() {
        BasedataEdit defaultCurrencyF7 = (BasedataEdit)this.getControl("defaultcurrency");
        defaultCurrencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection currencyCol = (DynamicObjectCollection)this.getModel().getValue("currency");
            HashSet<Long> currencyIDs = new HashSet<Long>();
            for (DynamicObject prop : currencyCol) {
                currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
            }
            QFilter qFilter = new QFilter("id", "in", currencyIDs);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        BasedataEdit bankF7 = (BasedataEdit)this.getControl("bank");
        bankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String finOrgType = Objects.toString(this.getModel().getValue("finorgtype"));
            QFilter qFilter = new QFilter("finorgtype.type", "in", (Object)finOrgType);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bank = (BasedataEdit)this.getControl("bank");
        String finOrgType = Objects.toString(this.getModel().getValue("finorgtype"));
        bank.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            beforeF7SelectEvent.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "resin"));
            if (finOrgType.equals("0")) {
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("resin", (Object)Boolean.FALSE);
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (null != returnData) {
            if (returnData instanceof JSONArray) {
                DynamicObject bank = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bebank", "in", ((JSONArray)returnData).get(0))});
                if (null != bank) {
                    this.getModel().setValue("bank", bank.get("id"));
                }
            } else if (returnData instanceof ListSelectedRowCollection) {
                this.getModel().setValue("bank", ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue());
            }
        }
    }
}

