/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bd.assistant.plugin.basedata.AbstractFinTreeListPlugin;
import kd.bd.assistant.plugin.helper.CountryHelper;
import kd.bd.assistant.plugin.model.TreeNodeModel;
import kd.bd.assistant.plugin.model.TreeNodeRefModel;
import kd.bd.assistant.plugin.model.TreeNodeTypeModel;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FinOrgResInTreeListPlugin
extends AbstractFinTreeListPlugin {
    public static final String KEY_COUNTRYNUM = "KEY_COUNTRYNUM";
    public static final String PONIT_NAME = ".name";
    public static final String PONIT_NUMBER = ".number";
    protected static final TreeNodeTypeModel NODE_COUNTRY = new TreeNodeTypeModel("country", TreeNodeTypeModel.ROOT, TreeNodeTypeModel.LeafMode.NON_LEAF);
    protected static final TreeNodeTypeModel NODE_PROVINCE = new TreeNodeTypeModel("province", NODE_COUNTRY, TreeNodeTypeModel.LeafMode.NON_LEAF);
    protected static final TreeNodeTypeModel NODE_CITY = new TreeNodeTypeModel("city", NODE_PROVINCE, TreeNodeTypeModel.LeafMode.LEAF);

    @Override
    protected List<TreeNodeTypeModel> getTreeNodeTypeList() {
        return Arrays.asList(NODE_COUNTRY, NODE_PROVINCE, NODE_CITY);
    }

    @Override
    protected List<TreeNodeRefModel> loadTreeNodeList(TreeNodeModel currNode) {
        List<TreeNodeRefModel> modelList = null;
        TreeNodeTypeModel nodeType = currNode.getNodeType();
        if (TreeNodeTypeModel.ROOT.equals((Object)nodeType)) {
            modelList = this.loadBankCountryData();
        } else if (NODE_COUNTRY.equals((Object)nodeType) || NODE_PROVINCE.equals((Object)nodeType)) {
            modelList = this.loadBankAdminDivisionData(currNode);
        }
        return modelList;
    }

    @Override
    protected QFilter getBillListFilter(TreeNodeModel currNode) {
        QFilter filter = null;
        TreeNodeTypeModel nodeType = currNode.getNodeType();
        Object refId = currNode.getRefEntityPkValue();
        if (NODE_COUNTRY.equals((Object)nodeType)) {
            filter = this.getCountryFiler(refId);
        } else if (NODE_PROVINCE.equals((Object)nodeType)) {
            filter = this.getProvinceFilter(refId);
        } else if (NODE_CITY.equals((Object)nodeType)) {
            filter = this.getCityFilter(refId);
        }
        return filter;
    }

    private List<TreeNodeRefModel> loadFinTreeNodeList(String idField, String nameField, String numberField, TreeNodeTypeModel nodeType, QFilter[] qFilters, DatasetIteratorCallback callback) {
        ArrayList<TreeNodeRefModel> modelList = new ArrayList<TreeNodeRefModel>();
        StringBuilder selectFieldStr = new StringBuilder(idField);
        ArrayList<String> groupByList = new ArrayList<String>(Collections.singletonList(idField));
        if (nameField != null) {
            selectFieldStr.append(',').append(nameField);
            groupByList.add(nameField);
        }
        if (numberField != null) {
            selectFieldStr.append(',').append(numberField);
            groupByList.add(numberField);
        }
        GroupbyDataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_bebank", (String)selectFieldStr.toString(), (QFilter[])qFilters, (String)idField).groupBy(groupByList.toArray(new String[0]));
        DataSet result = ds.finish();
        for (Row row : result) {
            TreeNodeRefModel refModel = new TreeNodeRefModel();
            refModel.setNodeName(row.getString(nameField == null ? idField : nameField));
            refModel.setNodeType(nodeType);
            refModel.setRefEntityPkValue((Object)row.getString(idField));
            modelList.add(refModel);
            if (callback == null) continue;
            callback.handleRowData(row);
        }
        return modelList;
    }

    private List<TreeNodeRefModel> loadBankCountryData() {
        return this.loadFinTreeNodeList("country", "country.name", "country.number", NODE_COUNTRY, new QFilter[0], row -> {
            String countryNumber = row.getString("country.number");
            this.getPageCache().put(KEY_COUNTRYNUM + row.getString("country"), countryNumber);
        });
    }

    private List<TreeNodeRefModel> loadBankAdminDivisionData(TreeNodeModel model) {
        String countryNumber;
        boolean isChinaMainland;
        TreeNodeTypeModel nodeType = model.getNodeType();
        Object refId = model.getRefEntityPkValue();
        List<TreeNodeRefModel> nodeList = NODE_COUNTRY.equals((Object)nodeType) ? ((isChinaMainland = CountryHelper.isChina((String)(countryNumber = this.getPageCache().get(KEY_COUNTRYNUM + model.getRefEntityPkValue())))) ? this.loadFinTreeNodeList("province", "province.name", "province.number", NODE_PROVINCE, new QFilter[]{this.getCountryFiler(refId)}, null) : this.loadFinTreeNodeList("city", "city.name", "city.number", NODE_CITY, new QFilter[]{this.getCountryFiler(refId)}, null)) : (NODE_PROVINCE.equals((Object)nodeType) ? this.loadFinTreeNodeList("city", "city.name", "city.number", NODE_CITY, new QFilter[]{this.getProvinceFilter(refId)}, null) : new ArrayList<TreeNodeRefModel>());
        return nodeList;
    }

    private QFilter getCountryFiler(Object countryId) {
        return new QFilter("country", "=", countryId);
    }

    private QFilter getProvinceFilter(Object provinceId) {
        return new QFilter("province", "=", provinceId);
    }

    private QFilter getCityFilter(Object cityId) {
        return new QFilter("city", "=", cityId);
    }

    @FunctionalInterface
    private static interface DatasetIteratorCallback {
        public void handleRowData(Row var1);
    }
}

