/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.List;
import kd.bd.assistant.helper.OrgHelper;
import kd.bos.context.RequestContext;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;

public class NetBankAcctListPlugin
extends AbstractListPlugin {
    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName = args.getFieldName();
        List<QFilter> customFilter = this.addCustomFilterForFilterCol(fieldName);
        if (!customFilter.isEmpty()) {
            args.setCustomQFilters(customFilter);
        }
        super.filterColumnSetFilter(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("company.name")) {
            args.getQfilters().addAll(this.getFilters());
        }
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        List<QFilter> qfilters = new ArrayList<QFilter>();
        switch (fieldName) {
            case "company.name": {
                qfilters = this.getFilters();
                break;
            }
        }
        return qfilters;
    }

    private List<QFilter> getFilters() {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        List<Long> authorizedBankOrgId = this.getAuthOrgIds();
        qfilters.add(new QFilter("id", "in", authorizedBankOrgId));
        return qfilters;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        List<Long> authOrgIds = this.getAuthOrgIds();
        qFilters.add(new QFilter("company.id", "in", authOrgIds));
    }

    private List<Long> getAuthOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return OrgHelper.getAuthorizedBankOrgId(Long.valueOf(RequestContext.get().getUserId()), appId, "bd_netbankacct", "47150e89000000ac");
    }
}

