/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.assistant.projectkind.ProjectKindTreeService;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ProjectEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String KIND = "group";
    private static final String PARENT = "parent";
    private static final String CREATEORG = "createorg";
    private static final String USEORG = "useorg";
    private static final String ORG = "org";
    private static final String OPERATE_SAVE = "save";
    private static final String OPERATE_SUBMIT = "submit";
    private static final String OPERATE_UNSUBMIT = "unsubmit";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String OPERATE_AUDIT = "audit";
    private static final String OPERATE_UNAUDIT = "unaudit";
    private static final String OPERATE_SAVEANDNEW = "saveandnew";
    private ProjectKindTreeService projectKindTreeService = new ProjectKindTreeService();

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long parentProId = (Long)this.getView().getFormShowParameter().getCustomParam("parentProId");
        if (parentProId != null) {
            this.getModel().setValue(PARENT, (Object)parentProId);
            DynamicObject parentPro = BusinessDataServiceHelper.loadSingle((Object)parentProId, (String)"bd_project");
            this.getModel().setValue(KIND, parentPro.get(KIND));
            return;
        }
        String projectKindId = (String)this.getView().getFormShowParameter().getCustomParam("projectKindId");
        if (StringUtils.isNotBlank((CharSequence)projectKindId) && !projectKindId.contains("-")) {
            this.getModel().setValue(KIND, (Object)projectKindId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "saveandnew": 
            case "submit": {
                OperationStatus status;
                DynamicObject project;
                DynamicObject parentNow = (DynamicObject)this.getModel().getValue(PARENT);
                Object pkId = this.getModel().getValue("id");
                boolean isSaved = QueryServiceHelper.exists((String)"bd_project", (Object)pkId);
                if (!isSaved && parentNow != null && (Long)parentNow.getPkValue() != 0L) {
                    DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentNow.getPkValue(), (String)"bd_project");
                    if (parent != null) {
                        parent.set("isleaf", (Object)false);
                        SaveServiceHelper.update((DynamicObject)parent);
                    }
                } else if (isSaved && (project = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bd_project")) != null) {
                    DynamicObject dbParent = project.getDynamicObject(PARENT);
                    DynamicObject parent = (DynamicObject)this.getModel().getValue(PARENT);
                    if (dbParent != null) {
                        Object oldParentPK = dbParent.getPkValue();
                        QFilter parentExMeFilter = new QFilter(PARENT, "=", oldParentPK);
                        parentExMeFilter.and(new QFilter("id", "!=", pkId));
                        DynamicObject[] bd_projects = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,parent", (QFilter[])parentExMeFilter.toArray());
                        if (bd_projects.length < 1) {
                            DynamicObject oldParent = BusinessDataServiceHelper.loadSingle((Object)oldParentPK, (String)"bd_project");
                            oldParent.set("isleaf", (Object)true);
                            SaveServiceHelper.update((DynamicObject)oldParent);
                        }
                    }
                    if (parent != null) {
                        Object newParentPK = parent.getPkValue();
                        DynamicObject newParent = BusinessDataServiceHelper.loadSingle((Object)newParentPK, (String)"bd_project");
                        if (newParent.getBoolean("isleaf")) {
                            newParent.set("isleaf", (Object)false);
                        }
                        SaveServiceHelper.update((DynamicObject)newParent);
                    }
                }
                Date begin = (Date)this.getModel().getValue("planbegindate");
                Date end = (Date)this.getModel().getValue("planenddate");
                if (begin != null && end != null && begin.after(end)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"ProjectEditPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if ((status = this.getView().getFormShowParameter().getStatus()) == null || !status.equals((Object)OperationStatus.EDIT)) break;
                Object id = this.getModel().getValue("id");
                DynamicObject oldPro = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bd_project");
                String longnumber = oldPro.getString("longnumber");
                DynamicObject parentPro = (DynamicObject)this.getModel().getValue(PARENT);
                if (parentPro == null) break;
                if (parentPro.getPkValue().toString().equals(id.toString())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u672c\u8eab\u4f5c\u4e3a\u4e0a\u7ea7", (String)"ProjectEditPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                if (!parentPro.getString("longnumber").startsWith(longnumber)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u4e0b\u7ea7\u8282\u70b9\u4f5c\u4e3a\u4e0a\u7ea7", (String)"ProjectEditPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            switch (operateKey) {
                case "submit": 
                case "unsubmit": 
                case "audit": 
                case "unaudit": {
                    this.getView().invokeOperation(OPERATE_REFRESH);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "createorg": {
                this.getModel().setValue(USEORG, newValue);
                this.getModel().setValue(ORG, newValue);
                break;
            }
            case "group": {
                DynamicObject parentProkind;
                DynamicObject parentPro = (DynamicObject)this.getModel().getValue(PARENT);
                if (parentPro == null || !((parentProkind = parentPro.getDynamicObject(KIND)) == null && newValue != null || parentProkind != null && newValue == null) && (parentProkind == null || newValue == null || parentProkind.getPkValue().equals(((DynamicObject)newValue).getPkValue()))) break;
                this.getModel().setValue(PARENT, null);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parentEdit = (BasedataEdit)this.getControl(PARENT);
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (key) {
            case "parent": {
                List<Long> permOrgList = this.getAllPermOrgsByPermItem("15", String.valueOf(RequestContext.get().getCurrUserId()), this.getView().getFormShowParameter().getAppId(), "bd_projectkind", "47150e89000000ac");
                List projectKindList = this.projectKindTreeService.getTreeDataByOrgList(permOrgList);
                List projectKindIds = projectKindList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
                List listFilters = param.getListFilterParameter().getQFilters();
                List treeFilters = param.getTreeFilterParameter().getQFilters();
                treeFilters.add(new QFilter("id", "in", projectKindIds));
                QFilter orgNotKindFilter = new QFilter(KIND, "=", (Object)0L);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_project", permOrgList, (boolean)false);
                orgNotKindFilter = orgNotKindFilter.and(baseDataFilter);
                QFilter kindFilter = new QFilter(KIND, "in", projectKindIds);
                listFilters.add(kindFilter.or(orgNotKindFilter));
                param.setCustomParam("ParentF7", (Object)true);
            }
        }
    }

    private List<Long> getAllPermOrgsByPermItem(String orgViewType, String userId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(userId), (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add(OrgUnitServiceHelper.getRootOrgId());
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        return result.getHasPermOrgs();
    }
}

